/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidAnyTagDescriptor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.AndroidUnknownAttributeInspection;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidElementNotAllowedInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        if (string == null) {
            AndroidElementNotAllowedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.element.not.allowed.name", new Object[0]);
        if (string == null) {
            AndroidElementNotAllowedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("AndroidElementNotAllowed" == null) {
            AndroidElementNotAllowedInspection.$$$reportNull$$$0(2);
        }
        return "AndroidElementNotAllowed";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            AndroidElementNotAllowedInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            AndroidElementNotAllowedInspection.$$$reportNull$$$0(4);
        }
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (AndroidUnknownAttributeInspection.isMyFile(facet, (XmlFile)file)) {
            MyVisitor visitor = new MyVisitor(manager, isOnTheFly);
            file.accept((PsiElementVisitor)visitor);
            return visitor.myResult.toArray(new ProblemDescriptor[visitor.myResult.size()]);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static boolean isUnknownCustomView(XmlTag tag) {
        ResourceFolderType type;
        PsiFile file = tag.getContainingFile();
        return file != null && (type = ResourceHelper.getFolderType(file)) == ResourceFolderType.LAYOUT && tag.getName().indexOf(46) != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidElementNotAllowedInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidElementNotAllowedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlTag(XmlTag tag) {
            XmlElementDescriptor descriptor;
            super.visitXmlTag(tag);
            if (tag.getNamespace().isEmpty() && (descriptor = tag.getDescriptor()) instanceof AndroidAnyTagDescriptor) {
                XmlToken endTagNameElement;
                XmlToken startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                if (startTagNameElement != null && !AndroidElementNotAllowedInspection.isUnknownCustomView(tag)) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)startTagNameElement, XmlErrorMessages.message((String)"element.is.not.allowed.here", (Object[])new Object[]{tag.getName()}), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                if ((endTagNameElement = XmlTagUtil.getEndTagNameElement((XmlTag)tag)) != null && !AndroidElementNotAllowedInspection.isUnknownCustomView(tag)) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)endTagNameElement, XmlErrorMessages.message((String)"element.is.not.allowed.here", (Object[])new Object[]{tag.getName()}), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }
    }
}

