/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.color.ColorSelector;
import org.jetbrains.android.dom.drawable.DrawableSelector;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.BoolElement;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.FractionElement;
import org.jetbrains.android.dom.resources.IntegerElement;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.Plurals;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.resources.ScalarResourceElement;
import org.jetbrains.android.dom.resources.StringArray;
import org.jetbrains.android.dom.resources.StringElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidResourceUtil");
    public static final Set<ResourceType> VALUE_RESOURCE_TYPES = EnumSet.of(ResourceType.DRAWABLE, new ResourceType[]{ResourceType.COLOR, ResourceType.DIMEN, ResourceType.STRING, ResourceType.STYLE, ResourceType.ARRAY, ResourceType.PLURALS, ResourceType.ID, ResourceType.BOOL, ResourceType.INTEGER, ResourceType.FRACTION, ResourceType.LAYOUT});
    public static final Set<ResourceType> ALL_VALUE_RESOURCE_TYPES = EnumSet.noneOf(ResourceType.class);
    public static final Set<ResourceType> REFERRABLE_RESOURCE_TYPES = EnumSet.noneOf(ResourceType.class);
    public static final Map<ResourceType, ResourceFolderType> XML_FILE_RESOURCE_TYPES = Maps.newEnumMap(ResourceType.class);
    static final String ROOT_TAG_PROPERTY = "ROOT_TAG";
    static final String LAYOUT_WIDTH_PROPERTY = "LAYOUT_WIDTH";
    static final String LAYOUT_HEIGHT_PROPERTY = "LAYOUT_HEIGHT";
    private static final String RESOURCE_CLASS_SUFFIX = ".R";
    public static final Comparator<PsiElement> RESOURCE_ELEMENT_COMPARATOR = (e1, e2) -> {
        PsiFile file2;
        if (e1 instanceof LazyValueResourceElementWrapper && e2 instanceof LazyValueResourceElementWrapper) {
            return ((LazyValueResourceElementWrapper)e1).compareTo((LazyValueResourceElementWrapper)e2);
        }
        PsiFile file1 = e1.getContainingFile();
        int delta = AndroidResourceUtil.compareResourceFiles(file1, file2 = e2.getContainingFile());
        if (delta != 0) {
            return delta;
        }
        return e1.getTextOffset() - e2.getTextOffset();
    };

    private AndroidResourceUtil() {
    }

    @NotNull
    public static String normalizeXmlResourceValue(@NotNull String value) {
        if (value == null) {
            AndroidResourceUtil.$$$reportNull$$$0(0);
        }
        String string = ValueXmlHelper.escapeResourceString((String)value, (boolean)false);
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String packageToRClass(@NotNull String packageName) {
        if (packageName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(2);
        }
        return packageName + RESOURCE_CLASS_SUFFIX;
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull String resourceName, boolean onlyInOwnPackages) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(3);
        }
        if (resClassName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(4);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(5);
        }
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resClassName, Collections.singleton(resourceName), onlyInOwnPackages);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(6);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull Collection<String> resourceNames, boolean onlyInOwnPackages) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(7);
        }
        if (resClassName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(8);
        }
        if (resourceNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        for (PsiClass rClass : AndroidResourceUtil.findRJavaClasses(facet, onlyInOwnPackages)) {
            AndroidResourceUtil.findResourceFieldsFromClass(rClass, resClassName, resourceNames, result);
        }
        PsiField[] psiFieldArray = result.toArray(new PsiField[result.size()]);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(10);
        }
        return psiFieldArray;
    }

    private static void findResourceFieldsFromClass(@NotNull PsiClass rClass, @NotNull String resClassName, @NotNull Collection<String> resourceNames, @NotNull List<PsiField> result) {
        PsiClass resourceTypeClass;
        if (rClass == null) {
            AndroidResourceUtil.$$$reportNull$$$0(11);
        }
        if (resClassName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(12);
        }
        if (resourceNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(13);
        }
        if (result == null) {
            AndroidResourceUtil.$$$reportNull$$$0(14);
        }
        if ((resourceTypeClass = rClass.findInnerClassByName(resClassName, false)) != null) {
            for (String resourceName : resourceNames) {
                String fieldName = AndroidResourceUtil.getRJavaFieldName(resourceName);
                PsiField field = resourceTypeClass.findFieldByName(fieldName, false);
                if (field == null) continue;
                result.add(field);
            }
        }
    }

    @NotNull
    private static Set<PsiClass> findRJavaClasses(@NotNull AndroidFacet facet, boolean onlyInOwnPackages) {
        String targetPackage;
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(15);
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        if (facet.getManifest() == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                AndroidResourceUtil.$$$reportNull$$$0(16);
            }
            return set;
        }
        Graph graph = ModuleManager.getInstance((Project)project).moduleGraph();
        HashSet dependentModules = Sets.newHashSet();
        AndroidResourceUtil.collectDependentModules((Graph<Module>)graph, module, dependentModules);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        HashSet rClasses = Sets.newHashSet();
        String string = targetPackage = onlyInOwnPackages ? null : AndroidResourceUtil.manifestPackageForModule(module);
        if (targetPackage != null) {
            GlobalSearchScope[] scopes = new GlobalSearchScope[dependentModules.size()];
            int i = 0;
            for (Module dependentModule : dependentModules) {
                scopes[i++] = dependentModule.getModuleScope();
            }
            rClasses.addAll(Arrays.asList(psiFacade.findClasses(AndroidResourceUtil.packageToRClass(targetPackage), GlobalSearchScope.union((GlobalSearchScope[])scopes))));
        }
        for (Module dependentModule : dependentModules) {
            String dependentPackage = AndroidResourceUtil.manifestPackageForModule(dependentModule);
            if (dependentPackage == null || dependentPackage.equals(targetPackage)) continue;
            rClasses.addAll(Arrays.asList(psiFacade.findClasses(AndroidResourceUtil.packageToRClass(dependentPackage), dependentModule.getModuleScope())));
        }
        HashSet hashSet = rClasses;
        if (hashSet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @Nullable
    private static String manifestPackageForModule(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidResourceUtil.$$$reportNull$$$0(18);
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return null;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return null;
        }
        return (String)manifest.getPackage().getValue();
    }

    private static void collectDependentModules(@NotNull Graph<Module> graph, @NotNull Module module, @NotNull Set<Module> result) {
        if (graph == null) {
            AndroidResourceUtil.$$$reportNull$$$0(19);
        }
        if (module == null) {
            AndroidResourceUtil.$$$reportNull$$$0(20);
        }
        if (result == null) {
            AndroidResourceUtil.$$$reportNull$$$0(21);
        }
        if (result.contains(module)) {
            return;
        }
        result.add(module);
        Iterator out = graph.getOut((Object)module);
        while (out.hasNext()) {
            AndroidResourceUtil.collectDependentModules(graph, (Module)out.next(), result);
        }
    }

    @NotNull
    public static PsiField[] findResourceFieldsForFileResource(@NotNull PsiFile file, boolean onlyInOwnPackages) {
        AndroidFacet facet;
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(22);
        }
        if ((facet = AndroidFacet.getInstance((PsiElement)file)) == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(23);
            }
            return PsiField.EMPTY_ARRAY;
        }
        String resourceType = facet.getLocalResourceManager().getFileResourceType(file);
        if (resourceType == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(24);
            }
            return PsiField.EMPTY_ARRAY;
        }
        String resourceName = AndroidCommonUtils.getResourceName((String)resourceType, (String)file.getName());
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resourceType, resourceName, onlyInOwnPackages);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(25);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findResourceFieldsForValueResource(XmlTag tag, boolean onlyInOwnPackages) {
        String resourceType;
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
        if (facet == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(26);
            }
            return PsiField.EMPTY_ARRAY;
        }
        ResourceFolderType fileResType = ResourceHelper.getFolderType(tag.getContainingFile());
        String string = resourceType = fileResType == ResourceFolderType.VALUES ? AndroidResourceUtil.getResourceTypeByValueResourceTag(tag) : null;
        if (resourceType == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(27);
            }
            return PsiField.EMPTY_ARRAY;
        }
        String name = tag.getAttributeValue("name");
        if (name == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                AndroidResourceUtil.$$$reportNull$$$0(28);
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resourceType, name, onlyInOwnPackages);
        if (psiFieldArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(29);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findStyleableAttributeFields(XmlTag tag, boolean onlyInOwnPackages) {
        XmlTag parentTag;
        String tagName = tag.getName();
        if ("declare-styleable".equals(tagName)) {
            String styleableName = tag.getAttributeValue("name");
            if (styleableName == null) {
                if (PsiField.EMPTY_ARRAY == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(30);
                }
                return PsiField.EMPTY_ARRAY;
            }
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet == null) {
                if (PsiField.EMPTY_ARRAY == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(31);
                }
                return PsiField.EMPTY_ARRAY;
            }
            HashSet names = Sets.newHashSet();
            for (XmlTag attr : tag.getSubTags()) {
                String attrName;
                if (!"attr".equals(attr.getName()) || (attrName = attr.getAttributeValue("name")) == null) continue;
                names.add(styleableName + '_' + attrName);
            }
            if (!names.isEmpty()) {
                PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), names, onlyInOwnPackages);
                if (psiFieldArray == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(32);
                }
                return psiFieldArray;
            }
        } else if ("attr".equals(tagName) && (parentTag = tag.getParentTag()) != null && "declare-styleable".equals(parentTag.getName())) {
            String styleName = parentTag.getAttributeValue("name");
            String attributeName = tag.getAttributeValue("name");
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet != null && styleName != null && attributeName != null) {
                PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), styleName + '_' + attributeName, onlyInOwnPackages);
                if (psiFieldArray == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(33);
                }
                return psiFieldArray;
            }
        }
        if (PsiField.EMPTY_ARRAY == null) {
            AndroidResourceUtil.$$$reportNull$$$0(34);
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public static String getRJavaFieldName(@NotNull String resourceName) {
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(35);
        }
        if (resourceName.indexOf(46) == -1) {
            String string = resourceName;
            if (string == null) {
                AndroidResourceUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        String[] identifiers = resourceName.split("\\.");
        StringBuilder result = new StringBuilder(resourceName.length());
        int n = identifiers.length;
        for (int i = 0; i < n; ++i) {
            result.append(identifiers[i]);
            if (i >= n - 1) continue;
            result.append('_');
        }
        String string = result.toString();
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    public static boolean isCorrectAndroidResourceName(@NotNull String resourceName) {
        String[] identifiers;
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(38);
        }
        if (resourceName.length() == 0) {
            return false;
        }
        if (resourceName.startsWith(".") || resourceName.endsWith(".")) {
            return false;
        }
        for (String identifier : identifiers = resourceName.split("\\.")) {
            if (StringUtil.isJavaIdentifier((String)identifier)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String getResourceTypeByValueResourceTag(@NotNull XmlTag tag) {
        String resClassName;
        if (tag == null) {
            AndroidResourceUtil.$$$reportNull$$$0(39);
        }
        String string = resClassName = (resClassName = tag.getName()).equals("item") ? tag.getAttributeValue("type", null) : AndroidCommonUtils.getResourceTypeByTagName((String)resClassName);
        if (resClassName != null) {
            String resourceName = tag.getAttributeValue("name");
            return resourceName != null ? resClassName : null;
        }
        return null;
    }

    @Nullable
    public static ResourceType getResourceForResourceTag(@NotNull XmlTag tag) {
        String typeName;
        if (tag == null) {
            AndroidResourceUtil.$$$reportNull$$$0(40);
        }
        if ((typeName = AndroidResourceUtil.getResourceTypeByValueResourceTag(tag)) != null) {
            return ResourceType.getEnum((String)typeName);
        }
        return null;
    }

    @Nullable
    public static String getResourceClassName(@NotNull PsiField field) {
        PsiClass parentClass;
        PsiClass resourceClass;
        if (field == null) {
            AndroidResourceUtil.$$$reportNull$$$0(41);
        }
        if ((resourceClass = field.getContainingClass()) != null && (parentClass = resourceClass.getContainingClass()) != null && "R".equals(parentClass.getName()) && parentClass.getContainingClass() == null) {
            return resourceClass.getName();
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> findResourcesByField(@NotNull PsiField field) {
        AndroidFacet facet;
        if (field == null) {
            AndroidResourceUtil.$$$reportNull$$$0(42);
        }
        List<PsiElement> list = (facet = AndroidFacet.getInstance((PsiElement)field)) != null ? facet.getLocalResourceManager().findResourcesByField(field) : Collections.emptyList();
        if (list == null) {
            AndroidResourceUtil.$$$reportNull$$$0(43);
        }
        return list;
    }

    public static boolean isResourceField(@NotNull PsiField field) {
        PsiFile file;
        AndroidFacet facet;
        PsiClass c;
        if (field == null) {
            AndroidResourceUtil.$$$reportNull$$$0(44);
        }
        if ((c = field.getContainingClass()) == null) {
            return false;
        }
        return (c = c.getContainingClass()) != null && "R".equals(c.getName()) && (facet = AndroidFacet.getInstance((PsiElement)field)) != null && (file = c.getContainingFile()) != null && AndroidResourceUtil.isRJavaFile(facet, file);
    }

    public static boolean isStringResource(@NotNull XmlTag tag) {
        if (tag == null) {
            AndroidResourceUtil.$$$reportNull$$$0(45);
        }
        return tag.getName().equals("string") && tag.getAttribute("name") != null;
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttributeValue value) {
        if (value == null) {
            AndroidResourceUtil.$$$reportNull$$$0(46);
        }
        if (value.getParent() instanceof XmlAttribute) {
            PsiField[] psiFieldArray = AndroidResourceUtil.findIdFields((XmlAttribute)value.getParent());
            if (psiFieldArray == null) {
                AndroidResourceUtil.$$$reportNull$$$0(47);
            }
            return psiFieldArray;
        }
        if (PsiField.EMPTY_ARRAY == null) {
            AndroidResourceUtil.$$$reportNull$$$0(48);
        }
        return PsiField.EMPTY_ARRAY;
    }

    public static boolean isIdDeclaration(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@+id/");
    }

    public static boolean isIdReference(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@id/");
    }

    public static boolean isIdDeclaration(@NotNull XmlAttributeValue value) {
        if (value == null) {
            AndroidResourceUtil.$$$reportNull$$$0(49);
        }
        return AndroidResourceUtil.isIdDeclaration(value.getValue());
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttribute attribute) {
        AndroidFacet facet;
        String id;
        XmlAttributeValue value;
        if (attribute == null) {
            AndroidResourceUtil.$$$reportNull$$$0(50);
        }
        if ((value = attribute.getValueElement()) != null && AndroidResourceUtil.isIdDeclaration(value) && (id = AndroidResourceUtil.getResourceNameByReferenceText(attribute.getValue())) != null && (facet = AndroidFacet.getInstance((PsiElement)attribute)) != null) {
            PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.ID.getName(), id, false);
            if (psiFieldArray == null) {
                AndroidResourceUtil.$$$reportNull$$$0(51);
            }
            return psiFieldArray;
        }
        if (PsiField.EMPTY_ARRAY == null) {
            AndroidResourceUtil.$$$reportNull$$$0(52);
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public static String getValidResourceFileName(@NotNull String base) {
        if (base == null) {
            AndroidResourceUtil.$$$reportNull$$$0(53);
        }
        String string = base.replace('-', '_').toLowerCase(Locale.US);
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    @Nullable
    public static String getResourceNameByReferenceText(@NotNull String text) {
        int i;
        if (text == null) {
            AndroidResourceUtil.$$$reportNull$$$0(55);
        }
        if ((i = text.indexOf(47)) < text.length() - 1) {
            return text.substring(i + 1, text.length());
        }
        return null;
    }

    @NotNull
    public static ResourceElement addValueResource(@NotNull ResourceType resType, @NotNull Resources resources, @Nullable String value) {
        if (resType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(56);
        }
        if (resources == null) {
            AndroidResourceUtil.$$$reportNull$$$0(57);
        }
        switch (resType) {
            case STRING: {
                StringElement stringElement = resources.addString();
                if (stringElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(58);
                }
                return stringElement;
            }
            case PLURALS: {
                Plurals plurals = resources.addPlurals();
                if (plurals == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(59);
                }
                return plurals;
            }
            case DIMEN: {
                if (value != null && value.trim().endsWith("%")) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    Item item2 = item;
                    if (item2 == null) {
                        AndroidResourceUtil.$$$reportNull$$$0(60);
                    }
                    return item2;
                }
                if (value != null && value.indexOf(46) > 0) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    item.getFormat().setStringValue("float");
                    Item item3 = item;
                    if (item3 == null) {
                        AndroidResourceUtil.$$$reportNull$$$0(61);
                    }
                    return item3;
                }
                ScalarResourceElement scalarResourceElement = resources.addDimen();
                if (scalarResourceElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(62);
                }
                return scalarResourceElement;
            }
            case COLOR: {
                ScalarResourceElement scalarResourceElement = resources.addColor();
                if (scalarResourceElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(63);
                }
                return scalarResourceElement;
            }
            case DRAWABLE: {
                ScalarResourceElement scalarResourceElement = resources.addDrawable();
                if (scalarResourceElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(64);
                }
                return scalarResourceElement;
            }
            case STYLE: {
                Style style = resources.addStyle();
                if (style == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(65);
                }
                return style;
            }
            case ARRAY: {
                StringArray stringArray = resources.addStringArray();
                if (stringArray == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(66);
                }
                return stringArray;
            }
            case INTEGER: {
                IntegerElement integerElement = resources.addInteger();
                if (integerElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(67);
                }
                return integerElement;
            }
            case FRACTION: {
                FractionElement fractionElement = resources.addFraction();
                if (fractionElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(68);
                }
                return fractionElement;
            }
            case BOOL: {
                BoolElement boolElement = resources.addBool();
                if (boolElement == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(69);
                }
                return boolElement;
            }
            case ID: {
                Item item = resources.addItem();
                item.getType().setValue((Object)ResourceType.ID.getName());
                Item item4 = item;
                if (item4 == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(70);
                }
                return item4;
            }
            case ATTR: {
                Attr attr = resources.addAttr();
                if (attr == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(71);
                }
                return attr;
            }
            case STYLEABLE: {
                DeclareStyleable declareStyleable = resources.addDeclareStyleable();
                if (declareStyleable == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(72);
                }
                return declareStyleable;
            }
        }
        throw new IllegalArgumentException("Incorrect resource type");
    }

    @NotNull
    public static List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType, @NotNull VirtualFile[] resourceDirs) {
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(73);
        }
        if (resourceDirs == null) {
            AndroidResourceUtil.$$$reportNull$$$0(74);
        }
        ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
        for (VirtualFile resourcesDir : resourceDirs) {
            if (resourcesDir == null || !resourcesDir.isValid()) continue;
            for (VirtualFile child : resourcesDir.getChildren()) {
                ResourceFolderType type = ResourceFolderType.getFolderType((String)child.getName());
                if (!resourceType.equals((Object)type)) continue;
                dirs.add(child);
            }
        }
        ArrayList<VirtualFile> arrayList = dirs;
        if (arrayList == null) {
            AndroidResourceUtil.$$$reportNull$$$0(75);
        }
        return arrayList;
    }

    @Nullable
    public static String getDefaultResourceFileName(@NotNull ResourceType type) {
        if (type == null) {
            AndroidResourceUtil.$$$reportNull$$$0(76);
        }
        if (ResourceType.PLURALS == type || ResourceType.STRING == type) {
            return "strings.xml";
        }
        if (VALUE_RESOURCE_TYPES.contains(type)) {
            if (type == ResourceType.LAYOUT || type == ResourceType.DRAWABLE && !ApplicationManager.getApplication().isUnitTestMode()) {
                return "refs.xml";
            }
            return type.getName() + "s.xml";
        }
        if (ResourceType.ATTR == type || ResourceType.STYLEABLE == type) {
            return "attrs.xml";
        }
        return null;
    }

    @NotNull
    public static List<ResourceElement> getValueResourcesFromElement(@NotNull ResourceType resourceType, @NotNull Resources resources) {
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(77);
        }
        if (resources == null) {
            AndroidResourceUtil.$$$reportNull$$$0(78);
        }
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        switch (resourceType) {
            case STRING: {
                result.addAll(resources.getStrings());
                break;
            }
            case PLURALS: {
                result.addAll(resources.getPluralses());
                break;
            }
            case DRAWABLE: {
                result.addAll(resources.getDrawables());
                break;
            }
            case COLOR: {
                result.addAll(resources.getColors());
                break;
            }
            case DIMEN: {
                result.addAll(resources.getDimens());
                break;
            }
            case STYLE: {
                result.addAll(resources.getStyles());
                break;
            }
            case ARRAY: {
                result.addAll(resources.getStringArrays());
                result.addAll(resources.getIntegerArrays());
                result.addAll(resources.getArrays());
                break;
            }
            case INTEGER: {
                result.addAll(resources.getIntegers());
                break;
            }
            case FRACTION: {
                result.addAll(resources.getFractions());
                break;
            }
            case BOOL: {
                result.addAll(resources.getBools());
            }
        }
        for (Item item : resources.getItems()) {
            String type = (String)item.getType().getValue();
            if (!resourceType.getName().equals(type)) continue;
            result.add(item);
        }
        ArrayList<ResourceElement> arrayList = result;
        if (arrayList == null) {
            AndroidResourceUtil.$$$reportNull$$$0(79);
        }
        return arrayList;
    }

    public static boolean isInResourceSubdirectory(@NotNull PsiFile file, @Nullable String resourceType) {
        PsiDirectory dir;
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(80);
        }
        if ((dir = (file = file.getOriginalFile()).getContainingDirectory()) == null) {
            return false;
        }
        return AndroidResourceUtil.isResourceSubdirectory(dir, resourceType);
    }

    public static boolean isResourceSubdirectory(@NotNull PsiDirectory directory, @Nullable String resourceType) {
        if (directory == null) {
            AndroidResourceUtil.$$$reportNull$$$0(81);
        }
        PsiDirectory dir = directory;
        String dirName = dir.getName();
        if (resourceType != null && !dirName.equals(resourceType) && !dirName.startsWith(resourceType + '-')) {
            return false;
        }
        if ((dir = dir.getParent()) == null) {
            return false;
        }
        if ("default".equals(dir.getName())) {
            dir = dir.getParentDirectory();
        }
        return dir != null && AndroidResourceUtil.isResourceDirectory(dir);
    }

    public static boolean isLocalResourceDirectory(@NotNull VirtualFile dir, @NotNull Project project) {
        Module module;
        if (dir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(82);
        }
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(83);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)project)) != null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && facet.getLocalResourceManager().isResourceDir(dir);
        }
        return false;
    }

    public static boolean isResourceFile(@NotNull VirtualFile file, @NotNull AndroidFacet facet) {
        VirtualFile parent;
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(84);
        }
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(85);
        }
        VirtualFile resDir = (parent = file.getParent()) != null ? parent.getParent() : null;
        return resDir != null && facet.getLocalResourceManager().isResourceDir(resDir);
    }

    public static boolean isResourceDirectory(@NotNull PsiDirectory directory) {
        PsiDirectory dir;
        VirtualFile vf;
        if (directory == null) {
            AndroidResourceUtil.$$$reportNull$$$0(86);
        }
        if (AndroidResourceUtil.isLocalResourceDirectory(vf = (dir = directory).getVirtualFile(), dir.getProject())) {
            return true;
        }
        if (!"res".equals(dir.getName())) {
            return false;
        }
        if ((dir = dir.getParent()) != null) {
            if (dir.findFile("AndroidManifest.xml") != null) {
                return true;
            }
            if ((dir = dir.getParent()) != null) {
                if (AndroidResourceUtil.containsAndroidJar(dir)) {
                    return true;
                }
                if ((dir = dir.getParent()) != null) {
                    return AndroidResourceUtil.containsAndroidJar(dir);
                }
            }
        }
        return false;
    }

    private static boolean containsAndroidJar(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            AndroidResourceUtil.$$$reportNull$$$0(87);
        }
        return psiDirectory.findFile("android.jar") != null;
    }

    public static boolean isRJavaFile(@NotNull AndroidFacet facet, @NotNull PsiFile file) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(88);
        }
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(89);
        }
        if (file.getName().equals("R.java") && file instanceof PsiJavaFile) {
            String manifestPackage;
            PsiJavaFile javaFile = (PsiJavaFile)file;
            Manifest manifest = facet.getManifest();
            if (manifest != null && (manifestPackage = (String)manifest.getPackage().getValue()) != null && javaFile.getPackageName().equals(manifestPackage)) {
                return true;
            }
            for (String aPackage : AndroidUtils.getDepLibsPackages(facet.getModule())) {
                if (!javaFile.getPackageName().equals(aPackage)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isManifestJavaFile(@NotNull AndroidFacet facet, @NotNull PsiFile file) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(90);
        }
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(91);
        }
        if (file.getName().equals("Manifest.java") && file instanceof PsiJavaFile) {
            Manifest manifest = facet.getManifest();
            PsiJavaFile javaFile = (PsiJavaFile)file;
            return manifest != null && javaFile.getPackageName().equals(manifest.getPackage().getValue());
        }
        return false;
    }

    public static List<String> getNames(@NotNull Collection<ResourceType> resourceTypes) {
        if (resourceTypes == null) {
            AndroidResourceUtil.$$$reportNull$$$0(92);
        }
        if (resourceTypes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType type : resourceTypes) {
            result.add(type.getName());
        }
        return result;
    }

    @NotNull
    public static String[] getNamesArray(@NotNull Collection<ResourceType> resourceTypes) {
        if (resourceTypes == null) {
            AndroidResourceUtil.$$$reportNull$$$0(93);
        }
        List<String> names = AndroidResourceUtil.getNames(resourceTypes);
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            AndroidResourceUtil.$$$reportNull$$$0(94);
        }
        return stringArray;
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @Nullable String resourceValue, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull Processor<ResourceElement> afterAddedProcessor) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(95);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(96);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(97);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(98);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(99);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(100);
        }
        if (afterAddedProcessor == null) {
            AndroidResourceUtil.$$$reportNull$$$0(101);
        }
        try {
            return AndroidResourceUtil.addValueResource(project, resDir, resourceName, resourceType, fileName, dirNames, resourceValue, afterAddedProcessor);
        }
        catch (Exception e) {
            String message = CreateElementActionBase.filterMessage((String)e.getMessage());
            if (message == null || message.length() == 0) {
                LOG.error((Throwable)e);
            } else {
                LOG.info((Throwable)e);
                AndroidUtils.reportError(project, message);
            }
            return false;
        }
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull String value) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(102);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(103);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(104);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(105);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(106);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(107);
        }
        if (value == null) {
            AndroidResourceUtil.$$$reportNull$$$0(108);
        }
        return AndroidResourceUtil.createValueResource(project, resDir, resourceName, resourceType, fileName, dirNames, value, null);
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull String value, @Nullable List<ResourceElement> outTags) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(109);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(110);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(111);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(112);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(113);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(114);
        }
        if (value == null) {
            AndroidResourceUtil.$$$reportNull$$$0(115);
        }
        return AndroidResourceUtil.createValueResource(project, resDir, resourceName, value, resourceType, fileName, dirNames, (Processor<ResourceElement>)((Processor)element -> {
            if (value == null) {
                AndroidResourceUtil.$$$reportNull$$$0(169);
            }
            if (resourceType == null) {
                AndroidResourceUtil.$$$reportNull$$$0(170);
            }
            if (value.length() > 0) {
                String s = resourceType == ResourceType.STRING ? AndroidResourceUtil.normalizeXmlResourceValue(value) : value;
                element.setStringValue(s);
            } else if (resourceType == ResourceType.STYLEABLE || resourceType == ResourceType.STYLE) {
                element.setStringValue("value");
                element.getXmlTag().getValue().setText("");
            }
            if (outTags != null) {
                outTags.add((ResourceElement)element);
            }
            return true;
        }));
    }

    private static boolean addValueResource(@NotNull Project project, @NotNull VirtualFile resDir, final @NotNull String resourceName, final @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, final @Nullable String resourceValue, final @NotNull Processor<ResourceElement> afterAddedProcessor) throws Exception {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(116);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(117);
        }
        if (resourceName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(118);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(119);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(120);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(121);
        }
        if (afterAddedProcessor == null) {
            AndroidResourceUtil.$$$reportNull$$$0(122);
        }
        if (dirNames.size() == 0) {
            return false;
        }
        VirtualFile[] resFiles = new VirtualFile[dirNames.size()];
        int n = dirNames.size();
        for (int i = 0; i < n; ++i) {
            String dirName = dirNames.get(i);
            resFiles[i] = (VirtualFile)WriteAction.compute(() -> {
                if (project == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(166);
                }
                if (resDir == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(167);
                }
                if (fileName == null) {
                    AndroidResourceUtil.$$$reportNull$$$0(168);
                }
                return AndroidResourceUtil.findOrCreateResourceFile(project, resDir, fileName, dirName);
            });
            if (resFiles[i] != null) continue;
            return false;
        }
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])resFiles)) {
            return false;
        }
        final Resources[] resourcesElements = new Resources[resFiles.length];
        for (int i = 0; i < resFiles.length; ++i) {
            Resources resources = AndroidUtils.loadDomElement(project, resFiles[i], Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.length);
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] files = psiFiles.toArray(new PsiFile[psiFiles.size()]);
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(project, "Add Resource", files){

            protected void run(@NotNull Result<Void> result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Resources resources : resourcesElements) {
                    ResourceElement element = AndroidResourceUtil.addValueResource(resourceType, resources, resourceValue);
                    element.getName().setValue((Object)resourceName);
                    afterAddedProcessor.process((Object)element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$1", "run"));
            }
        };
        action.execute();
        return true;
    }

    public static boolean changeValueResource(final @NotNull Project project, @NotNull VirtualFile resDir, final @NotNull String name, final @NotNull ResourceType resourceType, final @NotNull String newValue, @NotNull String fileName, @NotNull List<String> dirNames, final boolean useGlobalCommand) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(123);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(124);
        }
        if (name == null) {
            AndroidResourceUtil.$$$reportNull$$$0(125);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(126);
        }
        if (newValue == null) {
            AndroidResourceUtil.$$$reportNull$$$0(127);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(128);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(129);
        }
        if (dirNames.isEmpty()) {
            return false;
        }
        ArrayList resFiles = Lists.newArrayListWithExpectedSize((int)dirNames.size());
        for (String dirName : dirNames) {
            VirtualFile resFile = AndroidResourceUtil.findResourceFile(resDir, fileName, dirName);
            if (resFile == null) continue;
            resFiles.add(resFile);
        }
        if (!AndroidResourceUtil.ensureFilesWritable(project, resFiles)) {
            return false;
        }
        final Resources[] resourcesElements = new Resources[resFiles.size()];
        for (int i = 0; i < resFiles.size(); ++i) {
            Resources resources = AndroidUtils.loadDomElement(project, (VirtualFile)resFiles.get(i), Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] files = psiFiles.toArray(new PsiFile[psiFiles.size()]);
        WriteCommandAction<Boolean> action = new WriteCommandAction<Boolean>(project, "Change " + resourceType.getName() + " Resource", files){

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (useGlobalCommand) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                }
                result.setResult((Object)false);
                for (Resources resources : resourcesElements) {
                    for (ResourceElement element : AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources)) {
                        String value = element.getName().getStringValue();
                        if (!name.equals(value)) continue;
                        element.setStringValue(newValue);
                        result.setResult((Object)true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$2", "run"));
            }
        };
        return (Boolean)action.execute().getResultObject();
    }

    @Nullable
    private static VirtualFile findResourceFile(@NotNull VirtualFile resDir, @NotNull String fileName, @NotNull String dirName) {
        VirtualFile dir;
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(130);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(131);
        }
        if (dirName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(132);
        }
        if ((dir = resDir.findChild(dirName)) == null) {
            return null;
        }
        return dir.findChild(fileName);
    }

    @Nullable
    private static VirtualFile findOrCreateResourceFile(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String fileName, @NotNull String dirName) throws Exception {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(133);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(134);
        }
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(135);
        }
        if (dirName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(136);
        }
        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
        if (dir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.dir.error", dirPath));
            return null;
        }
        VirtualFile file = dir.findChild(fileName);
        if (file != null) {
            return file;
        }
        AndroidFileTemplateProvider.createFromTemplate(project, dir, "valueResourceFile.xml", fileName);
        VirtualFile result = dir.findChild(fileName);
        if (result == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.file.error", dirPath + File.separatorChar + fileName));
        }
        return result;
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, boolean localOnly) {
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(137);
        }
        if (exp == null) {
            AndroidResourceUtil.$$$reportNull$$$0(138);
        }
        return AndroidResourceUtil.getReferredResourceOrManifestField(facet, exp, null, localOnly);
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, @Nullable String className, boolean localOnly) {
        String qName;
        String resFieldName;
        if (facet == null) {
            AndroidResourceUtil.$$$reportNull$$$0(139);
        }
        if (exp == null) {
            AndroidResourceUtil.$$$reportNull$$$0(140);
        }
        if ((resFieldName = exp.getReferenceName()) == null || resFieldName.length() == 0) {
            return null;
        }
        PsiExpression qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression resClassReference = (PsiReferenceExpression)qExp;
        String resClassName = resClassReference.getReferenceName();
        if (resClassName == null || resClassName.length() == 0 || className != null && !className.equals(resClassName)) {
            return null;
        }
        qExp = resClassReference.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolvedElement = ((PsiReferenceExpression)qExp).resolve();
        if (!(resolvedElement instanceof PsiClass)) {
            return null;
        }
        Module resolvedModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)resolvedElement);
        PsiClass aClass = (PsiClass)resolvedElement;
        String classShortName = aClass.getName();
        boolean fromManifest = "Manifest".equals(classShortName);
        if (!fromManifest && !"R".equals(classShortName)) {
            return null;
        }
        if (!localOnly && ("android.R".equals(qName = aClass.getQualifiedName()) || "com.android.internal.R".equals(qName))) {
            return new MyReferredResourceFieldInfo(resClassName, resFieldName, resolvedModule, true, false);
        }
        PsiFile containingFile = resolvedElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (fromManifest ? !AndroidResourceUtil.isManifestJavaFile(facet, containingFile) : !AndroidResourceUtil.isRJavaFile(facet, containingFile)) {
            return null;
        }
        return new MyReferredResourceFieldInfo(resClassName, resFieldName, resolvedModule, false, fromManifest);
    }

    public static int compareResourceFiles(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        if (file1 != null && file1.equals(file2) || file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            VirtualFile parent1 = file1.getParent();
            VirtualFile parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getPath().compareTo(file2.getPath());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static int compareResourceFiles(@Nullable PsiFile file1, @Nullable PsiFile file2) {
        if (file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            PsiDirectory parent1 = file1.getParent();
            PsiDirectory parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && parent1 != parent2) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getName().compareTo(file2.getName());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(141);
        }
        if (files == null) {
            AndroidResourceUtil.$$$reportNull$$$0(142);
        }
        return !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files).hasReadonlyFiles();
    }

    @Nullable
    public static ResourceType getType(@NotNull XmlTag node) {
        if (node == null) {
            AndroidResourceUtil.$$$reportNull$$$0(143);
        }
        String nodeName = node.getLocalName();
        String typeString = null;
        if ("item".equals(nodeName)) {
            String attribute = node.getAttributeValue("type");
            if (attribute != null) {
                typeString = attribute;
            }
        } else {
            typeString = nodeName;
        }
        return typeString == null ? null : ResourceType.getEnum((String)typeString);
    }

    @NotNull
    public static XmlFile createFileResource(@NotNull String fileName, @NotNull PsiDirectory resSubdir, @NotNull String rootTagName, @NotNull String resourceType, boolean valuesResourceFile) throws Exception {
        if (fileName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(144);
        }
        if (resSubdir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(145);
        }
        if (rootTagName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(146);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(147);
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)resSubdir.getProject());
        String templateName = AndroidResourceUtil.getTemplateName(resourceType, valuesResourceFile, rootTagName);
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        Properties properties = new Properties();
        if (!valuesResourceFile) {
            properties.setProperty(ROOT_TAG_PROPERTY, rootTagName);
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resSubdir);
            AndroidPlatform platform = module != null ? AndroidPlatform.getInstance(module) : null;
            int apiLevel = platform != null ? platform.getApiLevel() : -1;
            String value = apiLevel == -1 || apiLevel >= 8 ? "match_parent" : "fill_parent";
            properties.setProperty(LAYOUT_WIDTH_PROPERTY, value);
            properties.setProperty(LAYOUT_HEIGHT_PROPERTY, value);
        }
        PsiElement createdElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)resSubdir);
        assert (createdElement instanceof XmlFile);
        XmlFile xmlFile = (XmlFile)createdElement;
        if (xmlFile == null) {
            AndroidResourceUtil.$$$reportNull$$$0(148);
        }
        return xmlFile;
    }

    private static String getTemplateName(String resourceType, boolean valuesResourceFile, String rootTagName) {
        if (valuesResourceFile) {
            return "valueResourceFile.xml";
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType)) {
            return "LinearLayout".equals(rootTagName) ? "layoutResourceFile_vertical.xml" : "layoutResourceFile.xml";
        }
        return "resourceFile.xml";
    }

    @NotNull
    public static String getFieldNameByResourceName(@NotNull String styleName) {
        if (styleName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(149);
        }
        int n = styleName.length();
        for (int i = 0; i < n; ++i) {
            char c = styleName.charAt(i);
            if (c != '.' && c != '-' && c != ':') continue;
            String string = styleName.replace('.', '_').replace('-', '_').replace(':', '_');
            if (string == null) {
                AndroidResourceUtil.$$$reportNull$$$0(150);
            }
            return string;
        }
        String string = styleName;
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(151);
        }
        return string;
    }

    @Nullable
    public static List<VirtualFile> findOrCreateStateListFiles(final @NotNull Project project, final @NotNull VirtualFile resDir, final @NotNull ResourceFolderType folderType, final @NotNull ResourceType resourceType, final @NotNull String stateListName, final @NotNull List<String> dirNames) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(152);
        }
        if (resDir == null) {
            AndroidResourceUtil.$$$reportNull$$$0(153);
        }
        if (folderType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(154);
        }
        if (resourceType == null) {
            AndroidResourceUtil.$$$reportNull$$$0(155);
        }
        if (stateListName == null) {
            AndroidResourceUtil.$$$reportNull$$$0(156);
        }
        if (dirNames == null) {
            AndroidResourceUtil.$$$reportNull$$$0(157);
        }
        final PsiManager manager = PsiManager.getInstance((Project)project);
        final ArrayList files = Lists.newArrayListWithCapacity((int)dirNames.size());
        boolean foundFiles = (Boolean)new WriteCommandAction<Boolean>(project, "Find statelists files", new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) {
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                result.setResult((Object)true);
                try {
                    String fileName = stateListName;
                    if (!stateListName.endsWith(".xml")) {
                        fileName = fileName + ".xml";
                    }
                    for (String dirName : dirNames) {
                        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
                        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
                        if (dir == null) {
                            throw new IOException("cannot make " + resDir + File.separatorChar + dirName);
                        }
                        VirtualFile file = dir.findChild(fileName);
                        if (file != null) {
                            files.add(file);
                            continue;
                        }
                        PsiDirectory directory = manager.findDirectory(dir);
                        if (directory == null) {
                            throw new IOException("cannot find " + resDir + File.separatorChar + dirName);
                        }
                        AndroidResourceUtil.createFileResource(fileName, directory, CreateTypedResourceFileAction.getDefaultRootTagByResourceType(folderType), resourceType.getName(), false);
                        file = dir.findChild(fileName);
                        if (file == null) {
                            throw new IOException("cannot find " + Joiner.on((char)File.separatorChar).join((Object)resDir, (Object)dirPath, new Object[]{fileName}));
                        }
                        files.add(file);
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                    result.setResult((Object)false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$3", "run"));
            }
        }.execute().getResultObject();
        return foundFiles ? files : null;
    }

    public static void updateStateList(@NotNull Project project, final @NotNull ResourceHelper.StateList stateList, @NotNull List<VirtualFile> files) {
        if (project == null) {
            AndroidResourceUtil.$$$reportNull$$$0(158);
        }
        if (stateList == null) {
            AndroidResourceUtil.$$$reportNull$$$0(159);
        }
        if (files == null) {
            AndroidResourceUtil.$$$reportNull$$$0(160);
        }
        if (!AndroidResourceUtil.ensureFilesWritable(project, files)) {
            return;
        }
        ArrayList psiFiles = Lists.newArrayListWithCapacity((int)files.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        final ArrayList selectors = Lists.newArrayListWithCapacity((int)files.size());
        Class selectorClass = stateList.getFolderType() == ResourceFolderType.COLOR ? ColorSelector.class : DrawableSelector.class;
        for (VirtualFile file : files) {
            AndroidDomElement selector = AndroidUtils.loadDomElement(project, file, selectorClass);
            if (selector == null) {
                AndroidUtils.reportError(project, file.getName() + " is not a statelist file");
                return;
            }
            selectors.add(selector);
        }
        new WriteCommandAction.Simple(project, "Change State List", psiFiles.toArray(new PsiFile[psiFiles.size()])){

            protected void run() {
                for (AndroidDomElement selector : selectors) {
                    XmlTag tag = selector.getXmlTag();
                    for (XmlTag subtag : tag.getSubTags()) {
                        subtag.delete();
                    }
                    for (ResourceHelper.StateListState state : stateList.getStates()) {
                        XmlTag child = tag.createChildTag("item", tag.getNamespace(), null, false);
                        child = tag.addSubTag(child, false);
                        Map<String, Boolean> attributes = state.getAttributes();
                        for (String attributeName : attributes.keySet()) {
                            child.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", attributes.get(attributeName).toString());
                        }
                        if (!StringUtil.isEmpty((String)state.getAlpha())) {
                            child.setAttribute("alpha", "http://schemas.android.com/apk/res/android", state.getAlpha());
                        }
                        if (selector instanceof ColorSelector) {
                            child.setAttribute("color", "http://schemas.android.com/apk/res/android", state.getValue());
                            continue;
                        }
                        if (!(selector instanceof DrawableSelector)) continue;
                        child.setAttribute("drawable", "http://schemas.android.com/apk/res/android", state.getValue());
                    }
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }.execute();
    }

    @NotNull
    public static String ensureNamespaceImported(@NotNull XmlFile file, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        if (file == null) {
            AndroidResourceUtil.$$$reportNull$$$0(161);
        }
        if (namespaceUri == null) {
            AndroidResourceUtil.$$$reportNull$$$0(162);
        }
        XmlTag rootTag = file.getRootTag();
        assert (rootTag != null);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file.getProject());
        if (StringUtil.isEmpty((String)namespaceUri)) {
            if ("" == null) {
                AndroidResourceUtil.$$$reportNull$$$0(163);
            }
            return "";
        }
        String prefix = rootTag.getPrefixByNamespace(namespaceUri);
        if (prefix != null) {
            String string = prefix;
            if (string == null) {
                AndroidResourceUtil.$$$reportNull$$$0(164);
            }
            return string;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        prefix = suggestedPrefix != null ? suggestedPrefix : ("http://schemas.android.com/tools".equals(namespaceUri) ? "tools" : ("http://schemas.android.com/apk/res/android".equals(namespaceUri) ? "android" : ("http://schemas.android.com/aapt".equals(namespaceUri) ? "aapt" : "app")));
        if (rootTag.getAttribute("xmlns:" + prefix) != null) {
            String base = prefix;
            int i = 2;
            while (true) {
                prefix = base + Integer.toString(i);
                if (rootTag.getAttribute("xmlns:" + prefix) == null) break;
                ++i;
            }
        }
        String name = "xmlns:" + prefix;
        XmlAttribute xmlnsAttr = elementFactory.createXmlAttribute(name, namespaceUri);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute next = attributes.length > 0 ? attributes[0] : null;
        for (XmlAttribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (attributeName.startsWith("xmlns:") && attributeName.compareTo(name) <= 0) continue;
            next = attribute;
            break;
        }
        if (next != null) {
            rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)next);
        } else {
            rootTag.add((PsiElement)xmlnsAttr);
        }
        String string = prefix;
        if (string == null) {
            AndroidResourceUtil.$$$reportNull$$$0(165);
        }
        return string;
    }

    static {
        REFERRABLE_RESOURCE_TYPES.addAll(Arrays.asList(ResourceType.values()));
        REFERRABLE_RESOURCE_TYPES.remove(ResourceType.ATTR);
        REFERRABLE_RESOURCE_TYPES.remove(ResourceType.STYLEABLE);
        ALL_VALUE_RESOURCE_TYPES.addAll(VALUE_RESOURCE_TYPES);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.ATTR);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.STYLEABLE);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.ANIM, ResourceFolderType.ANIM);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.ANIMATOR, ResourceFolderType.ANIMATOR);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.COLOR, ResourceFolderType.COLOR);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.DRAWABLE, ResourceFolderType.DRAWABLE);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.INTERPOLATOR, ResourceFolderType.INTERPOLATOR);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.LAYOUT, ResourceFolderType.LAYOUT);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.MENU, ResourceFolderType.MENU);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.MIPMAP, ResourceFolderType.MIPMAP);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.RAW, ResourceFolderType.RAW);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.TRANSITION, ResourceFolderType.TRANSITION);
        XML_FILE_RESOURCE_TYPES.put(ResourceType.XML, ResourceFolderType.XML);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 43: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 94: 
            case 148: 
            case 150: 
            case 151: 
            case 163: 
            case 164: 
            case 165: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 43: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 94: 
            case 148: 
            case 150: 
            case 151: 
            case 163: 
            case 164: 
            case 165: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 43: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 94: 
            case 148: 
            case 150: 
            case 151: 
            case 163: 
            case 164: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidResourceUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 7: 
            case 15: 
            case 85: 
            case 88: 
            case 90: 
            case 137: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resClassName";
                break;
            }
            case 5: 
            case 35: 
            case 38: 
            case 97: 
            case 104: 
            case 111: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceNames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 22: 
            case 80: 
            case 84: 
            case 89: 
            case 91: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 41: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 57: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 73: 
            case 77: 
            case 98: 
            case 105: 
            case 112: 
            case 119: 
            case 126: 
            case 147: 
            case 155: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirs";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 81: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 83: 
            case 95: 
            case 102: 
            case 109: 
            case 116: 
            case 123: 
            case 133: 
            case 141: 
            case 152: 
            case 158: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceTypes";
                break;
            }
            case 96: 
            case 103: 
            case 110: 
            case 117: 
            case 124: 
            case 130: 
            case 134: 
            case 153: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDir";
                break;
            }
            case 99: 
            case 106: 
            case 113: 
            case 120: 
            case 128: 
            case 131: 
            case 135: 
            case 144: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 100: 
            case 107: 
            case 114: 
            case 121: 
            case 129: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
            case 101: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterAddedProcessor";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 132: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 138: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 142: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resSubdir";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTagName";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleName";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateListName";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateList";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidResourceUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeXmlResourceValue";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findRJavaClasses";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFieldsForFileResource";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFieldsForValueResource";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findStyleableAttributeFields";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getRJavaFieldName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByField";
                break;
            }
            case 47: 
            case 48: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdFields";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidResourceFileName";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "addValueResource";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirs";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourcesFromElement";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesArray";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileResource";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldNameByResourceName";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureNamespaceImported";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeXmlResourceValue";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 43: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 94: 
            case 148: 
            case 150: 
            case 151: 
            case 163: 
            case 164: 
            case 165: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "packageToRClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFields";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFieldsFromClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findRJavaClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "manifestPackageForModule";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectDependentModules";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFieldsForFileResource";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getRJavaFieldName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectAndroidResourceName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypeByValueResourceTag";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getResourceForResourceTag";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getResourceClassName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByField";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isResourceField";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isStringResource";
                break;
            }
            case 46: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findIdFields";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isIdDeclaration";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getValidResourceFileName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getResourceNameByReferenceText";
                break;
            }
            case 56: 
            case 57: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "addValueResource";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getResourceSubdirs";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResourceFileName";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourcesFromElement";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isInResourceSubdirectory";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isResourceSubdirectory";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isLocalResourceDirectory";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isResourceFile";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDirectory";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "containsAndroidJar";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isRJavaFile";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isManifestJavaFile";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getNames";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getNamesArray";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createValueResource";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "changeValueResource";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFile";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateResourceFile";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getReferredResourceOrManifestField";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "createFileResource";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getFieldNameByResourceName";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateStateListFiles";
                break;
            }
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "updateStateList";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "ensureNamespaceImported";
                break;
            }
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addValueResource$2";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createValueResource$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 43: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 94: 
            case 148: 
            case 150: 
            case 151: 
            case 163: 
            case 164: 
            case 165: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyReferredResourceFieldInfo {
        private final String myClassName;
        private final String myFieldName;
        private final Module myResolvedModule;
        private final boolean mySystem;
        private final boolean myFromManifest;

        public MyReferredResourceFieldInfo(@NotNull String className, @NotNull String fieldName, @Nullable Module resolvedModule, boolean system, boolean fromManifest) {
            if (className == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(1);
            }
            this.myClassName = className;
            this.myFieldName = fieldName;
            this.myResolvedModule = resolvedModule;
            this.mySystem = system;
            this.myFromManifest = fromManifest;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFieldName() {
            String string = this.myFieldName;
            if (string == null) {
                MyReferredResourceFieldInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public Module getResolvedModule() {
            return this.myResolvedModule;
        }

        public boolean isSystem() {
            return this.mySystem;
        }

        public boolean isFromManifest() {
            return this.myFromManifest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

