/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.uiDesigner.Properties;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.LwXmlReader;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntEnumEditor;
import com.intellij.uiDesigner.propertyInspector.properties.IntroBooleanProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroCharProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroColorProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroComponentProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroDimensionProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroEnumProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroFontProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroIconProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroInsetsProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroIntProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroListModelProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroPrimitiveTypeProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroRectangleProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.IntEnumRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Palette2", defaultStateAsResource=true, storages={@Storage(value="uiDesigner.xml")})
public final class Palette
implements Disposable,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.palette.Palette");
    private final MyLafManagerListener myLafManagerListener;
    private final Map<Class, IntrospectedProperty[]> myClass2Properties;
    private final Map<String, ComponentItem> myClassName2Item;
    private final List<GroupItem> myGroups;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Project myProject;
    private final GroupItem mySpecialGroup = new GroupItem(true);
    private ComponentItem myPanelItem;
    @NonNls
    private static final String ATTRIBUTE_VSIZE_POLICY = "vsize-policy";
    @NonNls
    private static final String ATTRIBUTE_HSIZE_POLICY = "hsize-policy";
    @NonNls
    private static final String ATTRIBUTE_ANCHOR = "anchor";
    @NonNls
    private static final String ATTRIBUTE_FILL = "fill";
    @NonNls
    private static final String ELEMENT_MINIMUM_SIZE = "minimum-size";
    @NonNls
    private static final String ATTRIBUTE_WIDTH = "width";
    @NonNls
    private static final String ATTRIBUTE_HEIGHT = "height";
    @NonNls
    private static final String ELEMENT_PREFERRED_SIZE = "preferred-size";
    @NonNls
    private static final String ELEMENT_MAXIMUM_SIZE = "maximum-size";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String ATTRIBUTE_TOOLTIP_TEXT = "tooltip-text";
    @NonNls
    private static final String ELEMENT_DEFAULT_CONSTRAINTS = "default-constraints";
    @NonNls
    private static final String ELEMENT_INITIAL_VALUES = "initial-values";
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String ATTRIBUTE_REMOVABLE = "removable";
    @NonNls
    private static final String ELEMENT_ITEM = "item";
    @NonNls
    private static final String ELEMENT_GROUP = "group";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_SINCE_VERSION = "since-version";
    @NonNls
    private static final String ATTRIBUTE_AUTO_CREATE_BINDING = "auto-create-binding";
    @NonNls
    private static final String ATTRIBUTE_CAN_ATTACH_LABEL = "can-attach-label";
    @NonNls
    private static final String ATTRIBUTE_IS_CONTAINER = "is-container";

    public static Palette getInstance(@NotNull Project project) {
        if (project == null) {
            Palette.$$$reportNull$$$0(0);
        }
        return (Palette)ServiceManager.getService((Project)project, Palette.class);
    }

    public Palette(Project project) {
        this.myProject = project;
        this.myLafManagerListener = project == null ? null : new MyLafManagerListener();
        this.myClass2Properties = new HashMap<Class, IntrospectedProperty[]>();
        this.myClassName2Item = new HashMap<String, ComponentItem>();
        this.myGroups = new ArrayList<GroupItem>();
        if (project != null) {
            this.mySpecialGroup.setReadOnly(true);
            this.mySpecialGroup.addItem(ComponentItem.createAnyComponentItem(project));
        }
        if (this.myLafManagerListener != null) {
            LafManager.getInstance().addLafManagerListener((LafManagerListener)this.myLafManagerListener);
        }
    }

    public Element getState() {
        Element state = new Element("state");
        this.writeGroups(state);
        return state;
    }

    public void loadState(Element state) {
        this.myClass2Properties.clear();
        this.myClassName2Item.clear();
        this.myGroups.clear();
        this.processGroups(state.getChildren(ELEMENT_GROUP));
        LOG.assertTrue(this.myPanelItem != null);
        if (!state.getAttributeValue(ATTRIBUTE_VERSION, "1").equals("2")) {
            this.upgradePalette();
        }
    }

    public void addListener(@NotNull Listener l) {
        if (l == null) {
            Palette.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(!this.myListeners.contains(l));
        this.myListeners.add(l);
    }

    public void removeListener(@NotNull Listener l) {
        if (l == null) {
            Palette.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(this.myListeners.contains(l));
        this.myListeners.remove(l);
    }

    void fireGroupsChanged() {
        for (Listener listener : this.myListeners) {
            listener.groupsChanged(this);
        }
    }

    public void dispose() {
        if (this.myLafManagerListener != null) {
            LafManager.getInstance().removeLafManagerListener((LafManagerListener)this.myLafManagerListener);
        }
    }

    private void upgradePalette() {
        try {
            Document document = new SAXBuilder().build(this.getClass().getResourceAsStream("/idea/Palette2.xml"));
            block2: for (Element groupElement : document.getRootElement().getChildren(ELEMENT_GROUP)) {
                for (GroupItem group : this.myGroups) {
                    if (!group.getName().equals(groupElement.getAttributeValue(ATTRIBUTE_NAME))) continue;
                    this.upgradeGroup(group, groupElement);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void upgradeGroup(GroupItem group, Element groupElement) {
        for (Element itemElement : groupElement.getChildren(ELEMENT_ITEM)) {
            String className;
            ComponentItem item;
            if (itemElement.getAttributeValue(ATTRIBUTE_SINCE_VERSION, "").equals("2")) {
                this.processItemElement(itemElement, group, true);
            }
            if ((item = this.getItem(className = LwXmlReader.getRequiredString((Element)itemElement, (String)ATTRIBUTE_CLASS))) == null) continue;
            if (LwXmlReader.getOptionalBoolean((Element)itemElement, (String)ATTRIBUTE_AUTO_CREATE_BINDING, (boolean)false)) {
                item.setAutoCreateBinding(true);
            }
            if (!LwXmlReader.getOptionalBoolean((Element)itemElement, (String)ATTRIBUTE_CAN_ATTACH_LABEL, (boolean)false)) continue;
            item.setCanAttachLabel(true);
        }
    }

    @NotNull
    public ComponentItem getPanelItem() {
        ComponentItem componentItem = this.myPanelItem;
        if (componentItem == null) {
            Palette.$$$reportNull$$$0(3);
        }
        return componentItem;
    }

    @Nullable
    public ComponentItem getItem(@NotNull String componentClassName) {
        if (componentClassName == null) {
            Palette.$$$reportNull$$$0(4);
        }
        return this.myClassName2Item.get(componentClassName);
    }

    public List<GroupItem> getGroups() {
        return this.myGroups;
    }

    public GroupItem[] getToolWindowGroups() {
        GroupItem[] groups = new GroupItem[this.myGroups.size() + 1];
        for (int i = 0; i < this.myGroups.size(); ++i) {
            groups[i] = this.myGroups.get(i);
        }
        groups[this.myGroups.size()] = this.mySpecialGroup;
        return groups;
    }

    public void setGroups(@NotNull ArrayList<GroupItem> groups) {
        if (groups == null) {
            Palette.$$$reportNull$$$0(5);
        }
        this.myGroups.clear();
        this.myGroups.addAll(groups);
        this.fireGroupsChanged();
    }

    public void addItem(@NotNull GroupItem group, @NotNull ComponentItem item) {
        String componentClassName;
        if (group == null) {
            Palette.$$$reportNull$$$0(6);
        }
        if (item == null) {
            Palette.$$$reportNull$$$0(7);
        }
        if (this.getItem(componentClassName = item.getClassName()) != null) {
            Messages.showMessageDialog((String)UIDesignerBundle.message("error.item.already.added", componentClassName), (String)ApplicationNamesInfo.getInstance().getFullProductName(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.myClassName2Item.put(componentClassName, item);
        group.addItem(item);
        if ("javax.swing.JPanel".equals(item.getClassName())) {
            this.myPanelItem = item;
        }
    }

    public void replaceItem(GroupItem group, ComponentItem oldItem, ComponentItem newItem) {
        group.replaceItem(oldItem, newItem);
        this.myClassName2Item.put(oldItem.getClassName(), newItem);
    }

    public void removeItem(GroupItem group, ComponentItem selectedItem) {
        group.removeItem(selectedItem);
        this.myClassName2Item.remove(selectedItem.getClassName());
    }

    public GroupItem findGroup(ComponentItem componentItem) {
        for (GroupItem group : this.myGroups) {
            if (!group.contains(componentItem)) continue;
            return group;
        }
        return null;
    }

    private static GridConstraints processDefaultConstraintsElement(@NotNull Element element) {
        Element maxSizeElement;
        Element prefSizeElement;
        if (element == null) {
            Palette.$$$reportNull$$$0(8);
        }
        GridConstraints constraints = new GridConstraints();
        constraints.setVSizePolicy(LwXmlReader.getRequiredInt((Element)element, (String)ATTRIBUTE_VSIZE_POLICY));
        constraints.setHSizePolicy(LwXmlReader.getRequiredInt((Element)element, (String)ATTRIBUTE_HSIZE_POLICY));
        constraints.setAnchor(LwXmlReader.getRequiredInt((Element)element, (String)ATTRIBUTE_ANCHOR));
        constraints.setFill(LwXmlReader.getRequiredInt((Element)element, (String)ATTRIBUTE_FILL));
        Element minSizeElement = element.getChild(ELEMENT_MINIMUM_SIZE);
        if (minSizeElement != null) {
            constraints.myMinimumSize.width = LwXmlReader.getRequiredInt((Element)minSizeElement, (String)ATTRIBUTE_WIDTH);
            constraints.myMinimumSize.height = LwXmlReader.getRequiredInt((Element)minSizeElement, (String)ATTRIBUTE_HEIGHT);
        }
        if ((prefSizeElement = element.getChild(ELEMENT_PREFERRED_SIZE)) != null) {
            constraints.myPreferredSize.width = LwXmlReader.getRequiredInt((Element)prefSizeElement, (String)ATTRIBUTE_WIDTH);
            constraints.myPreferredSize.height = LwXmlReader.getRequiredInt((Element)prefSizeElement, (String)ATTRIBUTE_HEIGHT);
        }
        if ((maxSizeElement = element.getChild(ELEMENT_MAXIMUM_SIZE)) != null) {
            constraints.myMaximumSize.width = LwXmlReader.getRequiredInt((Element)maxSizeElement, (String)ATTRIBUTE_WIDTH);
            constraints.myMaximumSize.height = LwXmlReader.getRequiredInt((Element)maxSizeElement, (String)ATTRIBUTE_HEIGHT);
        }
        return constraints;
    }

    private void processItemElement(@NotNull Element itemElement, @NotNull GroupItem group, boolean skipExisting) {
        if (itemElement == null) {
            Palette.$$$reportNull$$$0(9);
        }
        if (group == null) {
            Palette.$$$reportNull$$$0(10);
        }
        String className = LwXmlReader.getRequiredString((Element)itemElement, (String)ATTRIBUTE_CLASS);
        if (skipExisting && this.getItem(className) != null) {
            return;
        }
        String iconPath = LwXmlReader.getString((Element)itemElement, (String)ATTRIBUTE_ICON);
        String toolTipText = LwXmlReader.getString((Element)itemElement, (String)ATTRIBUTE_TOOLTIP_TEXT);
        boolean autoCreateBinding = LwXmlReader.getOptionalBoolean((Element)itemElement, (String)ATTRIBUTE_AUTO_CREATE_BINDING, (boolean)false);
        boolean canAttachLabel = LwXmlReader.getOptionalBoolean((Element)itemElement, (String)ATTRIBUTE_CAN_ATTACH_LABEL, (boolean)false);
        boolean isContainer = LwXmlReader.getOptionalBoolean((Element)itemElement, (String)ATTRIBUTE_IS_CONTAINER, (boolean)false);
        Element defaultConstraints = itemElement.getChild(ELEMENT_DEFAULT_CONSTRAINTS);
        GridConstraints constraints = defaultConstraints != null ? Palette.processDefaultConstraintsElement(defaultConstraints) : new GridConstraints();
        HashMap<String, StringDescriptor> propertyName2initialValue = new HashMap<String, StringDescriptor>();
        Element initialValues = itemElement.getChild(ELEMENT_INITIAL_VALUES);
        if (initialValues != null) {
            for (Object o : initialValues.getChildren(ELEMENT_PROPERTY)) {
                Element e = (Element)o;
                String name = LwXmlReader.getRequiredString((Element)e, (String)ATTRIBUTE_NAME);
                StringDescriptor value = StringDescriptor.create((String)LwXmlReader.getRequiredString((Element)e, (String)ATTRIBUTE_VALUE));
                propertyName2initialValue.put(name, value);
            }
        }
        boolean removable = LwXmlReader.getOptionalBoolean((Element)itemElement, (String)ATTRIBUTE_REMOVABLE, (boolean)true);
        ComponentItem item = new ComponentItem(this.myProject, className, iconPath, toolTipText, constraints, propertyName2initialValue, removable, autoCreateBinding, canAttachLabel);
        item.setIsContainer(isContainer);
        this.addItem(group, item);
    }

    private void processGroups(@NotNull List<Element> groupElements) {
        if (groupElements == null) {
            Palette.$$$reportNull$$$0(11);
        }
        for (Element groupElement : groupElements) {
            GroupItem group = new GroupItem(LwXmlReader.getRequiredString((Element)groupElement, (String)ATTRIBUTE_NAME));
            this.myGroups.add(group);
            for (Element itemElement : groupElement.getChildren(ELEMENT_ITEM)) {
                try {
                    this.processItemElement(itemElement, group, false);
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
    }

    private static void writeDefaultConstraintsElement(@NotNull Element itemElement, @NotNull GridConstraints c) {
        Element _element;
        if (itemElement == null) {
            Palette.$$$reportNull$$$0(12);
        }
        if (c == null) {
            Palette.$$$reportNull$$$0(13);
        }
        LOG.assertTrue(ELEMENT_ITEM.equals(itemElement.getName()));
        Element element = new Element(ELEMENT_DEFAULT_CONSTRAINTS);
        itemElement.addContent(element);
        element.setAttribute(ATTRIBUTE_VSIZE_POLICY, Integer.toString(c.getVSizePolicy()));
        element.setAttribute(ATTRIBUTE_HSIZE_POLICY, Integer.toString(c.getHSizePolicy()));
        element.setAttribute(ATTRIBUTE_ANCHOR, Integer.toString(c.getAnchor()));
        element.setAttribute(ATTRIBUTE_FILL, Integer.toString(c.getFill()));
        if (c.myMinimumSize.width != -1 || c.myMinimumSize.height != -1) {
            _element = new Element(ELEMENT_MINIMUM_SIZE);
            element.addContent(_element);
            _element.setAttribute(ATTRIBUTE_WIDTH, Integer.toString(c.myMinimumSize.width));
            _element.setAttribute(ATTRIBUTE_HEIGHT, Integer.toString(c.myMinimumSize.height));
        }
        if (c.myPreferredSize.width != -1 || c.myPreferredSize.height != -1) {
            _element = new Element(ELEMENT_PREFERRED_SIZE);
            element.addContent(_element);
            _element.setAttribute(ATTRIBUTE_WIDTH, Integer.toString(c.myPreferredSize.width));
            _element.setAttribute(ATTRIBUTE_HEIGHT, Integer.toString(c.myPreferredSize.height));
        }
        if (c.myMaximumSize.width != -1 || c.myMaximumSize.height != -1) {
            _element = new Element(ELEMENT_MAXIMUM_SIZE);
            element.addContent(_element);
            _element.setAttribute(ATTRIBUTE_WIDTH, Integer.toString(c.myMaximumSize.width));
            _element.setAttribute(ATTRIBUTE_HEIGHT, Integer.toString(c.myMaximumSize.height));
        }
    }

    private static void writeInitialValuesElement(@NotNull Element itemElement, @NotNull HashMap<String, StringDescriptor> name2value) {
        if (itemElement == null) {
            Palette.$$$reportNull$$$0(14);
        }
        if (name2value == null) {
            Palette.$$$reportNull$$$0(15);
        }
        LOG.assertTrue(ELEMENT_ITEM.equals(itemElement.getName()));
        if (name2value.size() == 0) {
            return;
        }
        Element initialValuesElement = new Element(ELEMENT_INITIAL_VALUES);
        itemElement.addContent(initialValuesElement);
        for (Map.Entry<String, StringDescriptor> entry : name2value.entrySet()) {
            Element propertyElement = new Element(ELEMENT_PROPERTY);
            initialValuesElement.addContent(propertyElement);
            propertyElement.setAttribute(ATTRIBUTE_NAME, entry.getKey());
            propertyElement.setAttribute(ATTRIBUTE_VALUE, entry.getValue().getValue());
        }
    }

    private static void writeComponentItem(@NotNull Element groupElement, @NotNull ComponentItem item) {
        String iconPath;
        if (groupElement == null) {
            Palette.$$$reportNull$$$0(16);
        }
        if (item == null) {
            Palette.$$$reportNull$$$0(17);
        }
        LOG.assertTrue(ELEMENT_GROUP.equals(groupElement.getName()));
        Element itemElement = new Element(ELEMENT_ITEM);
        groupElement.addContent(itemElement);
        itemElement.setAttribute(ATTRIBUTE_CLASS, item.getClassName());
        if (item.myToolTipText != null) {
            itemElement.setAttribute(ATTRIBUTE_TOOLTIP_TEXT, item.myToolTipText);
        }
        if ((iconPath = item.getIconPath()) != null) {
            itemElement.setAttribute(ATTRIBUTE_ICON, iconPath);
        }
        itemElement.setAttribute(ATTRIBUTE_REMOVABLE, Boolean.toString(item.isRemovable()));
        itemElement.setAttribute(ATTRIBUTE_AUTO_CREATE_BINDING, Boolean.toString(item.isAutoCreateBinding()));
        itemElement.setAttribute(ATTRIBUTE_CAN_ATTACH_LABEL, Boolean.toString(item.isCanAttachLabel()));
        if (item.isContainer()) {
            itemElement.setAttribute(ATTRIBUTE_IS_CONTAINER, Boolean.toString(item.isContainer()));
        }
        Palette.writeDefaultConstraintsElement(itemElement, item.getDefaultConstraints());
        Palette.writeInitialValuesElement(itemElement, item.getInitialValues());
    }

    private void writeGroups(@NotNull Element parentElement) {
        if (parentElement == null) {
            Palette.$$$reportNull$$$0(18);
        }
        for (GroupItem group : this.myGroups) {
            Element groupElement = new Element(ELEMENT_GROUP);
            parentElement.addContent(groupElement);
            groupElement.setAttribute(ATTRIBUTE_NAME, group.getName());
            for (ComponentItem aItemList : group.getItems()) {
                Palette.writeComponentItem(groupElement, aItemList);
            }
        }
    }

    private static IntroIntProperty createIntEnumProperty(String name, Method readMethod, Method writeMethod, IntEnumEditor.Pair[] pairs) {
        return new IntroIntProperty(name, readMethod, writeMethod, new IntEnumRenderer(pairs), new IntEnumEditor(pairs), false);
    }

    @NotNull
    public IntrospectedProperty[] getIntrospectedProperties(@NotNull RadComponent component) {
        if (component == null) {
            Palette.$$$reportNull$$$0(19);
        }
        IntrospectedProperty[] introspectedPropertyArray = this.getIntrospectedProperties(component.getComponentClass(), component.getDelegee().getClass());
        if (introspectedPropertyArray == null) {
            Palette.$$$reportNull$$$0(20);
        }
        return introspectedPropertyArray;
    }

    @NotNull
    public IntrospectedProperty[] getIntrospectedProperties(@NotNull Class aClass, @NotNull Class delegeeClass) {
        if (aClass == null) {
            Palette.$$$reportNull$$$0(21);
        }
        if (delegeeClass == null) {
            Palette.$$$reportNull$$$0(22);
        }
        if (this.myClass2Properties.containsKey(aClass)) {
            IntrospectedProperty[] introspectedPropertyArray = this.myClass2Properties.get(aClass);
            if (introspectedPropertyArray == null) {
                Palette.$$$reportNull$$$0(23);
            }
            return introspectedPropertyArray;
        }
        ArrayList<IntroBooleanProperty> result = new ArrayList<IntroBooleanProperty>();
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(aClass);
            for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
                IntrospectedProperty property;
                Properties properties;
                Method readMethod = descriptor.getReadMethod();
                Method writeMethod = descriptor.getWriteMethod();
                Class<?> propertyType = descriptor.getPropertyType();
                if (writeMethod == null || readMethod == null || propertyType == null) continue;
                boolean storeAsClient = false;
                try {
                    delegeeClass.getMethod(readMethod.getName(), readMethod.getParameterTypes());
                    delegeeClass.getMethod(writeMethod.getName(), writeMethod.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    storeAsClient = true;
                }
                String name = descriptor.getName();
                Properties properties2 = properties = this.myProject == null ? new Properties() : Properties.getInstance();
                if (Integer.TYPE.equals(propertyType)) {
                    IntEnumEditor.Pair[] enumPairs = properties.getEnumPairs(aClass, name);
                    if (enumPairs != null) {
                        property = Palette.createIntEnumProperty(name, readMethod, writeMethod, enumPairs);
                    } else if (JLabel.class.isAssignableFrom(aClass)) {
                        if (JLabel.class.isAssignableFrom(aClass) && ("displayedMnemonic".equals(name) || "displayedMnemonicIndex".equals(name))) continue;
                        property = new IntroIntProperty(name, readMethod, writeMethod, storeAsClient);
                    } else if (AbstractButton.class.isAssignableFrom(aClass)) {
                        if ("mnemonic".equals(name) || "displayedMnemonicIndex".equals(name)) continue;
                        property = new IntroIntProperty(name, readMethod, writeMethod, storeAsClient);
                    } else if (JTabbedPane.class.isAssignableFrom(aClass)) {
                        if ("selectedIndex".equals(name)) continue;
                        property = new IntroIntProperty(name, readMethod, writeMethod, storeAsClient);
                    } else {
                        property = new IntroIntProperty(name, readMethod, writeMethod, storeAsClient);
                    }
                } else if (Boolean.TYPE.equals(propertyType)) {
                    property = new IntroBooleanProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (Double.TYPE.equals(propertyType)) {
                    property = new IntroPrimitiveTypeProperty<Double>(name, readMethod, writeMethod, storeAsClient, Double.class);
                } else if (Float.TYPE.equals(propertyType)) {
                    property = new IntroPrimitiveTypeProperty<Float>(name, readMethod, writeMethod, storeAsClient, Float.class);
                } else if (Long.TYPE.equals(propertyType)) {
                    property = new IntroPrimitiveTypeProperty<Long>(name, readMethod, writeMethod, storeAsClient, Long.class);
                } else if (Byte.TYPE.equals(propertyType)) {
                    property = new IntroPrimitiveTypeProperty<Byte>(name, readMethod, writeMethod, storeAsClient, Byte.class);
                } else if (Short.TYPE.equals(propertyType)) {
                    property = new IntroPrimitiveTypeProperty<Short>(name, readMethod, writeMethod, storeAsClient, Short.class);
                } else if (Character.TYPE.equals(propertyType)) {
                    property = new IntroCharProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (String.class.equals(propertyType)) {
                    property = new IntroStringProperty(name, readMethod, writeMethod, this.myProject, storeAsClient);
                } else if (Insets.class.equals(propertyType)) {
                    property = new IntroInsetsProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (Dimension.class.equals(propertyType)) {
                    property = new IntroDimensionProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (Rectangle.class.equals(propertyType)) {
                    property = new IntroRectangleProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (Component.class.isAssignableFrom(propertyType)) {
                    if (JSplitPane.class.isAssignableFrom(aClass) && (name.equals("leftComponent") || name.equals("rightComponent") || name.equals("topComponent") || name.equals("bottomComponent")) || JTabbedPane.class.isAssignableFrom(aClass) && name.equals("selectedComponent") || JMenuBar.class.isAssignableFrom(propertyType) || JPopupMenu.class.isAssignableFrom(propertyType)) continue;
                    Condition filter = null;
                    if (name.equals("labelFor")) {
                        filter = t -> {
                            ComponentItem item = this.getItem(t.getComponentClassName());
                            return item != null && item.isCanAttachLabel();
                        };
                    }
                    property = new IntroComponentProperty(name, readMethod, writeMethod, propertyType, (Condition<RadComponent>)filter, storeAsClient);
                } else if (Color.class.equals(propertyType)) {
                    property = new IntroColorProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (Font.class.equals(propertyType)) {
                    property = new IntroFontProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (Icon.class.equals(propertyType)) {
                    property = new IntroIconProperty(name, readMethod, writeMethod, storeAsClient);
                } else if (ListModel.class.isAssignableFrom(propertyType)) {
                    property = new IntroListModelProperty(name, readMethod, writeMethod, storeAsClient);
                } else {
                    if (!Enum.class.isAssignableFrom(propertyType)) continue;
                    property = new IntroEnumProperty(name, readMethod, writeMethod, storeAsClient, propertyType);
                }
                result.add((IntroBooleanProperty)property);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        IntrospectedProperty[] properties = result.toArray(new IntrospectedProperty[result.size()]);
        this.myClass2Properties.put(aClass, properties);
        if (properties == null) {
            Palette.$$$reportNull$$$0(24);
        }
        return properties;
    }

    @Nullable
    public IntrospectedProperty getIntrospectedProperty(@NotNull RadComponent component, @NotNull String name) {
        IntrospectedProperty[] properties;
        if (component == null) {
            Palette.$$$reportNull$$$0(25);
        }
        if (name == null) {
            Palette.$$$reportNull$$$0(26);
        }
        for (IntrospectedProperty property : properties = this.getIntrospectedProperties(component)) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Nullable
    public IntrospectedProperty getInplaceProperty(@NotNull RadComponent component) {
        if (component == null) {
            Palette.$$$reportNull$$$0(27);
        }
        String inplaceProperty = Properties.getInstance().getInplaceProperty(component.getComponentClass());
        IntrospectedProperty[] properties = this.getIntrospectedProperties(component);
        for (int i = properties.length - 1; i >= 0; --i) {
            IntrospectedProperty property = properties[i];
            if (!property.getName().equals(inplaceProperty)) continue;
            return property;
        }
        return null;
    }

    public static boolean isRemovable(@NotNull GroupItem group) {
        if (group == null) {
            Palette.$$$reportNull$$$0(28);
        }
        ComponentItem[] items = group.getItems();
        for (int i = items.length - 1; i >= 0; --i) {
            if (items[i].isRemovable()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 20: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 20: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 3: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/palette/Palette";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 6: 
            case 10: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_GROUP;
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_ITEM;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupElements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 19: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegeeClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/palette/Palette";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelItem";
                break;
            }
            case 20: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectedProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 3: 
            case 20: 
            case 23: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setGroups";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultConstraintsElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processItemElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processGroups";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeDefaultConstraintsElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeInitialValuesElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeComponentItem";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeGroups";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIntrospectedProperties";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIntrospectedProperty";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceProperty";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isRemovable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 20: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface Listener {
        public void groupsChanged(Palette var1);
    }

    private final class MyLafManagerListener
    implements LafManagerListener {
        private MyLafManagerListener() {
        }

        private void updateUI(Property property) {
            PropertyRenderer renderer = property.getRenderer();
            renderer.updateUI();
            PropertyEditor editor = property.getEditor();
            if (editor != null) {
                editor.updateUI();
            }
            Property[] children = property.getChildren(null);
            for (int i = children.length - 1; i >= 0; --i) {
                this.updateUI(children[i]);
            }
        }

        public void lookAndFeelChanged(LafManager source) {
            for (IntrospectedProperty[] properties : Palette.this.myClass2Properties.values()) {
                LOG.assertTrue(properties != null);
                for (int j = properties.length - 1; j >= 0; --j) {
                    this.updateUI(properties[j]);
                }
            }
        }
    }
}

