/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFxmlFileAction
extends CreateFromTemplateActionBase {
    private static final String INTERNAL_TEMPLATE_NAME = "FxmlFile.fxml";

    public CreateFxmlFileAction() {
        super("FXML File", "Create New FXML File", AllIcons.FileTypes.Xml);
    }

    protected FileTemplate getTemplate(Project project, PsiDirectory dir) {
        return FileTemplateManager.getInstance((Project)project).getInternalTemplate(INTERNAL_TEMPLATE_NAME);
    }

    @Nullable
    protected Map<String, String> getLiveTemplateDefaults(DataContext dataContext, @NotNull PsiFile file) {
        if (file == null) {
            CreateFxmlFileAction.$$$reportNull$$$0(0);
        }
        String packageName = (String)ReadAction.compute(() -> {
            PsiDirectory psiDirectory;
            if (file == null) {
                CreateFxmlFileAction.$$$reportNull$$$0(1);
            }
            if ((psiDirectory = file.getContainingDirectory()) != null) {
                VirtualFile vDirectory = psiDirectory.getVirtualFile();
                ProjectFileIndex index = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
                if (index.isInSourceContent(vDirectory)) {
                    return index.getPackageNameByDirectory(vDirectory);
                }
            }
            return null;
        });
        String name = file.getName();
        if ("fxml".equals(PathUtil.getFileExtension((String)(name = PathUtil.getFileName((String)name))))) {
            name = name.substring(0, name.length() - "fxml".length() - 1);
        }
        name = CreateFxmlFileAction.toClassName(name);
        name = !StringUtil.isEmpty((String)packageName) ? packageName + "." + name : name;
        return Collections.singletonMap("CONTROLLER_NAME", name);
    }

    private static String toClassName(String name) {
        char c;
        for (int start = 0; !(start >= name.length() || Character.isJavaIdentifierStart(c = name.charAt(start)) && c != '_' && c != '$'); ++start) {
        }
        StringBuilder className = new StringBuilder();
        boolean skip = true;
        for (int i = start; i < name.length(); ++i) {
            char c2 = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c2) || c2 == '_' || c2 == '$') {
                skip = true;
                continue;
            }
            if (skip) {
                skip = false;
                className.append(Character.toUpperCase(c2));
                continue;
            }
            className.append(c2);
        }
        return className.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "org/jetbrains/plugins/javaFX/actions/CreateFxmlFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLiveTemplateDefaults";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getLiveTemplateDefaults$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

