/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.LoggerProvider;
import org.gradle.internal.progress.ProgressBar;
import org.gradle.internal.progress.ProgressFormatter;
import org.gradle.internal.progress.ProgressLoggerProvider;

public class BuildProgressLogger
implements LoggerProvider {
    public static final String INITIALIZATION_PHASE_DESCRIPTION = "Initializing build";
    public static final String INITIALIZATION_PHASE_SHORT_DESCRIPTION = "INITIALIZING";
    public static final String CONFIGURATION_PHASE_DESCRIPTION = "Configuring projects";
    public static final String CONFIGURATION_PHASE_SHORT_DESCRIPTION = "CONFIGURING";
    public static final String EXECUTION_PHASE_DESCRIPTION = "Executing tasks";
    public static final String EXECUTION_PHASE_SHORT_DESCRIPTION = "EXECUTING";
    public static final String WAITING_PHASE_DESCRIPTION = "WAITING";
    public static final int PROGRESS_BAR_WIDTH = 13;
    public static final String PROGRESS_BAR_PREFIX = "<";
    public static final char PROGRESS_BAR_COMPLETE_CHAR = '=';
    public static final char PROGRESS_BAR_INCOMPLETE_CHAR = '-';
    public static final String PROGRESS_BAR_SUFFIX = ">";
    private final ProgressLoggerProvider loggerProvider;
    private boolean taskGraphPopulated;
    private ProgressLogger buildProgress;
    private ProgressFormatter buildProgressFormatter;

    public BuildProgressLogger(ProgressLoggerFactory progressLoggerFactory) {
        this(new ProgressLoggerProvider(progressLoggerFactory, BuildProgressLogger.class));
    }

    BuildProgressLogger(ProgressLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
    }

    public void buildStarted() {
        this.buildProgressFormatter = this.newProgressBar(INITIALIZATION_PHASE_SHORT_DESCRIPTION, 1);
        this.buildProgress = this.loggerProvider.start(INITIALIZATION_PHASE_DESCRIPTION, this.buildProgressFormatter.getProgress());
    }

    public void settingsEvaluated() {
        this.buildProgress.completed();
    }

    public void projectsLoaded(int totalProjects) {
        this.buildProgressFormatter = this.newProgressBar(CONFIGURATION_PHASE_SHORT_DESCRIPTION, totalProjects);
        this.buildProgress = this.loggerProvider.start(CONFIGURATION_PHASE_DESCRIPTION, this.buildProgressFormatter.getProgress());
    }

    public void beforeEvaluate(String projectPath) {
    }

    public void afterEvaluate(String projectPath) {
        if (!this.taskGraphPopulated) {
            this.buildProgress.progress(this.buildProgressFormatter.incrementAndGetProgress());
        }
    }

    public void graphPopulated(int totalTasks) {
        this.taskGraphPopulated = true;
        this.buildProgress.completed();
        this.buildProgressFormatter = this.newProgressBar(EXECUTION_PHASE_SHORT_DESCRIPTION, totalTasks);
        this.buildProgress = this.loggerProvider.start(EXECUTION_PHASE_DESCRIPTION, this.buildProgressFormatter.getProgress());
    }

    public void beforeExecute() {
    }

    public void afterExecute() {
        this.buildProgress.progress(this.buildProgressFormatter.incrementAndGetProgress());
    }

    public void beforeComplete() {
        this.buildProgress.completed(this.newProgressBar(WAITING_PHASE_DESCRIPTION, 1).getProgress());
        this.buildProgress = null;
        this.buildProgressFormatter = null;
    }

    public ProgressLogger getLogger() {
        if (this.buildProgress == null) {
            throw new IllegalStateException("Build logger is unavailable (it hasn't started or is already completed).");
        }
        return this.buildProgress;
    }

    @VisibleForTesting
    public ProgressBar newProgressBar(String initialSuffix, int totalWorkItems) {
        return new ProgressBar(PROGRESS_BAR_PREFIX, 13, PROGRESS_BAR_SUFFIX, '=', '-', initialSuffix, totalWorkItems);
    }
}

