/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRequestCollector {
    private final ScriptSource scriptSource;
    private final List<DependencySpecImpl> specs = new LinkedList<DependencySpecImpl>();

    public PluginRequestCollector(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public PluginDependenciesSpec createSpec(final int lineNumber) {
        return new PluginDependenciesSpec(){

            public PluginDependencySpec id(String id) {
                DependencySpecImpl spec = new DependencySpecImpl(id, lineNumber);
                PluginRequestCollector.this.specs.add(spec);
                return spec;
            }
        };
    }

    public PluginRequests getPluginRequests() {
        return new DefaultPluginRequests(this.listPluginRequests());
    }

    public List<PluginRequestInternal> listPluginRequests() {
        List pluginRequests = CollectionUtils.collect(this.specs, (Transformer)new Transformer<PluginRequestInternal, DependencySpecImpl>(){

            public PluginRequestInternal transform(DependencySpecImpl original) {
                return new DefaultPluginRequest(original.id, original.version, original.apply, original.lineNumber, PluginRequestCollector.this.scriptSource);
            }
        });
        Map groupedById = CollectionUtils.groupBy((Iterable)pluginRequests, (Transformer)new Transformer<PluginId, PluginRequestInternal>(){

            public PluginId transform(PluginRequestInternal pluginRequest) {
                return pluginRequest.getId();
            }
        });
        for (PluginId key : groupedById.keySet()) {
            Collection pluginRequestsForId = (Collection)groupedById.get(key);
            if (pluginRequestsForId.size() <= 1) continue;
            PluginRequestInternal first = (PluginRequestInternal)pluginRequests.get(0);
            PluginRequestInternal second = (PluginRequestInternal)pluginRequests.get(1);
            InvalidPluginRequestException exception = new InvalidPluginRequestException(second, "Plugin with id '" + key + "' was already requested at line " + first.getLineNumber());
            throw new LocationAwareException((Throwable)((Object)exception), second.getScriptDisplayName(), (Integer)second.getLineNumber());
        }
        return pluginRequests;
    }

    private static class DependencySpecImpl
    implements PluginDependencySpec {
        private final PluginId id;
        private String version;
        private boolean apply;
        private final int lineNumber;

        private DependencySpecImpl(String id, int lineNumber) {
            this.id = DefaultPluginId.of(id);
            this.apply = true;
            this.lineNumber = lineNumber;
        }

        public PluginDependencySpec version(String version) {
            this.version = version;
            return this;
        }

        public PluginDependencySpec apply(boolean apply) {
            this.apply = apply;
            return this;
        }
    }
}

