/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.chart.hchart.MethodUsage;
import com.android.tools.adtui.chart.hchart.MethodUsageHRenderer;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;

public class JavaMethodUsageHRenderer
extends MethodUsageHRenderer {
    private static final Pattern dotPattern = Pattern.compile("\\.");

    @Override
    protected String generateFittingText(MethodUsage method, Rectangle2D rect, FontMetrics fontMetrics) {
        String fullyQualified = method.getNameSpace() + "." + method.getName();
        if ((double)fontMetrics.stringWidth(fullyQualified) < rect.getWidth()) {
            return fullyQualified;
        }
        String abbrevPackage = this.getShortPackageName(method.getNameSpace()) + "." + method.getName();
        if ((double)fontMetrics.stringWidth(abbrevPackage) < rect.getWidth()) {
            return abbrevPackage;
        }
        if ((double)fontMetrics.stringWidth(method.getName()) < rect.getWidth()) {
            return method.getName();
        }
        return "";
    }

    protected String getShortPackageName(String nameSpace) {
        if (nameSpace == null || nameSpace.equals("")) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        String[] elements = dotPattern.split(nameSpace);
        String separator = "";
        for (int i = 0; i < elements.length; ++i) {
            b.append(separator);
            b.append(elements[i].charAt(0));
            separator = ".";
        }
        return b.toString();
    }
}

