/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.nano;

import com.google.protobuf3jarjar.nano.CodedOutputByteBufferNano;
import com.google.protobuf3jarjar.nano.MessageNano;
import io.grpc.KnownLength;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

class NanoProtoInputStream
extends InputStream
implements KnownLength {
    @Nullable
    private MessageNano message;
    @Nullable
    private ByteArrayInputStream partial;

    public NanoProtoInputStream(MessageNano message) {
        this.message = message;
    }

    private void toPartial() {
        if (this.message != null) {
            this.partial = new ByteArrayInputStream(MessageNano.toByteArray((MessageNano)this.message));
            this.message = null;
        }
    }

    @Override
    public int read() throws IOException {
        this.toPartial();
        if (this.partial != null) {
            return this.partial.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.message != null) {
            int size = this.message.getSerializedSize();
            if (size == 0) {
                this.message = null;
                this.partial = null;
                return -1;
            }
            if (len >= size) {
                CodedOutputByteBufferNano output = CodedOutputByteBufferNano.newInstance((byte[])b, (int)off, (int)size);
                this.message.writeTo(output);
                output.checkNoSpaceLeft();
                this.message = null;
                this.partial = null;
                return size;
            }
            this.toPartial();
        }
        if (this.partial != null) {
            return this.partial.read(b, off, len);
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.message != null) {
            return this.message.getSerializedSize();
        }
        if (this.partial != null) {
            return this.partial.available();
        }
        return 0;
    }
}

