/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManager;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNSSLTrustManager;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNSSLPasspharsePromptSupport;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNAuthenticationManager
implements ISVNAuthenticationManager,
ISVNSSLPasspharsePromptSupport,
ISVNSSHHostVerifier {
    private boolean myIsStoreAuth;
    private File myConfigDirectory;
    private ISVNAuthenticationStorageOptions myAuthOptions;
    private DefaultSVNOptions myDefaultOptions;
    private ISVNHostOptionsProvider myHostOptionsProvider;
    private ISVNAuthenticationStorage myRuntimeAuthStorage;
    private ISVNAuthenticationProvider[] myProviders;
    private SVNAuthentication myPreviousAuthentication;
    private SVNErrorMessage myPreviousErrorMessage;
    private int myLastProviderIndex;
    private SVNAuthentication myLastLoadedAuth;
    private boolean myIsAuthenticationForced;
    private boolean myIsAutoDismissSensitiveData;

    public DefaultSVNAuthenticationManager(File configDirectory, boolean storeAuth, String userName, String password) {
        this(configDirectory, storeAuth, userName, password != null ? password.toCharArray() : null, null, null);
    }

    public DefaultSVNAuthenticationManager(File configDirectory, boolean storeAuth, String userName, String password, File privateKey, String passphrase) {
        this(configDirectory, storeAuth, userName, password != null ? password.toCharArray() : null, privateKey, passphrase != null ? passphrase.toCharArray() : null);
    }

    public DefaultSVNAuthenticationManager(File configDirectory, boolean storeAuth, String userName, char[] password, File privateKey, char[] passphrase) {
        this.myIsStoreAuth = storeAuth;
        this.myConfigDirectory = configDirectory;
        if (this.myConfigDirectory == null) {
            this.myConfigDirectory = SVNWCUtil.getDefaultConfigurationDirectory();
        }
        this.myProviders = new ISVNAuthenticationProvider[4];
        this.myProviders[0] = this.createDefaultAuthenticationProvider(userName, password, privateKey, passphrase, this.myIsStoreAuth);
        this.myProviders[1] = this.createRuntimeAuthenticationProvider();
        this.myProviders[2] = this.createCacheAuthenticationProvider(new File(this.myConfigDirectory, "auth"), userName);
    }

    public void setInMemoryServersOptions(Map serversOptions) {
        if (this.getHostOptionsProvider() instanceof DefaultSVNHostOptionsProvider) {
            DefaultSVNHostOptionsProvider defaultHostOptionsProvider = (DefaultSVNHostOptionsProvider)this.getHostOptionsProvider();
            defaultHostOptionsProvider.setInMemoryServersOptions(serversOptions);
        }
    }

    public void setInMemoryConfigOptions(Map configOptions) {
        this.getDefaultOptions().setInMemoryConfigOptions(configOptions);
    }

    public ISVNAuthenticationStorageOptions getAuthenticationStorageOptions() {
        if (this.myAuthOptions == null) {
            return ISVNAuthenticationStorageOptions.DEFAULT;
        }
        return this.myAuthOptions;
    }

    public void setAuthenticationStorageOptions(ISVNAuthenticationStorageOptions authOptions) {
        this.myAuthOptions = authOptions;
    }

    @Override
    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
        this.myProviders[3] = provider;
    }

    protected File getConfigDirectory() {
        return this.myConfigDirectory;
    }

    public DefaultSVNOptions getDefaultOptions() {
        if (this.myDefaultOptions == null) {
            this.myDefaultOptions = new DefaultSVNOptions(this.myConfigDirectory, true);
        }
        return this.myDefaultOptions;
    }

    public ISVNHostOptionsProvider getHostOptionsProvider() {
        if (this.myHostOptionsProvider == null) {
            this.myHostOptionsProvider = new ExtendedHostOptionsProvider();
        }
        return this.myHostOptionsProvider;
    }

    protected void setHostOptionsProvider(ISVNHostOptionsProvider hostOptionsProvider) {
        this.myHostOptionsProvider = hostOptionsProvider;
    }

    public Collection<String> getAuthTypes(SVNURL url) {
        return this.getHostOptionsProvider().getHostOptions(url).getAuthTypes();
    }

    @Override
    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        ISVNHostOptions hostOptions = this.getHostOptionsProvider().getHostOptions(url);
        String proxyHost = hostOptions.getProxyHost();
        if (proxyHost == null) {
            return null;
        }
        String proxyPort = hostOptions.getProxyPort();
        String proxyUser = hostOptions.getProxyUserName();
        String proxyPassword = hostOptions.getProxyPassword();
        return new SimpleProxyManager(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    @Override
    public TrustManager getTrustManager(SVNURL url) throws SVNException {
        ISVNHostOptions hostOptions = this.getHostOptionsProvider().getHostOptions(url);
        boolean trustAll = hostOptions.trustDefaultSSLCertificateAuthority();
        File[] serverCertFiles = hostOptions.getSSLAuthorityFiles();
        File authDir = new File(this.myConfigDirectory, "auth/svn.ssl.server");
        return new DefaultSVNSSLTrustManager(authDir, url, serverCertFiles, trustAll, this);
    }

    @Override
    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        this.myPreviousAuthentication = null;
        this.myPreviousErrorMessage = null;
        this.myLastProviderIndex = 0;
        this.myLastLoadedAuth = null;
        for (int i = 0; i < this.myProviders.length; ++i) {
            if (this.myProviders[i] == null) continue;
            SVNAuthentication auth = this.myProviders[i].requestClientAuthentication(kind, url, realm, null, this.myPreviousAuthentication, this.myIsStoreAuth);
            if (auth != null) {
                if (i == 2) {
                    this.myLastLoadedAuth = auth;
                }
                this.myPreviousAuthentication = auth;
                this.myLastProviderIndex = i;
                if (auth.isPartial()) continue;
                return auth;
            }
            if (i != 3) continue;
            SVNErrorManager.cancel("authentication cancelled", SVNLogType.WC);
        }
        if ("svn.username".equals(kind)) {
            return SVNUserNameAuthentication.newInstance("", this.getHostOptionsProvider().getHostOptions(url).isAuthStorageEnabled(), url, false);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    @Override
    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        int index;
        for (int i = index = Math.min(this.myLastProviderIndex + 1, 3); i < this.myProviders.length; ++i) {
            if (this.myProviders[i] == null || (i == 1 || i == 2) && this.hasExplicitCredentials(kind)) continue;
            SVNAuthentication auth = this.myProviders[i].requestClientAuthentication(kind, url, realm, this.myPreviousErrorMessage, this.myPreviousAuthentication, this.myIsStoreAuth);
            if (auth != null) {
                if (i == 2) {
                    this.myLastLoadedAuth = auth;
                }
                this.myPreviousAuthentication = auth;
                this.myLastProviderIndex = i;
                if (auth.isPartial()) continue;
                return auth;
            }
            if (i != 3) continue;
            SVNErrorManager.cancel("authentication cancelled", SVNLogType.WC);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    public void setDismissSensitiveDataUponUse(boolean dismiss) {
        this.myIsAutoDismissSensitiveData = dismiss;
    }

    public boolean isDismissSensitiveDataUponUse() {
        return this.myIsAutoDismissSensitiveData;
    }

    @Override
    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
        if (!accepted) {
            if (this.isDismissSensitiveDataUponUse()) {
                authentication.dismissSensitiveData();
            }
            this.myPreviousErrorMessage = errorMessage;
            this.myPreviousAuthentication = authentication;
            this.myLastLoadedAuth = null;
            return;
        }
        if (this.myIsStoreAuth && authentication.isStorageAllowed() && this.myProviders[2] instanceof ISVNPersistentAuthenticationProvider && (this.myLastLoadedAuth == null || this.myLastLoadedAuth != authentication)) {
            ((ISVNPersistentAuthenticationProvider)((Object)this.myProviders[2])).saveAuthentication(authentication, kind, realm);
        }
        this.myLastLoadedAuth = null;
        if (!this.hasExplicitCredentials(kind)) {
            ((CacheAuthenticationProvider)this.myProviders[1]).saveAuthentication(authentication, realm);
        } else if (this.isDismissSensitiveDataUponUse()) {
            authentication.dismissSensitiveData();
        }
    }

    @Override
    public void acknowledgeTrustManager(TrustManager manager) {
    }

    private boolean hasExplicitCredentials(String kind) {
        if (("svn.simple".equals(kind) || "svn.username".equals(kind) || "svn.ssh".equals(kind)) && this.myProviders[0] instanceof DumbAuthenticationProvider) {
            DumbAuthenticationProvider authProvider = (DumbAuthenticationProvider)this.myProviders[0];
            String userName = authProvider.myUserName;
            char[] password = authProvider.myPassword;
            if ("svn.username".equals(kind)) {
                return userName != null && !"".equals(userName);
            }
            return password != null && password.length > 0 && userName != null && !"".equals(userName);
        }
        return false;
    }

    public void setRuntimeStorage(ISVNAuthenticationStorage storage) {
        this.myRuntimeAuthStorage = storage;
    }

    protected ISVNAuthenticationStorage getRuntimeAuthStorage() {
        if (this.myRuntimeAuthStorage == null) {
            this.myRuntimeAuthStorage = new RuntimeStorage();
        }
        return this.myRuntimeAuthStorage;
    }

    protected ISVNAuthenticationProvider getAuthenticationProvider() {
        return this.myProviders[3];
    }

    protected SVNSSHAuthentication getDefaultSSHAuthentication(SVNURL url) {
        String userName = this.getDefaultOptions().getDefaultSSHUserName();
        String password = this.getDefaultOptions().getDefaultSSHPassword();
        String keyFile = this.getDefaultOptions().getDefaultSSHKeyFile();
        int port = this.getDefaultOptions().getDefaultSSHPortNumber();
        String passphrase = this.getDefaultOptions().getDefaultSSHPassphrase();
        if (userName != null && password != null) {
            return SVNSSHAuthentication.newInstance(userName, password.toCharArray(), port, this.getHostOptionsProvider().getHostOptions(url).isAuthStorageEnabled(), url, false);
        }
        if (userName != null && keyFile != null) {
            return SVNSSHAuthentication.newInstance(userName, new File(keyFile), passphrase != null ? passphrase.toCharArray() : null, port, this.getHostOptionsProvider().getHostOptions(url).isAuthStorageEnabled(), url, false);
        }
        return null;
    }

    protected ISVNAuthenticationProvider createDefaultAuthenticationProvider(String userName, char[] password, File privateKey, char[] passphrase, boolean allowSave) {
        return new DumbAuthenticationProvider(userName, password, privateKey, passphrase, allowSave);
    }

    protected ISVNAuthenticationProvider createRuntimeAuthenticationProvider() {
        return new CacheAuthenticationProvider();
    }

    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File authDir, String userName) {
        ISVNAuthenticationStorageOptions delegatingOptions = this.createAuthenticationStorageOptions();
        return new DefaultSVNPersistentAuthenticationProvider(authDir, userName, delegatingOptions, this.getDefaultOptions(), this.getHostOptionsProvider());
    }

    public ISVNAuthenticationStorageOptions createAuthenticationStorageOptions() {
        return new ISVNAuthenticationStorageOptions(){

            @Override
            public boolean isNonInteractive() throws SVNException {
                return DefaultSVNAuthenticationManager.this.getAuthenticationStorageOptions().isNonInteractive();
            }

            @Override
            public ISVNAuthStoreHandler getAuthStoreHandler() throws SVNException {
                return DefaultSVNAuthenticationManager.this.getAuthenticationStorageOptions().getAuthStoreHandler();
            }

            @Override
            public boolean isSSLPassphrasePromptSupported() {
                if (DefaultSVNAuthenticationManager.this.getAuthenticationStorageOptions() == ISVNAuthenticationStorageOptions.DEFAULT) {
                    return DefaultSVNAuthenticationManager.this.isSSLPassphrasePromtSupported();
                }
                return DefaultSVNAuthenticationManager.this.getAuthenticationStorageOptions().isSSLPassphrasePromptSupported();
            }

            @Override
            public ISVNGnomeKeyringPasswordProvider getGnomeKeyringPasswordProvider() {
                return DefaultSVNAuthenticationManager.this.getAuthenticationStorageOptions().getGnomeKeyringPasswordProvider();
            }
        };
    }

    @Override
    public boolean isAuthenticationForced() {
        return this.myIsAuthenticationForced;
    }

    public void setAuthenticationForced(boolean forced) {
        this.myIsAuthenticationForced = forced;
    }

    @Override
    public int getReadTimeout(SVNRepository repository) {
        return this.getHostOptionsProvider().getHostOptions(repository.getLocation()).getReadTimeout();
    }

    @Override
    public int getConnectTimeout(SVNRepository repository) {
        return this.getHostOptionsProvider().getHostOptions(repository.getLocation()).getConnectTimeout();
    }

    @Override
    public void verifyHostKey(String hostName, int port, String keyAlgorithm, byte[] hostKey) throws SVNException {
        String realm = hostName + ":" + port + " <" + keyAlgorithm + ">";
        byte[] existingFingerprints = (byte[])this.getRuntimeAuthStorage().getData("svn.ssh.server", realm);
        if (existingFingerprints == null && this.myProviders[2] instanceof ISVNPersistentAuthenticationProvider) {
            existingFingerprints = ((ISVNPersistentAuthenticationProvider)((Object)this.myProviders[2])).loadFingerprints(realm);
        }
        if (existingFingerprints == null || !DefaultSVNAuthenticationManager.equals(existingFingerprints, hostKey)) {
            SVNURL url = SVNURL.create("svn+ssh", null, hostName, port, "", true);
            ISVNHostOptions hostOptions = this.getHostOptionsProvider().getHostOptions(url);
            boolean storageEnabled = hostOptions.isAuthStorageEnabled();
            if (this.getAuthenticationProvider() != null) {
                int accepted = this.getAuthenticationProvider().acceptServerAuthentication(url, realm, hostKey, storageEnabled);
                if (accepted == 2 && storageEnabled) {
                    if (storageEnabled && hostKey != null && this.myProviders[2] instanceof ISVNPersistentAuthenticationProvider) {
                        ((ISVNPersistentAuthenticationProvider)((Object)this.myProviders[2])).saveFingerprints(realm, hostKey);
                    }
                } else if (accepted == 0) {
                    throw new SVNAuthenticationException(SVNErrorMessage.create(SVNErrorCode.AUTHN_CREDS_NOT_SAVED, "Host key ('" + realm + "') can not be verified."));
                }
                if (hostKey != null) {
                    this.getRuntimeAuthStorage().putData("svn.ssh.server", realm, hostKey);
                }
            }
        }
    }

    private static boolean equals(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == b1) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b2.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public void dismissSensitiveData() {
        if (this.myRuntimeAuthStorage instanceof RuntimeStorage) {
            ((RuntimeStorage)this.myRuntimeAuthStorage).clear();
        }
        if (this.myProviders[0] instanceof DumbAuthenticationProvider) {
            ((DumbAuthenticationProvider)this.myProviders[0]).dismissSensitiveData();
        }
    }

    @Override
    public boolean isSSLPassphrasePromtSupported() {
        if (this.getAuthenticationProvider() == null) {
            return true;
        }
        if (this.getAuthenticationProvider() instanceof ISVNSSLPasspharsePromptSupport) {
            return ((ISVNSSLPasspharsePromptSupport)((Object)this.getAuthenticationProvider())).isSSLPassphrasePromtSupported();
        }
        return false;
    }

    private static class RuntimeStorage
    implements ISVNAuthenticationStorage {
        private Map<String, Object> myData = new HashMap<String, Object>();

        private RuntimeStorage() {
        }

        @Override
        public void putData(String kind, String realm, Object data) {
            this.myData.put(kind + "$" + realm, data);
        }

        public void clear() {
            for (Object auth : this.myData.values()) {
                if (!(auth instanceof SVNAuthentication)) continue;
                ((SVNAuthentication)auth).dismissSensitiveData();
            }
            this.myData.clear();
        }

        @Override
        public Object getData(String kind, String realm) {
            return this.myData.get(kind + "$" + realm);
        }
    }

    private static final class SimpleProxyManager
    implements ISVNProxyManager {
        private String myProxyHost;
        private String myProxyPort;
        private String myProxyUser;
        private String myProxyPassword;

        public SimpleProxyManager(String host, String port, String user, String password) {
            this.myProxyHost = host;
            this.myProxyPort = port == null ? "3128" : port;
            this.myProxyUser = user;
            this.myProxyPassword = password;
        }

        @Override
        public String getProxyHost() {
            return this.myProxyHost;
        }

        @Override
        public int getProxyPort() {
            try {
                return Integer.parseInt(this.myProxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                return 3128;
            }
        }

        @Override
        public String getProxyUserName() {
            return this.myProxyUser;
        }

        @Override
        public String getProxyPassword() {
            return this.myProxyPassword;
        }

        @Override
        public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
        }
    }

    public class ExtendedHostOptions
    extends DefaultSVNHostOptions {
        public ExtendedHostOptions(SVNCompositeConfigFile serversFile, SVNURL url) {
            super(serversFile, url);
        }

        @Override
        public boolean isAuthStorageEnabled() {
            if (!super.hasAuthStorageEnabledOption()) {
                return DefaultSVNAuthenticationManager.this.myIsStoreAuth;
            }
            return super.isAuthStorageEnabled();
        }

        @Override
        public boolean isStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
            if (!super.hasStorePlainTextPasswordsOption()) {
                ISVNAuthStoreHandler handler = DefaultSVNAuthenticationManager.this.getAuthenticationStorageOptions().getAuthStoreHandler();
                if (handler != null) {
                    return handler.canStorePlainTextPasswords(realm, auth);
                }
                return false;
            }
            return super.isStorePlainTextPasswords(realm, auth);
        }

        @Override
        public boolean isStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
            if (!super.hasStorePlainTextPassphrasesOption()) {
                ISVNAuthStoreHandler handler = DefaultSVNAuthenticationManager.this.getAuthenticationStorageOptions().getAuthStoreHandler();
                if (handler != null) {
                    return handler.canStorePlainTextPassphrases(realm, auth);
                }
                return false;
            }
            return super.isStorePlainTextPassphrases(realm, auth);
        }
    }

    public class ExtendedHostOptionsProvider
    extends DefaultSVNHostOptionsProvider {
        public ExtendedHostOptionsProvider() {
            super(DefaultSVNAuthenticationManager.this.myConfigDirectory);
        }

        @Override
        public ISVNHostOptions getHostOptions(SVNURL url) {
            return new ExtendedHostOptions(this.getServersFile(), url);
        }
    }

    private class CacheAuthenticationProvider
    implements ISVNAuthenticationProvider {
        private CacheAuthenticationProvider() {
        }

        @Override
        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            String actualRealm = realm;
            if (url != null && url.getUserInfo() != null) {
                actualRealm = url.getUserInfo() + "$" + actualRealm;
            }
            return (SVNAuthentication)DefaultSVNAuthenticationManager.this.getRuntimeAuthStorage().getData(kind, actualRealm);
        }

        public void saveAuthentication(SVNAuthentication auth, String realm) {
            if (auth == null || realm == null) {
                return;
            }
            String kind = auth.getKind();
            String actualRealm = realm;
            if (auth.getURL() != null && auth.getURL().getUserInfo() != null) {
                actualRealm = auth.getURL().getUserInfo() + "$" + actualRealm;
            }
            DefaultSVNAuthenticationManager.this.getRuntimeAuthStorage().putData(kind, actualRealm, auth);
        }

        @Override
        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }
    }

    protected class DumbAuthenticationProvider
    implements ISVNAuthenticationProvider {
        private String myUserName;
        private char[] myPassword;
        private boolean myIsStore;
        private char[] myPassphrase;
        private File myPrivateKey;

        public DumbAuthenticationProvider(String userName, char[] password, File privateKey, char[] passphrase, boolean store) {
            this.myUserName = userName;
            this.myPassword = password;
            this.myPrivateKey = privateKey;
            this.myPassphrase = passphrase;
            this.myIsStore = store;
        }

        @Override
        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            if (previousAuth == null) {
                if ("svn.ssh".equals(kind)) {
                    SVNSSHAuthentication sshAuth = DefaultSVNAuthenticationManager.this.getDefaultSSHAuthentication(url);
                    if (this.myUserName == null || "".equals(this.myUserName.trim())) {
                        return sshAuth;
                    }
                    if (this.myPrivateKey != null) {
                        return SVNSSHAuthentication.newInstance(this.myUserName, this.myPrivateKey, this.myPassphrase, sshAuth != null ? sshAuth.getPortNumber() : -1, this.myIsStore, url, false).copy();
                    }
                    return SVNSSHAuthentication.newInstance(this.myUserName, this.myPassword, sshAuth != null ? sshAuth.getPortNumber() : -1, this.myIsStore, url, false).copy();
                }
                if ("svn.simple".equals(kind)) {
                    if (this.myUserName == null || "".equals(this.myUserName.trim())) {
                        String defaultUserName = DefaultSVNAuthenticationManager.this.getHostOptionsProvider().getHostOptions(url).getUserName();
                        String string = defaultUserName = defaultUserName == null ? System.getProperty("user.name") : defaultUserName;
                        if (defaultUserName != null) {
                            SVNPasswordAuthentication partialAuth = SVNPasswordAuthentication.newInstance(defaultUserName, null, false, url, true);
                            return partialAuth;
                        }
                        return null;
                    }
                    if (this.myPassword == null) {
                        return SVNPasswordAuthentication.newInstance(this.myUserName, null, false, url, true);
                    }
                    return SVNPasswordAuthentication.newInstance(this.myUserName, this.myPassword, this.myIsStore, url, false).copy();
                }
                if ("svn.username".equals(kind)) {
                    if (this.myUserName == null || "".equals(this.myUserName)) {
                        String userName = System.getProperty("svnkit.ssh2.author", System.getProperty("javasvn.ssh2.author"));
                        if (userName != null) {
                            return SVNUserNameAuthentication.newInstance(userName, this.myIsStore, url, false);
                        }
                        return null;
                    }
                    return SVNUserNameAuthentication.newInstance(this.myUserName, this.myIsStore, url, false);
                }
            }
            return null;
        }

        @Override
        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }

        public void dismissSensitiveData() {
            SVNEncodingUtil.clearArray(this.myPassphrase);
            SVNEncodingUtil.clearArray(this.myPassword);
        }
    }
}

