/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class CompilerTestUtil {
    private CompilerTestUtil() {
    }

    public static void setupJavacForTests(Project project) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance(project);
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
    }

    public static void saveApplicationSettings() {
        EdtTestUtil.runInEdtAndWait(() -> {
            CompilerTestUtil.doSaveComponent((PersistentStateComponent)((Object)ProjectJdkTable.getInstance()));
            CompilerTestUtil.doSaveComponent((PersistentStateComponent)((Object)FileTypeManager.getInstance()));
            CompilerTestUtil.doSaveComponent((PersistentStateComponent)((Object)PathMacros.getInstance()));
        });
    }

    public static void saveApplicationComponent(@NotNull PersistentStateComponent<?> appComponent) {
        if (appComponent == null) {
            CompilerTestUtil.$$$reportNull$$$0(0);
        }
        EdtTestUtil.runInEdtAndWait(() -> {
            if (appComponent == null) {
                CompilerTestUtil.$$$reportNull$$$0(5);
            }
            CompilerTestUtil.doSaveComponent(appComponent);
        });
    }

    private static void doSaveComponent(@NotNull PersistentStateComponent<?> component) {
        if (component == null) {
            CompilerTestUtil.$$$reportNull$$$0(1);
        }
        ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).saveApplicationComponent(component);
    }

    public static void enableExternalCompiler() {
        final JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
        new WriteAction(){

            @Override
            protected void run(@NotNull Result result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                table.addJdk(table.getInternalJdk());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/CompilerTestUtil$1", "run"));
            }
        }.execute();
    }

    public static void disableExternalCompiler(@NotNull Project project) {
        if (project == null) {
            CompilerTestUtil.$$$reportNull$$$0(2);
        }
        EdtTestUtil.runInEdtAndWait(() -> {
            if (project == null) {
                CompilerTestUtil.$$$reportNull$$$0(3);
            }
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    CompilerTestUtil.$$$reportNull$$$0(4);
                }
                Sdk internalJdk = table.getInternalJdk();
                SmartList modulesToRestore = new SmartList();
                for (Module module : ModuleManager.getInstance(project).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance(module).getSdk();
                    if (sdk == null || !sdk.equals(internalJdk)) continue;
                    modulesToRestore.add(module);
                }
                for (Module module : modulesToRestore) {
                    ModuleRootModificationUtil.setModuleSdk(module, internalJdk);
                }
                table.removeJdk(internalJdk);
                BuildManager.getInstance().clearState(project);
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/CompilerTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveApplicationComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doSaveComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "disableExternalCompiler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$disableExternalCompiler$3";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$saveApplicationComponent$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

