/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.taskdefs;

import com.intellij.compiler.ant.Tag;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipFileSet
extends Tag {
    public static final ZipFileSet[] EMPTY_ARRAY = new ZipFileSet[0];

    private ZipFileSet(@NonNls String tagName, Pair ... tagOptions) {
        super(tagName, tagOptions);
    }

    public ZipFileSet(@NonNls String fileOrDir, @NonNls String relativePath, boolean isDir) {
        super("zipfileset", new Pair[]{ZipFileSet.pair(isDir ? "dir" : "file", fileOrDir), ZipFileSet.pair("prefix", ZipFileSet.prefix(isDir, relativePath))});
    }

    public static ZipFileSet createUnpackedSet(@NonNls String zipFilePath, @NotNull String relativePath, boolean isDir) {
        if (relativePath == null) {
            ZipFileSet.$$$reportNull$$$0(0);
        }
        return new ZipFileSet("zipfileset", new Pair[]{ZipFileSet.pair("src", zipFilePath), ZipFileSet.pair("prefix", ZipFileSet.prefix(isDir, relativePath))});
    }

    @Nullable
    private static String prefix(boolean isDir, String relativePath) {
        String path2;
        if (isDir) {
            path2 = relativePath;
        } else {
            String parent = new File(relativePath).getParent();
            String string = path2 = parent == null ? "" : FileUtil.toSystemIndependentName((String)parent);
        }
        if (path2 != null) {
            path2 = StringUtil.trimStart((String)path2, (String)"/");
        }
        return !StringUtil.isEmpty((String)path2) ? path2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/compiler/ant/taskdefs/ZipFileSet", "createUnpackedSet"));
    }
}

