/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public enum ShortenCommandLine {
    NONE("none", "java [options] classname [args]"),
    MANIFEST("JAR manifest", "java -cp classpath.jar classname [args]"),
    CLASSPATH_FILE("classpath file", "java WrapperClass classpathFile [args]"),
    ARGS_FILE("@argFiles (java 9+)", "java @argFile [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot != null && JdkUtil.isModularRuntime(jreRoot);
        }
    };

    private final String myPresentableName;
    private final String myDescription;

    private ShortenCommandLine(String presentableName, String description) {
        this.myPresentableName = presentableName;
        this.myDescription = description;
    }

    public boolean isApplicable(String jreRoot) {
        return true;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public static ShortenCommandLine getDefaultMethod(Project project, String rootPath) {
        if (!JdkUtil.useDynamicClasspath(project)) {
            return NONE;
        }
        if (rootPath != null && JdkUtil.isModularRuntime(rootPath)) {
            return ARGS_FILE;
        }
        if (JdkUtil.useClasspathJar()) {
            return MANIFEST;
        }
        return CLASSPATH_FILE;
    }

    public static ShortenCommandLine readShortenClasspathMethod(@NotNull Element element) {
        Element mode;
        if (element == null) {
            ShortenCommandLine.$$$reportNull$$$0(0);
        }
        if ((mode = element.getChild("shortenClasspath")) != null) {
            return ShortenCommandLine.valueOf(mode.getAttributeValue("name"));
        }
        return null;
    }

    public static void writeShortenClasspathMethod(@NotNull Element element, ShortenCommandLine shortenCommandLine) {
        if (element == null) {
            ShortenCommandLine.$$$reportNull$$$0(1);
        }
        if (shortenCommandLine != null) {
            element.addContent(new Element("shortenClasspath").setAttribute("name", shortenCommandLine.name()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/execution/ShortenCommandLine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readShortenClasspathMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeShortenClasspathMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

