/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="module")
public class RunConfigurationModule
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(RunConfigurationModule.class);
    @NonNls
    private static final String ELEMENT = "module";
    @NonNls
    private static final String ATTRIBUTE = "name";
    private Module myModule;
    @Attribute(value="name")
    private String myModuleName;
    private final Project myProject;

    public RunConfigurationModule(@NotNull Project project) {
        if (project == null) {
            RunConfigurationModule.$$$reportNull$$$0(0);
        }
        this.myModule = null;
        this.myProject = project;
    }

    public void readExternal(@NotNull Element element) {
        List modules;
        if (element == null) {
            RunConfigurationModule.$$$reportNull$$$0(1);
        }
        if (!(modules = element.getChildren(ELEMENT)).isEmpty()) {
            String moduleName;
            if (modules.size() > 1) {
                LOG.warn("Module serialized more than one time");
            }
            if (!StringUtil.isEmpty((String)(moduleName = ((Element)modules.get(0)).getAttributeValue(ATTRIBUTE)))) {
                this.myModuleName = moduleName;
            }
        }
    }

    public void writeExternal(@NotNull Element parent) {
        Element prev;
        if (parent == null) {
            RunConfigurationModule.$$$reportNull$$$0(2);
        }
        if ((prev = parent.getChild(ELEMENT)) == null) {
            prev = new Element(ELEMENT);
            parent.addContent(prev);
        }
        prev.setAttribute(ATTRIBUTE, this.getModuleName());
    }

    public void init() {
        Module[] modules;
        if (StringUtil.isEmptyOrSpaces((String)this.getModuleName()) && (modules = this.getModuleManager().getModules()).length > 0) {
            this.setModule(modules[0]);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RunConfigurationModule.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Transient
    @Nullable
    public Module getModule() {
        if (this.myModuleName != null) {
            this.myModule = this.findModule(this.myModuleName);
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModule = null;
        }
        return this.myModule;
    }

    @Nullable
    public Module findModule(@NotNull String moduleName) {
        if (moduleName == null) {
            RunConfigurationModule.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return this.getModuleManager().findModuleByName(moduleName);
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myModuleName = module != null ? module.getName() : null;
    }

    public void setModuleName(@Nullable String moduleName) {
        if (!Comparing.equal((String)this.myModuleName, (String)moduleName)) {
            this.myModuleName = moduleName;
            this.myModule = null;
        }
    }

    @NotNull
    public String getModuleName() {
        String string = StringUtil.notNullize((String)this.myModuleName);
        if (string == null) {
            RunConfigurationModule.$$$reportNull$$$0(5);
        }
        return string;
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance(this.myProject);
    }

    public void checkForWarning() throws RuntimeConfigurationException {
        Module module = this.getModule();
        if (module != null) {
            if (ModuleRootManager.getInstance(module).getSdk() == null) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message("no.jdk.specified.for.module.warning.text", module.getName()));
            }
        } else {
            if (this.myModuleName != null) {
                if (ModuleManager.getInstance(this.myProject).getUnloadedModuleDescription(this.myModuleName) != null) {
                    throw new RuntimeConfigurationError(ExecutionBundle.message("module.is.unloaded.from.project.error.text", this.myModuleName));
                }
                throw new RuntimeConfigurationError(ExecutionBundle.message("module.doesn.t.exist.in.project.error.text", this.myModuleName));
            }
            throw new RuntimeConfigurationError(ExecutionBundle.message("module.not.specified.error.text", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfigurationModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfigurationModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

