/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiIntersectionType
extends PsiType.Stub {
    private final PsiType[] myConjuncts;

    private PsiIntersectionType(@NotNull PsiType[] conjuncts) {
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(0);
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myConjuncts = conjuncts;
    }

    @NotNull
    public static PsiType createIntersection(@NotNull List<PsiType> conjuncts) {
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(1);
        }
        PsiType psiType = PsiIntersectionType.createIntersection(conjuncts.toArray(PsiIntersectionType.createArray(conjuncts.size())));
        if (psiType == null) {
            PsiIntersectionType.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @NotNull
    public static PsiType createIntersection(PsiType ... conjuncts) {
        PsiType psiType = PsiIntersectionType.createIntersection(true, conjuncts);
        if (psiType == null) {
            PsiIntersectionType.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    @NotNull
    public static PsiType createIntersection(boolean flatten, PsiType ... conjuncts) {
        if (conjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(4);
        }
        assert (conjuncts.length > 0);
        if (flatten) {
            conjuncts = PsiIntersectionType.flattenAndRemoveDuplicates(conjuncts);
        }
        if (conjuncts.length == 1) {
            PsiType psiType = conjuncts[0];
            if (psiType == null) {
                PsiIntersectionType.$$$reportNull$$$0(5);
            }
            return psiType;
        }
        PsiIntersectionType psiIntersectionType = new PsiIntersectionType(conjuncts);
        if (psiIntersectionType == null) {
            PsiIntersectionType.$$$reportNull$$$0(6);
        }
        return psiIntersectionType;
    }

    @NotNull
    private static PsiType[] flattenAndRemoveDuplicates(@NotNull PsiType[] conjuncts) {
        Set<PsiType> flattenConjuncts;
        block5: {
            block6: {
                if (conjuncts == null) {
                    PsiIntersectionType.$$$reportNull$$$0(7);
                }
                try {
                    flattenConjuncts = PsiIntersectionType.flatten(conjuncts, ContainerUtil.newLinkedHashSet());
                    if (flattenConjuncts != null) break block5;
                    if (conjuncts != null) break block6;
                }
                catch (NoSuchElementException e) {
                    throw new RuntimeException(Arrays.toString(conjuncts), e);
                }
                PsiIntersectionType.$$$reportNull$$$0(8);
            }
            return conjuncts;
        }
        PsiType[] psiTypeArray = flattenConjuncts.toArray(PsiIntersectionType.createArray(flattenConjuncts.size()));
        if (psiTypeArray == null) {
            PsiIntersectionType.$$$reportNull$$$0(9);
        }
        return psiTypeArray;
    }

    public static Set<PsiType> flatten(PsiType[] conjuncts, Set<PsiType> types) {
        for (PsiType conjunct : conjuncts) {
            if (conjunct instanceof PsiIntersectionType) {
                PsiIntersectionType type = (PsiIntersectionType)conjunct;
                PsiIntersectionType.flatten(type.getConjuncts(), types);
                continue;
            }
            types.add(conjunct);
        }
        if (types.size() > 1) {
            PsiType[] array = types.toArray(PsiIntersectionType.createArray(types.size()));
            Iterator<PsiType> iterator = types.iterator();
            block1: while (iterator.hasNext()) {
                PsiType type = iterator.next();
                for (PsiType existing : array) {
                    boolean allowUncheckedConversion;
                    if (type == existing) continue;
                    boolean bl = allowUncheckedConversion = type instanceof PsiClassType && ((PsiClassType)type).isRaw();
                    if (!TypeConversionUtil.isAssignable(type, existing, allowUncheckedConversion)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            if (types.isEmpty()) {
                types.add(array[0]);
            }
        }
        return types;
    }

    @NotNull
    public PsiType[] getConjuncts() {
        if (this.myConjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(10);
        }
        return this.myConjuncts;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = StringUtil.join((Object[])this.myConjuncts, psiType -> psiType.getPresentableText(annotated), (String)" & ");
        if (string == null) {
            PsiIntersectionType.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.myConjuncts[0].getCanonicalText(annotated);
        if (string == null) {
            PsiIntersectionType.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = StringUtil.join((Object[])this.myConjuncts, psiType -> psiType.getInternalCanonicalText(), (String)" & ");
        if (string == null) {
            PsiIntersectionType.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public boolean isValid() {
        for (PsiType conjunct : this.myConjuncts) {
            if (conjunct.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiIntersectionType.$$$reportNull$$$0(14);
        }
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            PsiIntersectionType.$$$reportNull$$$0(15);
        }
        return visitor.visitIntersectionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myConjuncts[0].getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (this.myConjuncts == null) {
            PsiIntersectionType.$$$reportNull$$$0(16);
        }
        return this.myConjuncts;
    }

    @NotNull
    public PsiType getRepresentative() {
        PsiType psiType = this.myConjuncts[0];
        if (psiType == null) {
            PsiIntersectionType.$$$reportNull$$$0(17);
        }
        return psiType;
    }

    public boolean equals(Object obj) {
        PsiType[] second;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiIntersectionType)) {
            return false;
        }
        PsiType[] first = this.getConjuncts();
        if (first.length != (second = ((PsiIntersectionType)obj).getConjuncts()).length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myConjuncts[0].hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PsiIntersectionType: ");
        for (int i = 0; i < this.myConjuncts.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.myConjuncts[i].getPresentableText());
        }
        return sb.toString();
    }

    public String getConflictingConjunctsMessage() {
        PsiType[] conjuncts = this.getConjuncts();
        for (int i = 0; i < conjuncts.length; ++i) {
            PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i]);
            if (conjunct == null || conjunct.isInterface()) continue;
            for (int i1 = i + 1; i1 < conjuncts.length; ++i1) {
                PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly(conjuncts[i1]);
                if (oppositeConjunct == null || oppositeConjunct.isInterface() || conjunct.isInheritor(oppositeConjunct, true) || oppositeConjunct.isInheritor(conjunct, true)) continue;
                return conjuncts[i].getPresentableText() + " and " + conjuncts[i1].getPresentableText();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conjuncts";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiIntersectionType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiIntersectionType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntersection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAndRemoveDuplicates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConjuncts";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepresentative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIntersection";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndRemoveDuplicates";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

