/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.explorer.AntExplorerTreeStructure;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

final class AntExplorerTreeBuilder
extends AbstractTreeBuilder {
    private static final TreePath[] EMPTY_TREE_PATH = new TreePath[0];
    private final AntConfigurationListener myAntBuildListener;
    private final Project myProject;
    private AntConfiguration myConfig;
    private ExpandedStateUpdater myExpansionListener;

    public AntExplorerTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel) {
        super(tree, treeModel, (AbstractTreeStructure)new AntExplorerTreeStructure(project), (Comparator)IndexComparator.INSTANCE);
        this.myProject = project;
        this.myAntBuildListener = new ConfigurationListener();
        this.myConfig = AntConfiguration.getInstance(this.myProject);
        this.myConfig.addAntConfigurationListener(this.myAntBuildListener);
        this.myExpansionListener = new ExpandedStateUpdater();
        tree.addTreeExpansionListener(this.myExpansionListener);
        this.initRootNode();
    }

    public void dispose() {
        AntConfiguration config = this.myConfig;
        if (config != null) {
            config.removeAntConfigurationListener(this.myAntBuildListener);
            this.myConfig = null;
        }
        ExpandedStateUpdater expansionListener = this.myExpansionListener;
        JTree tree = this.getTree();
        if (expansionListener != null && tree != null) {
            tree.removeTreeExpansionListener(expansionListener);
            this.myExpansionListener = null;
        }
        super.dispose();
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return false;
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return ((AntNodeDescriptor)nodeDescriptor).isAutoExpand();
    }

    public void setTargetsFiltered(boolean value) {
        ((AntExplorerTreeStructure)this.getTreeStructure()).setFilteredTargets(value);
        this.queueUpdate();
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        ProgressIndicator progressIndicator = ProgressIndicatorUtils.forceWriteActionPriority((ProgressIndicator)new ProgressIndicatorBase(true), (Disposable)this);
        if (progressIndicator == null) {
            AntExplorerTreeBuilder.$$$reportNull$$$0(0);
        }
        return progressIndicator;
    }

    public void expandAll() {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        for (int row = 0; row < this.getTree().getRowCount(); ++row) {
            this.getTree().expandRow(row);
        }
        this.getTree().setSelectionPaths(EMPTY_TREE_PATH);
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, selectionPaths, (boolean)true);
    }

    void collapseAll() {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, selectionPaths, (boolean)true);
        TreeUtil.collapseAll((JTree)this.getTree(), (int)1);
        this.getTree().setSelectionPaths(EMPTY_TREE_PATH);
        pathsToExpand.clear();
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, selectionPaths, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/explorer/AntExplorerTreeBuilder", "createProgressIndicator"));
    }

    private class ExpandedStateUpdater
    implements TreeExpansionListener {
        private ExpandedStateUpdater() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.setExpandedState(event, true);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.setExpandedState(event, false);
        }

        private void setExpandedState(TreeExpansionEvent event, boolean shouldExpand) {
            Object element;
            TreePath path = event.getPath();
            AbstractTreeUi ui = AntExplorerTreeBuilder.this.getUi();
            Object lastPathComponent = path.getLastPathComponent();
            if (lastPathComponent != null && (element = ui.getElementFor(lastPathComponent)) instanceof AntBuildFileBase) {
                ((AntBuildFileBase)element).setShouldExpand(shouldExpand);
            }
        }
    }

    private final class ConfigurationListener
    implements AntConfigurationListener {
        private ConfigurationListener() {
        }

        @Override
        public void configurationLoaded() {
            AntExplorerTreeBuilder.this.queueUpdate();
        }

        @Override
        public void buildFileAdded(AntBuildFile buildFile) {
            AntExplorerTreeBuilder.this.queueUpdate();
        }

        @Override
        public void buildFileChanged(AntBuildFile buildFile) {
            AntExplorerTreeBuilder.this.queueUpdateFrom(buildFile, false);
        }

        @Override
        public void buildFileRemoved(AntBuildFile buildFile) {
            AntExplorerTreeBuilder.this.queueUpdate();
        }
    }
}

