/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;

public class ExceptionRangeCFG {
    private List<BasicBlock> protectedRange = new ArrayList<BasicBlock>();
    private BasicBlock handler;
    private List<String> exceptionTypes;

    public ExceptionRangeCFG(List<BasicBlock> protectedRange, BasicBlock handler, List<String> exceptionType) {
        this.protectedRange = protectedRange;
        this.handler = handler;
        if (exceptionType != null) {
            this.exceptionTypes = new ArrayList<String>(exceptionType);
        }
    }

    public boolean isCircular() {
        return this.protectedRange.contains(this.handler);
    }

    public String toString() {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        StringBuilder buf = new StringBuilder();
        buf.append("exceptionType:");
        for (String exception_type : this.exceptionTypes) {
            buf.append(" ").append(exception_type);
        }
        buf.append(new_line_separator);
        buf.append("handler: ").append(this.handler.id).append(new_line_separator);
        buf.append("range: ");
        for (int i = 0; i < this.protectedRange.size(); ++i) {
            buf.append(this.protectedRange.get((int)i).id).append(" ");
        }
        buf.append(new_line_separator);
        return buf.toString();
    }

    public BasicBlock getHandler() {
        return this.handler;
    }

    public void setHandler(BasicBlock handler) {
        this.handler = handler;
    }

    public List<BasicBlock> getProtectedRange() {
        return this.protectedRange;
    }

    public void setProtectedRange(List<BasicBlock> protectedRange) {
        this.protectedRange = protectedRange;
    }

    public List<String> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void addExceptionType(String exceptionType) {
        if (this.exceptionTypes == null) {
            return;
        }
        if (exceptionType == null) {
            this.exceptionTypes = null;
        } else {
            this.exceptionTypes.add(exceptionType);
        }
    }

    public String getUniqueExceptionsString() {
        if (this.exceptionTypes == null) {
            return null;
        }
        return this.exceptionTypes.stream().distinct().collect(Collectors.joining(":"));
    }
}

