/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class GroovyPositionManager
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcess myDebugProcess;
    private static final Set<FileType> ourFileTypes = Collections.singleton(GroovyFileType.GROOVY_FILE_TYPE);

    public GroovyPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        List<Location> list;
        if (type == null) {
            GroovyPositionManager.$$$reportNull$$$0(0);
        }
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(1);
        }
        GroovyPositionManager.checkGroovyFile(position);
        try {
            List<Location> locations;
            if (LOG.isDebugEnabled()) {
                LOG.debug("locationsOfLine: " + type + "; " + position);
            }
            int line = position.getLine() + 1;
            List<Location> list2 = locations = this.getDebugProcess().getVirtualMachineProxy().versionHigher("1.4") ? type.locationsOfLine("Java", null, line) : type.locationsOfLine(line);
            if (locations == null || locations.isEmpty()) {
                throw NoDataException.INSTANCE;
            }
            list = locations;
        }
        catch (AbsentInformationException e) {
            throw NoDataException.INSTANCE;
        }
        if (list == null) {
            GroovyPositionManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static GroovyPsiElement findReferenceTypeSourceImage(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        if (element == null) {
            return null;
        }
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrClosableBlock.class, GrTypeDefinition.class});
    }

    @Nullable
    private static PsiClass findEnclosingTypeDefinition(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        do {
            if (!((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrTypeDefinition.class, GroovyFileBase.class})) instanceof GroovyFileBase)) continue;
            return ((GroovyFileBase)element).getScriptClass();
        } while (!(element instanceof GrTypeDefinition) || ((GrTypeDefinition)element).isAnonymous());
        return (GrTypeDefinition)element;
    }

    private static void checkGroovyFile(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(3);
        }
        if (!(position.getFile() instanceof GroovyFileBase)) {
            throw NoDataException.INSTANCE;
        }
    }

    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            GroovyPositionManager.$$$reportNull$$$0(4);
        }
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(5);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPrepareRequest: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        String qName = GroovyPositionManager.getOuterClassName(position);
        if (qName != null) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, qName);
        }
        qName = GroovyPositionManager.findEnclosingName(position);
        if (qName == null) {
            throw NoDataException.INSTANCE;
        }
        ClassPrepareRequestor waitRequestor = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                if (!positionManager.locationsOfLine(referenceType, position).isEmpty()) {
                    requestor.processClassPrepare(debuggerProcess, referenceType);
                }
            }
        };
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(waitRequestor, qName + "$*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String findEnclosingName(@NotNull SourcePosition position) {
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(6);
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            PsiClass typeDefinition = GroovyPositionManager.findEnclosingTypeDefinition(position);
            if (typeDefinition != null) {
                String string = GroovyPositionManager.getClassNameForJvm(typeDefinition);
                return string;
            }
            String string = GroovyPositionManager.getScriptQualifiedName(position);
            return string;
        }
        finally {
            accessToken.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getOuterClassName(SourcePosition position) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
            if (sourceImage instanceof GrTypeDefinition) {
                String string = GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                return string;
            }
            if (sourceImage == null) {
                String string = GroovyPositionManager.getScriptQualifiedName(position);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            accessToken.finish();
        }
    }

    @Nullable
    private static String getClassNameForJvm(@NotNull PsiClass typeDefinition) {
        String qname;
        if (typeDefinition == null) {
            GroovyPositionManager.$$$reportNull$$$0(7);
        }
        String suffix = typeDefinition instanceof GrTypeDefinition && ((GrTypeDefinition)typeDefinition).isTrait() ? "$Trait$Helper" : "";
        PsiClass psiClass = typeDefinition.getContainingClass();
        if (psiClass != null) {
            String parent = GroovyPositionManager.getClassNameForJvm(psiClass);
            return parent == null ? null : parent + "$" + typeDefinition.getName() + suffix;
        }
        PsiFile file = typeDefinition.getContainingFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String s;
                String string = s = helper.isAppropriateScriptFile((GroovyFile)file) ? helper.customizeClassName(typeDefinition) : null;
                if (s == null) continue;
                return s;
            }
        }
        return (qname = typeDefinition.getQualifiedName()) == null ? null : qname + suffix;
    }

    @Nullable
    private static String getScriptQualifiedName(@NotNull SourcePosition position) {
        PsiFile file;
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(8);
        }
        if ((file = position.getFile()) instanceof GroovyFile) {
            return GroovyPositionManager.getScriptFQName((GroovyFile)file);
        }
        return null;
    }

    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        PsiFile psiFile;
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSourcePosition: " + location);
        }
        if ((psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location)) == null) {
            throw NoDataException.INSTANCE;
        }
        int lineNumber = this.calcLineIndex(location);
        if (lineNumber < 0) {
            throw NoDataException.INSTANCE;
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    private int calcLineIndex(Location location) {
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return -1;
        }
        return DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true);
    }

    @Nullable
    private PsiFile getPsiFileByLocation(@NotNull Project project, @Nullable Location location) {
        if (project == null) {
            GroovyPositionManager.$$$reportNull$$$0(9);
        }
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name().replace('/', '.');
        int dollar = originalQName.indexOf(36);
        String runtimeName = dollar >= 0 ? originalQName.substring(0, dollar) : originalQName;
        String qName = GroovyPositionManager.getOriginalQualifiedName(refType, runtimeName);
        GlobalSearchScope searchScope = this.myDebugProcess.getSearchScope();
        GroovyShortNamesCache cache = GroovyShortNamesCache.getGroovyShortNamesCache(project);
        try {
            List<PsiClass> classes = cache.getClassesByFQName(qName, searchScope, true);
            if (classes.isEmpty()) {
                classes = cache.getClassesByFQName(qName, searchScope, false);
            }
            if (classes.isEmpty()) {
                classes = cache.getClassesByFQName(qName, GlobalSearchScope.projectScope((Project)project), false);
            }
            if (classes.isEmpty()) {
                classes = cache.getClassesByFQName(qName, GroovyPositionManager.addModuleContent(searchScope), false);
            }
            if (classes.isEmpty()) {
                return null;
            }
            classes.sort(PsiClassUtil.createScopeComparator((GlobalSearchScope)searchScope));
            PsiClass clazz = classes.get(0);
            if (clazz != null) {
                return clazz.getContainingFile();
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            return null;
        }
        return GroovyPositionManager.getExtraScriptIfNotFound(project, refType, runtimeName, searchScope);
    }

    @Nullable
    private static PsiFile getExtraScriptIfNotFound(@NotNull Project project, @NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            GroovyPositionManager.$$$reportNull$$$0(10);
        }
        if (refType == null) {
            GroovyPositionManager.$$$reportNull$$$0(11);
        }
        if (runtimeName == null) {
            GroovyPositionManager.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            GroovyPositionManager.$$$reportNull$$$0(13);
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            PsiFile file;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (file = helper.getExtraScriptIfNotFound(refType, runtimeName, project, searchScope)) == null) continue;
            return file;
        }
        return null;
    }

    private static GlobalSearchScope addModuleContent(GlobalSearchScope scope) {
        Module module;
        if (scope instanceof ModuleWithDependenciesScope && !(module = ((ModuleWithDependenciesScope)scope).getModule()).isDisposed()) {
            return scope.uniteWith(module.getModuleContentWithDependenciesScope());
        }
        return scope;
    }

    private static String getOriginalQualifiedName(@NotNull ReferenceType refType, @NotNull String runtimeName) {
        if (refType == null) {
            GroovyPositionManager.$$$reportNull$$$0(14);
        }
        if (runtimeName == null) {
            GroovyPositionManager.$$$reportNull$$$0(15);
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            String originalScriptName;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (originalScriptName = helper.getOriginalScriptName(refType, runtimeName)) == null) continue;
            return originalScriptName;
        }
        return runtimeName;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(16);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        List result = (List)ReadAction.compute(() -> {
            GroovyPsiElement sourceImage;
            if (position == null) {
                GroovyPositionManager.$$$reportNull$$$0(21);
            }
            if ((sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position)) instanceof GrTypeDefinition && !((GrTypeDefinition)sourceImage).isAnonymous()) {
                String qName = GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                if (qName != null) {
                    return this.myDebugProcess.getVirtualMachineProxy().classesByName(qName);
                }
            } else if (sourceImage == null) {
                String scriptName = GroovyPositionManager.getScriptQualifiedName(position);
                if (scriptName != null) {
                    return this.myDebugProcess.getVirtualMachineProxy().classesByName(scriptName);
                }
            } else {
                String enclosingName = GroovyPositionManager.findEnclosingName(position);
                if (enclosingName == null) {
                    return null;
                }
                List outers = this.myDebugProcess.getVirtualMachineProxy().classesByName(enclosingName);
                ArrayList<ReferenceType> result1 = new ArrayList<ReferenceType>(outers.size());
                for (ReferenceType outer : outers) {
                    ReferenceType nested = this.findNested(outer, sourceImage, position);
                    if (nested == null) continue;
                    result1.add(nested);
                }
                return result1;
            }
            return null;
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses = " + result);
        }
        if (result == null) {
            throw NoDataException.INSTANCE;
        }
        List list = result;
        if (list == null) {
            GroovyPositionManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    private static String getScriptFQName(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            GroovyPositionManager.$$$reportNull$$$0(18);
        }
        String packageName = groovyFile.getPackageName();
        String fileName = GroovyPositionManager.getRuntimeScriptName(groovyFile);
        return StringUtil.getQualifiedName((String)packageName, (String)fileName);
    }

    @Nullable
    private static String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            GroovyPositionManager.$$$reportNull$$$0(19);
        }
        if (groovyFile.isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String runtimeScriptName;
                if (!helper.isAppropriateScriptFile(groovyFile) || (runtimeScriptName = helper.getRuntimeScriptName(groovyFile)) == null) continue;
                return runtimeScriptName;
            }
        }
        VirtualFile vFile = groovyFile.getVirtualFile();
        assert (vFile != null);
        return vFile.getNameWithoutExtension();
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, GroovyPsiElement toFind, SourcePosition classPosition) {
        VirtualMachineProxy vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            List nestedTypes = vmProxy.nestedTypes(fromClass);
            for (ReferenceType nested : nestedTypes) {
                ReferenceType found = this.findNested(nested, toFind, classPosition);
                if (found == null) continue;
                return found;
            }
            try {
                int lineNumber = classPosition.getLine() + 1;
                if (!fromClass.locationsOfLine(lineNumber).isEmpty()) {
                    return fromClass;
                }
                Iterator<Location> iterator = fromClass.allLineLocations().iterator();
                if (iterator.hasNext()) {
                    Location location = iterator.next();
                    SourcePosition candidateFirstPosition = SourcePosition.createFromLine((PsiFile)toFind.getContainingFile(), (int)(location.lineNumber() - 1));
                    if (toFind.equals(GroovyPositionManager.findReferenceTypeSourceImage(candidateFirstPosition))) {
                        return fromClass;
                    }
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        Set<FileType> set = ourFileTypes;
        if (set == null) {
            GroovyPositionManager.$$$reportNull$$$0(20);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 2: 
            case 17: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkGroovyFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassNameForJvm";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScriptQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileByLocation";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExtraScriptIfNotFound";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalQualifiedName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFQName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeScriptName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

