/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;

public class GroovyAnnotationAttributeInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GrAnnotationArgumentList, PsiAnnotationMethod, GrAnnotationNameValuePair> {
    private static final Set<Class> ALLOWED_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GrAnnotation.class});
    private static final Set<Class<GroovyFile>> STOP_SEARCHING_CLASSES = Collections.singleton(GroovyFile.class);

    @NotNull
    public GrAnnotationNameValuePair[] getActualParameters(@NotNull GrAnnotationArgumentList o) {
        if (o == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(0);
        }
        GrAnnotationNameValuePair[] grAnnotationNameValuePairArray = o.getAttributes();
        if (grAnnotationNameValuePairArray == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(1);
        }
        return grAnnotationNameValuePairArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = GroovyTokenTypes.mCOMMA;
        if (iElementType == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = GroovyTokenTypes.mRPAREN;
        if (iElementType == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ALLOWED_CLASSES;
        if (set == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<Class<GroovyFile>> set = STOP_SEARCHING_CLASSES;
        if (set == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Class<GrAnnotationArgumentList> getArgumentListClass() {
        if (GrAnnotationArgumentList.class == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(6);
        }
        return GrAnnotationArgumentList.class;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (item == null || context == null) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof GroovyResolveResult) {
            o = ((GroovyResolveResult)o).getElement();
        }
        if (o instanceof PsiClass && ((PsiClass)o).isAnnotationType()) {
            return GroovyAnnotationAttributeInfoHandler.extractAnnotationMethodsFromClass((PsiClass)o);
        }
        return GrAnnotationNameValuePair.EMPTY_ARRAY;
    }

    @NotNull
    private static PsiAnnotationMethod[] extractAnnotationMethodsFromClass(@NotNull PsiClass o) {
        Object[] methods;
        if (o == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(7);
        }
        if (o.isAnnotationType() && (methods = o.getMethods()).length > 0) {
            List annotationMethods = ContainerUtil.findAll((Object[])methods, PsiAnnotationMethod.class);
            PsiAnnotationMethod[] psiAnnotationMethodArray = annotationMethods.toArray(new PsiAnnotationMethod[annotationMethods.size()]);
            if (psiAnnotationMethodArray == null) {
                GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(8);
            }
            return psiAnnotationMethodArray;
        }
        if (PsiAnnotationMethod.EMPTY_ARRAY == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(9);
        }
        return PsiAnnotationMethod.EMPTY_ARRAY;
    }

    @Nullable
    public Object[] getParametersForDocumentation(PsiAnnotationMethod method, ParameterInfoContext context) {
        return new PsiAnnotationMethod[]{method};
    }

    public GrAnnotationArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(10);
        }
        return GroovyAnnotationAttributeInfoHandler.findAnchor(context.getEditor(), context.getFile());
    }

    @Nullable
    private static GrAnnotationArgumentList findAnchor(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        if (editor == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(11);
        }
        if (file == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(12);
        }
        if ((element = file.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return null;
        }
        return (GrAnnotationArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, GrAnnotationArgumentList.class);
    }

    public void showParameterInfo(@NotNull GrAnnotationArgumentList argumentList, @NotNull CreateParameterInfoContext context) {
        GrAnnotation parent;
        PsiElement resolved;
        if (argumentList == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(14);
        }
        if ((resolved = (parent = (GrAnnotation)argumentList.getParent()).getClassReference().resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            Object[] methods = GroovyAnnotationAttributeInfoHandler.extractAnnotationMethodsFromClass((PsiClass)resolved);
            context.setItemsToShow(methods);
            context.showHint((PsiElement)argumentList, argumentList.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
            PsiAnnotationMethod currentMethod = GroovyAnnotationAttributeInfoHandler.findAnnotationMethod(context.getFile(), context.getEditor());
            if (currentMethod != null) {
                context.setHighlightedElement((PsiElement)currentMethod);
            }
        }
    }

    @Nullable
    private static PsiAnnotationMethod findAnnotationMethod(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiNameValuePair pair;
        if (file == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(16);
        }
        if ((pair = (PsiNameValuePair)ParameterInfoUtils.findParentOfType((PsiFile)file, (int)GroovyAnnotationAttributeInfoHandler.inferOffset(editor), PsiNameValuePair.class)) == null) {
            return null;
        }
        PsiReference reference = pair.getReference();
        PsiElement resolved = reference != null ? reference.resolve() : null;
        return PsiUtil.isAnnotationMethod((PsiElement)resolved) ? (PsiAnnotationMethod)resolved : null;
    }

    public GrAnnotationArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(17);
        }
        return GroovyAnnotationAttributeInfoHandler.findAnchor(context.getEditor(), context.getFile());
    }

    public void updateParameterInfo(@NotNull GrAnnotationArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(18);
        }
        if (context == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(19);
        }
        context.setHighlightedParameter((Object)GroovyAnnotationAttributeInfoHandler.findAnnotationMethod(context.getFile(), context.getEditor()));
    }

    private static int inferOffset(@NotNull Editor editor) {
        int offset1;
        CharSequence chars;
        char character;
        if (editor == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(20);
        }
        if ((character = (chars = editor.getDocument().getCharsSequence()).charAt(offset1 = CharArrayUtil.shiftForward((CharSequence)chars, (int)editor.getCaretModel().getOffset(), (String)" \t"))) == ',' || character == ')') {
            offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset1 - 1), (String)" \t");
        }
        return offset1;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(@NotNull PsiAnnotationMethod p, @NotNull ParameterInfoUIContext context) {
        if (p == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(21);
        }
        if (context == null) {
            GroovyAnnotationAttributeInfoHandler.$$$reportNull$$$0(22);
        }
        StringBuilder buffer = new StringBuilder();
        PsiType returnType = p.getReturnType();
        assert (returnType != null);
        buffer.append(returnType.getPresentableText());
        buffer.append(" ");
        int highlightStartOffset = buffer.length();
        buffer.append(p.getName());
        int highlightEndOffset = buffer.length();
        buffer.append("()");
        PsiAnnotationMemberValue defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            buffer.append(" default ");
            buffer.append(defaultValue.getText());
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, p.isDeprecated(), false, context.getDefaultParameterColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyAnnotationAttributeInfoHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "extractAnnotationMethodsFromClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractAnnotationMethodsFromClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationMethod";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inferOffset";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

