/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GrAnnotationUtil {
    @Nullable
    public static String inferStringAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        if (annotation == null) {
            GrAnnotationUtil.$$$reportNull$$$0(0);
        }
        if (attributeName == null) {
            GrAnnotationUtil.$$$reportNull$$$0(1);
        }
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        return GrAnnotationUtil.getString(targetValue);
    }

    @Nullable
    public static String getString(@Nullable PsiAnnotationMemberValue targetValue) {
        Object value;
        if (targetValue instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    public static Integer inferIntegerAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        Object value;
        PsiAnnotationMemberValue targetValue;
        if (annotation == null) {
            GrAnnotationUtil.$$$reportNull$$$0(2);
        }
        if (attributeName == null) {
            GrAnnotationUtil.$$$reportNull$$$0(3);
        }
        if ((targetValue = annotation.findAttributeValue(attributeName)) instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    @Nullable
    public static Boolean inferBooleanAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        Object value;
        PsiAnnotationMemberValue targetValue;
        if (annotation == null) {
            GrAnnotationUtil.$$$reportNull$$$0(4);
        }
        if (attributeName == null) {
            GrAnnotationUtil.$$$reportNull$$$0(5);
        }
        if ((targetValue = annotation.findAttributeValue(attributeName)) instanceof PsiLiteral && (value = ((PsiLiteral)targetValue).getValue()) instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public static boolean inferBooleanAttributeNotNull(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        Boolean result;
        if (annotation == null) {
            GrAnnotationUtil.$$$reportNull$$$0(6);
        }
        if (attributeName == null) {
            GrAnnotationUtil.$$$reportNull$$$0(7);
        }
        return (result = GrAnnotationUtil.inferBooleanAttribute(annotation, attributeName)) != null && result != false;
    }

    @Nullable
    public static PsiClass inferClassAttribute(@NotNull PsiAnnotation annotation, @NotNull String attributeName) {
        if (annotation == null) {
            GrAnnotationUtil.$$$reportNull$$$0(8);
        }
        if (attributeName == null) {
            GrAnnotationUtil.$$$reportNull$$$0(9);
        }
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        return GrAnnotationUtil.getPsiClass(targetValue);
    }

    @Nullable
    private static PsiClass getPsiClass(@Nullable PsiAnnotationMemberValue targetValue) {
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            PsiType type = ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
            if (type instanceof PsiClassType) {
                return ((PsiClassType)type).resolve();
            }
        } else if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return (PsiClass)resolved;
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return (PsiClass)resolved2;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType extractClassTypeFromClassAttributeValue(PsiAnnotationMemberValue targetValue) {
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            return ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
        }
        if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return qualifier.getType();
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return ((GrReferenceExpression)targetValue).getType();
            }
        }
        return null;
    }

    public static PsiElement getActualOwner(GrAnnotation annotation) {
        PsiAnnotationOwner owner = annotation.getOwner();
        if (owner instanceof PsiModifierList) {
            return ((PsiModifierList)owner).getParent();
        }
        return (PsiElement)owner;
    }

    public static List<PsiClass> getClassArrayValue(@NotNull PsiAnnotation annotation, @NotNull String attributeName, boolean declared) {
        PsiClass psiClass;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            GrAnnotationUtil.$$$reportNull$$$0(10);
        }
        if (attributeName == null) {
            GrAnnotationUtil.$$$reportNull$$$0(11);
        }
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = declared ? annotation.findDeclaredAttributeValue(attributeName) : annotation.findAttributeValue(attributeName);
        if (value instanceof PsiArrayInitializerMemberValue) {
            return ContainerUtil.mapNotNull((Object[])((PsiArrayInitializerMemberValue)value).getInitializers(), GrAnnotationUtil::getPsiClass);
        }
        if (value instanceof PsiReference && (psiClass = GrAnnotationUtil.getPsiClass(value)) != null) {
            return Collections.singletonList(psiClass);
        }
        return Collections.emptyList();
    }

    public static List<String> getStringArrayValue(@NotNull PsiAnnotation annotation, @NotNull String attributeName, boolean declared) {
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            GrAnnotationUtil.$$$reportNull$$$0(12);
        }
        if (attributeName == null) {
            GrAnnotationUtil.$$$reportNull$$$0(13);
        }
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = declared ? annotation.findDeclaredAttributeValue(attributeName) : annotation.findAttributeValue(attributeName);
        if (value instanceof PsiArrayInitializerMemberValue) {
            return ContainerUtil.mapNotNull((Object[])((PsiArrayInitializerMemberValue)value).getInitializers(), memberValue -> {
                String string = GrAnnotationUtil.getString(memberValue);
                return StringUtil.isEmpty((String)string) ? null : string;
            });
        }
        String string = GrAnnotationUtil.getString(value);
        if (!StringUtil.isEmpty((String)string)) {
            return Collections.singletonList(string);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnnotationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inferStringAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inferIntegerAttribute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inferBooleanAttribute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "inferBooleanAttributeNotNull";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "inferClassAttribute";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassArrayValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringArrayValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

