/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;

public class GrCodeReferenceElementImpl
extends GrReferenceElementImpl<GrCodeReferenceElement>
implements GrCodeReferenceElement {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.types.GrCodeReferenceElementImpl");
    private static final OurResolver RESOLVER = new OurResolver();

    public GrCodeReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (StringUtil.isJavaIdentifier((String)newElementName)) {
            return super.handleElementRename(newElementName);
        }
        throw new IncorrectOperationException("Cannot rename reference to '" + newElementName + "'");
    }

    protected GrCodeReferenceElement bindWithQualifiedRef(@NotNull String qName) {
        if (qName == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(1);
        }
        GrCodeReferenceElement qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeOrPackageReference(qName);
        GrTypeArgumentList list = this.getTypeArgumentList();
        if (list != null) {
            qualifiedRef.getNode().addChild(list.copy().getNode());
        }
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        return qualifiedRef;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitCodeReferenceElement(this);
    }

    public String toString() {
        return "Reference element";
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByType(TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS);
    }

    public ReferenceKind getKind(boolean forCompletion) {
        if (this.isClassReferenceForNew()) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrCodeReferenceElementImpl) {
            ReferenceKind parentKind = ((GrCodeReferenceElementImpl)parent).getKind(forCompletion);
            if (parentKind == ReferenceKind.CLASS) {
                return ReferenceKind.CLASS_OR_PACKAGE;
            }
            if (parentKind == ReferenceKind.STATIC_MEMBER_FQ) {
                return this.isQualified() ? ReferenceKind.CLASS_FQ : ReferenceKind.CLASS;
            }
            if (parentKind == ReferenceKind.CLASS_FQ) {
                return ReferenceKind.CLASS_OR_PACKAGE_FQ;
            }
            return parentKind;
        }
        if (parent instanceof GrPackageDefinition) {
            return ReferenceKind.PACKAGE_FQ;
        }
        if (parent instanceof GrDocReferenceElement) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        if (parent instanceof GrImportStatement) {
            GrImportStatement importStatement = (GrImportStatement)parent;
            if (importStatement.isStatic()) {
                return importStatement.isOnDemand() ? ReferenceKind.CLASS : ReferenceKind.STATIC_MEMBER_FQ;
            }
            return forCompletion || importStatement.isOnDemand() ? ReferenceKind.CLASS_OR_PACKAGE_FQ : ReferenceKind.CLASS_FQ;
        }
        if (parent instanceof GrNewExpression || parent instanceof GrAnonymousClassDefinition) {
            PsiElement newExpr;
            PsiElement psiElement = newExpr = parent instanceof GrAnonymousClassDefinition ? parent.getParent() : parent;
            assert (newExpr instanceof GrNewExpression);
        }
        return ReferenceKind.CLASS;
    }

    @NotNull
    public String getCanonicalText() {
        ReferenceKind kind = this.getKind(false);
        switch (kind) {
            case CLASS: 
            case CLASS_OR_PACKAGE: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiType[] types;
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    if ((types = this.getTypeArguments()).length == 0) {
                        String string = name;
                        if (string == null) {
                            GrCodeReferenceElementImpl.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append('<');
                    for (int i = 0; i < types.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(types[i].getCanonicalText());
                    }
                    buf.append('>');
                    String string = buf.toString();
                    if (string == null) {
                        GrCodeReferenceElementImpl.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                if (target instanceof PsiPackage) {
                    String string = ((PsiPackage)target).getQualifiedName();
                    if (string == null) {
                        GrCodeReferenceElementImpl.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                LOG.assertTrue(target == null);
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    GrCodeReferenceElementImpl.$$$reportNull$$$0(5);
                }
                return string;
            }
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: 
            case PACKAGE_FQ: 
            case STATIC_MEMBER_FQ: {
                String string = this.getTextSkipWhiteSpaceAndComments();
                if (string == null) {
                    GrCodeReferenceElementImpl.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        LOG.assertTrue(false);
        if (null == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Override
    protected boolean bindsCorrectly(PsiElement element) {
        PsiMethod method;
        PsiElement resolved;
        if (super.bindsCorrectly(element)) {
            return true;
        }
        return element instanceof PsiClass && (resolved = this.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).isConstructor() && this.getManager().areElementsEquivalent(element, (PsiElement)method.getContainingClass());
    }

    @Override
    public boolean isFullyQualified() {
        switch (this.getKind(false)) {
            case CLASS_OR_PACKAGE: 
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: 
            case PACKAGE_FQ: 
            case STATIC_MEMBER_FQ: {
                if (!(this.resolve() instanceof PsiPackage)) break;
                return true;
            }
        }
        GrCodeReferenceElement qualifier = this.getQualifier();
        return qualifier != null && ((GrCodeReferenceElementImpl)qualifier).isFullyQualified();
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiManagerEx manager = this.getManager();
        if (element instanceof PsiNamedElement && this.getParent() instanceof GrImportStatement) {
            GroovyResolveResult[] results2;
            for (GroovyResolveResult result : results2 = this.multiResolve(false)) {
                if (!manager.areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
        }
        return manager.areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(8);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private boolean isClassReferenceForNew() {
        PsiElement parent = this.getParent();
        while (parent instanceof GrCodeReferenceElement) {
            parent = parent.getParent();
        }
        return parent instanceof GrNewExpression;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray = TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
        if (groovyResolveResultArray == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(9);
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        GrTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList != null && typeArgumentList.isDiamond()) {
            PsiType[] psiTypeArray = this.inferDiamondTypeArguments();
            if (psiTypeArray == null) {
                GrCodeReferenceElementImpl.$$$reportNull$$$0(10);
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = super.getTypeArguments();
        if (psiTypeArray == null) {
            GrCodeReferenceElementImpl.$$$reportNull$$$0(11);
        }
        return psiTypeArray;
    }

    private PsiType[] inferDiamondTypeArguments() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof GrNewExpression)) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType lType = PsiImplUtil.inferExpectedTypeForDiamond((GrNewExpression)parent);
        if (lType instanceof PsiClassType) {
            return ((PsiClassType)lType).getParameters();
        }
        return PsiType.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindWithQualifiedRef";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OurResolver
    implements ResolveCache.PolyVariantResolver<GrCodeReferenceElementImpl> {
        private OurResolver() {
        }

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrCodeReferenceElementImpl reference, boolean incompleteCode) {
            if (reference == null) {
                OurResolver.$$$reportNull$$$0(0);
            }
            if (reference.getReferenceName() == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    OurResolver.$$$reportNull$$$0(1);
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GroovyResolveResult[] results2 = OurResolver._resolve(reference, (PsiManager)reference.getManager(), reference.getKind(false));
            if (results2.length == 0) {
                if (results2 == null) {
                    OurResolver.$$$reportNull$$$0(2);
                }
                return results2;
            }
            ArrayList<GroovyResolveResultImpl> imported = new ArrayList<GroovyResolveResultImpl>();
            PsiType[] args = reference.getTypeArguments();
            for (int i = 0; i < results2.length; ++i) {
                GroovyResolveResult result = results2[i];
                PsiElement element = result.getElement();
                if (!(element instanceof PsiClass)) continue;
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiSubstitutor newSubstitutor = substitutor.putAll((PsiClass)element, args);
                PsiElement context = result.getCurrentFileResolveContext();
                GroovyResolveResultImpl newResult = new GroovyResolveResultImpl(element, context, null, newSubstitutor, result.isAccessible(), result.isStaticsOK());
                results2[i] = newResult;
                if (!(context instanceof GrImportStatement)) continue;
                imported.add(newResult);
            }
            if (!imported.isEmpty()) {
                GroovyResolveResult[] groovyResolveResultArray = imported.toArray(new GroovyResolveResult[imported.size()]);
                if (groovyResolveResultArray == null) {
                    OurResolver.$$$reportNull$$$0(3);
                }
                return groovyResolveResultArray;
            }
            if (results2 == null) {
                OurResolver.$$$reportNull$$$0(4);
            }
            return results2;
        }

        @NotNull
        private static GroovyResolveResult[] _resolve(@NotNull GrCodeReferenceElementImpl ref, @NotNull PsiManager manager, @NotNull ReferenceKind kind) {
            String refName;
            if (ref == null) {
                OurResolver.$$$reportNull$$$0(5);
            }
            if (manager == null) {
                OurResolver.$$$reportNull$$$0(6);
            }
            if (kind == null) {
                OurResolver.$$$reportNull$$$0(7);
            }
            if ((refName = ref.getReferenceName()) == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    OurResolver.$$$reportNull$$$0(8);
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            switch (kind) {
                case CLASS_FQ: 
                case CLASS_OR_PACKAGE_FQ: 
                case PACKAGE_FQ: {
                    String qName = PsiUtil.getQualifiedReferenceText(ref);
                    LOG.assertTrue(qName != null, (Object)ref.getText());
                    PsiElement element = OurResolver.resolveClassOrPackagePreferInner(ref, kind, qName, JavaPsiFacade.getInstance((Project)manager.getProject()));
                    if (element == null) break;
                    boolean accessible = !(element instanceof PsiClass) || PsiUtil.isAccessible(ref, (PsiMember)((PsiClass)element));
                    GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{new GroovyResolveResultImpl(element, accessible)};
                    if (groovyResolveResultArray == null) {
                        OurResolver.$$$reportNull$$$0(9);
                    }
                    return groovyResolveResultArray;
                }
                case CLASS: {
                    GrCodeReferenceElementImpl placeToStartWalking;
                    ClassResolverProcessor processor = new ClassResolverProcessor(refName, ref);
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier != null) {
                        PsiElement qualifierResolved = qualifier.resolve();
                        if (!(qualifierResolved instanceof PsiPackage) && !(qualifierResolved instanceof PsiClass)) break;
                        qualifierResolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)ref);
                        GroovyResolveResult[] groovyResolveResultArray = processor.getCandidates();
                        if (groovyResolveResultArray == null) {
                            OurResolver.$$$reportNull$$$0(10);
                        }
                        return groovyResolveResultArray;
                    }
                    GrCodeReferenceElementImpl grCodeReferenceElementImpl = placeToStartWalking = OurResolver.isAnnotationRef(ref) ? OurResolver.getContainingFileSkippingStubFiles(ref) : ref;
                    if (placeToStartWalking == null) break;
                    PsiTreeUtilKt.treeWalkUp(placeToStartWalking, processor, ResolveState.initial(), ref);
                    GroovyResolveResult[] candidates = processor.getCandidates();
                    if (candidates.length <= 0) break;
                    if (candidates == null) {
                        OurResolver.$$$reportNull$$$0(11);
                    }
                    return candidates;
                }
                case CLASS_OR_PACKAGE: {
                    GroovyResolveResult[] classResult = OurResolver._resolve(ref, manager, ReferenceKind.CLASS);
                    if (classResult.length == 1 && !classResult[0].isAccessible()) {
                        GroovyResolveResult[] packageResult = OurResolver._resolve(ref, manager, ReferenceKind.PACKAGE_FQ);
                        if (packageResult.length != 0) {
                            if (packageResult == null) {
                                OurResolver.$$$reportNull$$$0(12);
                            }
                            return packageResult;
                        }
                    } else if (classResult.length == 0) {
                        GroovyResolveResult[] groovyResolveResultArray = OurResolver._resolve(ref, manager, ReferenceKind.PACKAGE_FQ);
                        if (groovyResolveResultArray == null) {
                            OurResolver.$$$reportNull$$$0(13);
                        }
                        return groovyResolveResultArray;
                    }
                    if (classResult == null) {
                        OurResolver.$$$reportNull$$$0(14);
                    }
                    return classResult;
                }
                case STATIC_MEMBER_FQ: {
                    PsiElement resolved;
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier == null || !((resolved = qualifier.resolve()) instanceof PsiClass)) break;
                    PsiClass clazz = (PsiClass)resolved;
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)clazz.getProject()).getResolveHelper();
                    List<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>();
                    OurResolver.processFields(ref, refName, clazz, helper, result);
                    OurResolver.processMethods(ref, refName, clazz, helper, result);
                    OurResolver.processInnerClasses(ref, refName, clazz, helper, result);
                    OurResolver.processAccessors(ref, refName, clazz, helper, result);
                    result = ResolveUtil.collapseReflectedMethods(result);
                    List valid = ContainerUtil.filter(result, ResolveResult::isValidResult);
                    GroovyResolveResult[] groovyResolveResultArray = (valid.isEmpty() ? result : valid).toArray(GroovyResolveResult.EMPTY_ARRAY);
                    if (groovyResolveResultArray == null) {
                        OurResolver.$$$reportNull$$$0(15);
                    }
                    return groovyResolveResultArray;
                }
            }
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                OurResolver.$$$reportNull$$$0(16);
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }

        @Nullable
        private static PsiElement resolveClassOrPackagePreferInner(@NotNull GrCodeReferenceElementImpl ref, @NotNull ReferenceKind kind, String qName, JavaPsiFacade facade) {
            if (ref == null) {
                OurResolver.$$$reportNull$$$0(17);
            }
            if (kind == null) {
                OurResolver.$$$reportNull$$$0(18);
            }
            if (kind == ReferenceKind.CLASS_OR_PACKAGE_FQ || kind == ReferenceKind.CLASS_FQ) {
                boolean qualified;
                PsiFile file = ref.getContainingFile();
                boolean bl = qualified = qName.indexOf(46) > 0;
                if (qualified || file instanceof GroovyFile && ((GroovyFile)file).getPackageName().isEmpty()) {
                    PsiClass aClass;
                    PsiElement container = qualified ? OurResolver.resolveClassOrPackagePreferInner(ref, kind, StringUtil.getPackageName((String)qName), facade) : null;
                    PsiClass psiClass = aClass = container instanceof PsiClass && PsiUtil.isAccessible(ref, (PsiMember)((PsiClass)container)) ? ((PsiClass)container).findInnerClassByName(StringUtil.getShortName((String)qName), true) : null;
                    if (aClass == null) {
                        aClass = facade.findClass(qName, ref.getResolveScope());
                    }
                    if (aClass != null) {
                        return aClass;
                    }
                }
            }
            if (kind == ReferenceKind.CLASS_OR_PACKAGE_FQ || kind == ReferenceKind.PACKAGE_FQ) {
                return facade.findPackage(qName);
            }
            return null;
        }

        private static PsiFile getContainingFileSkippingStubFiles(GrCodeReferenceElementImpl ref) {
            PsiFile file = ref.getContainingFile();
            while (file != null && !file.isPhysical() && file.getContext() != null) {
                PsiElement context = file.getContext();
                file = context.getContainingFile();
            }
            return file;
        }

        private static boolean isAnnotationRef(GrCodeReferenceElement ref) {
            PsiElement parent = ref.getParent();
            return parent instanceof GrAnnotation || parent instanceof GrCodeReferenceElement && OurResolver.isAnnotationRef((GrCodeReferenceElement)parent);
        }

        private static void processAccessors(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            ArrayList<GroovyResolveResult> propertyResults = new ArrayList<GroovyResolveResult>();
            String booleanGetter = GroovyPropertyUtils.getGetterNameBoolean(refName);
            String nonBooleanGetter = GroovyPropertyUtils.getGetterNameNonBoolean(refName);
            String setter = GroovyPropertyUtils.getSetterName(refName);
            OurResolver.processMethods(ref, booleanGetter, clazz, helper, propertyResults);
            OurResolver.processMethods(ref, nonBooleanGetter, clazz, helper, propertyResults);
            OurResolver.processMethods(ref, setter, clazz, helper, propertyResults);
            result.addAll(ResolveUtil.collapseProperties(propertyResults));
        }

        private static void processInnerClasses(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiClass innerClass = clazz.findInnerClassByName(refName, true);
            if (innerClass != null && innerClass.hasModifierProperty("static")) {
                result.add(new GroovyResolveResultImpl((PsiElement)innerClass, helper.isAccessible((PsiMember)innerClass, (PsiElement)ref, null)));
            }
        }

        private static void processFields(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiField field = clazz.findFieldByName(refName, true);
            if (field != null && field.hasModifierProperty("static")) {
                result.add(new GroovyResolveResultImpl((PsiElement)field, helper.isAccessible((PsiMember)field, (PsiElement)ref, null)));
            }
        }

        private static void processMethods(GrCodeReferenceElementImpl ref, String refName, PsiClass clazz, PsiResolveHelper helper, List<GroovyResolveResult> result) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = clazz.findMethodsByName(refName, true)) {
                if (!method.hasModifierProperty("static")) continue;
                result.add(new GroovyResolveResultImpl((PsiElement)method, helper.isAccessible((PsiMember)method, (PsiElement)ref, null)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver";
                    break;
                }
                case 5: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 7: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl$OurResolver";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "_resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "_resolve";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveClassOrPackagePreferInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ReferenceKind {
        CLASS,
        CLASS_OR_PACKAGE,
        PACKAGE_FQ,
        CLASS_FQ,
        CLASS_OR_PACKAGE_FQ,
        STATIC_MEMBER_FQ;

    }
}

