/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public abstract class GroovyResolverProcessor
implements PsiScopeProcessor,
ElementClassHint,
NameHint,
DynamicMembersHint {
    @NotNull
    protected final GrReferenceExpression myRef;
    @NotNull
    private final String myName;
    @NotNull
    protected final EnumSet<GroovyResolveKind> myAcceptableKinds;
    private final boolean myIsLValue;
    @Nullable
    protected final PsiType myThisType;
    @NotNull
    protected final PsiType[] myTypeArguments;
    @NotNull
    private final NullableLazyValue<PsiType[]> myArgumentTypesNonErased;
    @NotNull
    protected final NullableLazyValue<PsiType[]> myArgumentTypes;
    private final NotNullLazyValue<SubstitutorComputer> myPropertySubstitutorComputer;
    private final NotNullLazyValue<SubstitutorComputer> myMethodSubstitutorComputer;
    private final List<PsiScopeProcessor> myAccessorProcessors;
    protected final MultiMap<GroovyResolveKind, GroovyResolveResult> myCandidates;
    protected final MultiMap<GroovyResolveKind, GroovyResolveResult> myInapplicableCandidates;
    private boolean myStopExecutingMethods;

    GroovyResolverProcessor(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, @Nullable GrExpression myUpToArgument, boolean forceRValue) {
        if (ref == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(0);
        }
        if (kinds == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(1);
        }
        this.myPropertySubstitutorComputer = new NotNullLazyValue<SubstitutorComputer>(){

            @NotNull
            protected SubstitutorComputer compute() {
                SubstitutorComputer substitutorComputer = new SubstitutorComputer(GroovyResolverProcessor.this.myThisType, PsiType.EMPTY_ARRAY, GroovyResolverProcessor.this.myTypeArguments, GroovyResolverProcessor.this.myRef, GroovyResolverProcessor.this.myRef);
                if (substitutorComputer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return substitutorComputer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor$1", "compute"));
            }
        };
        this.myMethodSubstitutorComputer = new NotNullLazyValue<SubstitutorComputer>(){

            @NotNull
            protected SubstitutorComputer compute() {
                SubstitutorComputer substitutorComputer = new SubstitutorComputer(GroovyResolverProcessor.this.myThisType, (PsiType[])GroovyResolverProcessor.this.myArgumentTypesNonErased.getValue(), GroovyResolverProcessor.this.myTypeArguments, GroovyResolverProcessor.this.myRef, GroovyResolverProcessor.this.myRef.getParent());
                if (substitutorComputer == null) {
                    2.$$$reportNull$$$0(0);
                }
                return substitutorComputer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor$2", "compute"));
            }
        };
        this.myCandidates = MultiMap.create();
        this.myInapplicableCandidates = MultiMap.create();
        this.myStopExecutingMethods = false;
        this.myRef = ref;
        this.myAcceptableKinds = kinds;
        this.myName = GroovyResolverProcessor.getReferenceName(ref);
        this.myIsLValue = !forceRValue && PsiUtil.isLValue(this.myRef);
        this.myThisType = PsiImplUtil.getQualifierType(ref);
        this.myTypeArguments = ref.getTypeArguments();
        if (kinds.contains((Object)GroovyResolveKind.METHOD) || this.myIsLValue) {
            this.myArgumentTypesNonErased = NullableLazyValue.createValue(() -> {
                if (ref == null) {
                    GroovyResolverProcessor.$$$reportNull$$$0(15);
                }
                return PsiUtil.getArgumentTypes(ref, false, myUpToArgument);
            });
            this.myArgumentTypes = NullableLazyValue.createValue(() -> GroovyResolverProcessor.eraseTypes((PsiType[])this.myArgumentTypesNonErased.getValue()));
        } else {
            this.myArgumentTypes = this.myArgumentTypesNonErased = NullableLazyValue.createValue(() -> null);
        }
        this.myAccessorProcessors = this.calcAccessorProcessors();
    }

    private List<PsiScopeProcessor> calcAccessorProcessors() {
        if (this.isPropertyResolve()) {
            if (this.myIsLValue) {
                return Collections.singletonList(this.accessorProcessor(GroovyPropertyUtils.getSetterName(this.myName)));
            }
            return ContainerUtil.newArrayList((Object[])new PsiScopeProcessor[]{this.accessorProcessor(GroovyPropertyUtils.getGetterNameNonBoolean(this.myName)), this.accessorProcessor(GroovyPropertyUtils.getGetterNameBoolean(this.myName))});
        }
        return Collections.emptyList();
    }

    private GrScopeProcessorWithHints accessorProcessor(@NotNull String name) {
        if (name == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(2);
        }
        return new GrScopeProcessorWithHints(name, GroovyResolveKind.METHOD.declarationKinds){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                return !AccessorResolverProcessor.checkAccessor(element, state, GroovyResolverProcessor.this.myName, !GroovyResolverProcessor.this.myIsLValue) || GroovyResolverProcessor.this.execute(element, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean isPropertyResolve() {
        return this.myAcceptableKinds.contains((Object)GroovyResolveKind.PROPERTY);
    }

    public static List<PsiScopeProcessor> allProcessors(PsiScopeProcessor processor) {
        List<PsiScopeProcessor> accessors;
        if (processor instanceof GroovyResolverProcessor && !((GroovyResolverProcessor)processor).myStopExecutingMethods && !(accessors = ((GroovyResolverProcessor)processor).myAccessorProcessors).isEmpty()) {
            return ContainerUtil.concat(Collections.singletonList(processor), accessors);
        }
        return Collections.singletonList(processor);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        GroovyResolveResultImpl candidate;
        if (element == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(3);
        }
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
        GroovyResolveKind kind = this.computeKindAndCheckName(namedElement, resolveContext);
        if (!this.myAcceptableKinds.contains((Object)kind)) {
            return true;
        }
        if (kind == GroovyResolveKind.METHOD && this.myStopExecutingMethods) {
            return true;
        }
        if (kind != GroovyResolveKind.PROPERTY && kind != GroovyResolveKind.METHOD && !this.myCandidates.get((Object)kind).isEmpty()) {
            return true;
        }
        PsiSubstitutor substitutor = GroovyResolverProcessor.getSubstitutor(state);
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        boolean isAccessible = ResolveUtil.isAccessible(this.myRef, namedElement);
        boolean isStaticsOK = ResolveUtil.isStaticsOK(this.myRef, namedElement, resolveContext, false);
        if (kind == GroovyResolveKind.METHOD || kind == GroovyResolveKind.PROPERTY) {
            PsiMethod method = (PsiMethod)namedElement;
            boolean isApplicable = kind == GroovyResolveKind.PROPERTY && !this.myIsLValue || PsiUtil.isApplicable((PsiType[])this.myArgumentTypes.getValue(), method, substitutor, this.myRef, true);
            NotNullComputable substitutorComputer = kind == GroovyResolveKind.METHOD ? () -> ((SubstitutorComputer)this.myMethodSubstitutorComputer.getValue()).obtainSubstitutor(substitutor, method, resolveContext) : () -> ((SubstitutorComputer)this.myPropertySubstitutorComputer.getValue()).obtainSubstitutor(substitutor, method, resolveContext);
            candidate = new GroovyMethodResultImpl(method, resolveContext, spreadState, substitutor, (NotNullComputable<PsiSubstitutor>)substitutorComputer, kind == GroovyResolveKind.PROPERTY, isAccessible, isStaticsOK, isApplicable);
        } else {
            candidate = new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK, false, true);
        }
        (candidate.isValidResult() ? this.myCandidates : this.myInapplicableCandidates).putValue((Object)kind, (Object)candidate);
        if (candidate.isValidResult() && kind == GroovyResolveKind.VARIABLE) {
            this.myStopExecutingMethods = true;
        }
        return true;
    }

    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(5);
        }
        if (hintKey == ElementClassHint.KEY || hintKey == NameHint.KEY || hintKey == DynamicMembersHint.KEY) {
            return (T)this;
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        if (event == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(6);
        }
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && !this.myCandidates.get((Object)GroovyResolveKind.METHOD).isEmpty()) {
            this.myStopExecutingMethods = true;
        }
    }

    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        if (kind == ElementClassHint.DeclarationKind.METHOD) {
            if (this.myStopExecutingMethods) {
                return false;
            }
            if (this.isPropertyResolve() && !this.myAcceptableKinds.contains((Object)GroovyResolveKind.METHOD)) {
                return false;
            }
        }
        for (GroovyResolveKind resolveKind : this.myAcceptableKinds) {
            if (!resolveKind.declarationKinds.contains(kind)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(7);
        }
        String string = this.myName;
        if (string == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean shouldProcessMethods() {
        return this.myRef.getParent() instanceof GrCallExpression && !this.myCandidates.containsKey((Object)GroovyResolveKind.METHOD);
    }

    @Override
    public boolean shouldProcessProperties() {
        return true;
    }

    @NotNull
    public abstract List<GroovyResolveResult> getCandidates();

    public final GroovyResolveResult[] getCandidatesArray() {
        List<GroovyResolveResult> candidates = this.getCandidates();
        int size = candidates.size();
        if (size == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (size == 1) {
            return new GroovyResolveResult[]{candidates.get(0)};
        }
        return candidates.toArray(new GroovyResolveResult[size]);
    }

    private GroovyResolveKind computeKindAndCheckName(PsiNamedElement element, PsiElement resolveContext) {
        String importedName;
        String string = importedName = resolveContext instanceof GrImportStatement ? ((GrImportStatement)resolveContext).getImportedName() : null;
        if (element instanceof PsiMethod) {
            if (importedName == null) {
                if (this.myIsLValue ? GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, this.myName) : GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, this.myName)) {
                    return GroovyResolveKind.PROPERTY;
                }
            } else {
                if (this.myIsLValue ? GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForSetter(importedName, this.myName) || this.myName.equals(importedName)) : GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForGetter((PsiMethod)element, importedName, this.myName) || this.myName.equals(importedName))) {
                    return GroovyResolveKind.PROPERTY;
                }
                if (importedName.equals(GroovyPropertyUtils.getPropertyNameByGetterName(this.myName, true)) || importedName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(this.myName))) {
                    return GroovyResolveKind.METHOD;
                }
            }
        }
        if (importedName == null) {
            if (element instanceof PsiClass) {
                return GroovyResolveKind.CLASS;
            }
            if (element instanceof PsiPackage) {
                return GroovyResolveKind.PACKAGE;
            }
            if (element instanceof PsiMethod) {
                return GroovyResolveKind.METHOD;
            }
            if (element instanceof PsiEnumConstant) {
                return GroovyResolveKind.ENUM_CONST;
            }
            if (element instanceof PsiField) {
                return GroovyResolveKind.FIELD;
            }
            if (element instanceof GrBindingVariable) {
                return GroovyResolveKind.BINDING;
            }
            if (element instanceof PsiVariable) {
                return GroovyResolveKind.VARIABLE;
            }
        } else if (this.myName.equals(importedName)) {
            if (element instanceof PsiClass) {
                return GroovyResolveKind.CLASS;
            }
            if (element instanceof PsiMethod) {
                return GroovyResolveKind.METHOD;
            }
            if (element instanceof PsiEnumConstant) {
                return GroovyResolveKind.ENUM_CONST;
            }
            if (element instanceof PsiField) {
                return GroovyResolveKind.FIELD;
            }
        }
        return null;
    }

    @NotNull
    protected List<GroovyResolveResult> getCandidates(GroovyResolveKind ... kinds) {
        if (kinds == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(9);
        }
        List results2 = ContainerUtil.newSmartList();
        for (GroovyResolveKind kind : kinds) {
            results2.addAll(this.myCandidates.get((Object)kind));
        }
        List list = results2;
        if (list == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    protected static PsiSubstitutor getSubstitutor(@NotNull ResolveState state) {
        PsiSubstitutor substitutor;
        if (state == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(11);
        }
        if ((substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY)) == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(12);
        }
        return psiSubstitutor;
    }

    @NotNull
    private static String getReferenceName(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(13);
        }
        String name = ref.getReferenceName();
        assert (name != null) : "Reference name cannot be null";
        String string = name;
        if (string == null) {
            GroovyResolverProcessor.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static PsiType[] eraseTypes(@Nullable PsiType[] types) {
        PsiType[] erasedTypes;
        PsiType[] psiTypeArray = erasedTypes = types == null ? null : Arrays.copyOf(types, types.length);
        if (erasedTypes != null) {
            for (int i = 0; i < types.length; ++i) {
                erasedTypes[i] = TypeConversionUtil.erasure((PsiType)erasedTypes[i]);
            }
        }
        return erasedTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accessorProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

