/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

final class FinderDelegate {
    FinderDelegate() {
    }

    @Nonnull
    @RunsInEDT
    Collection<Component> find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m) {
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)component), found);
        }
        return found;
    }

    @RunsInEDT
    private void find(@Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher m, @Nonnull Component root, @Nonnull Set<Component> found) {
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)c), found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(root);
        }
    }

    @Nonnull
    @RunsInEDT
    private static Collection<Component> childrenOfComponent(final @Nonnull Component c, final @Nonnull ComponentHierarchy h) {
        Collection<Component> children = GuiActionRunner.execute(new GuiQuery<Collection<Component>>(){

            @Override
            protected Collection<Component> executeInEDT() {
                return h.childrenOf(c);
            }
        });
        return (Collection)Preconditions.checkNotNull(children);
    }

    @RunsInEDT
    private static boolean isMatching(final @Nonnull Component c, final @Nonnull ComponentMatcher m) {
        Boolean matching = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return m.matches(c);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)matching);
    }

    @Nonnull
    @RunsInEDT
    <T extends Component> Collection<T> find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m) {
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Component component : FinderDelegate.rootsOf(h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)component), found);
        }
        return found;
    }

    @Nonnull
    @RunsInEDT
    private static Collection<? extends Component> rootsOf(final @Nonnull ComponentHierarchy h) {
        Collection<? extends Component> roots = GuiActionRunner.execute(new GuiQuery<Collection<? extends Component>>(){

            @Override
            protected Collection<? extends Component> executeInEDT() {
                return h.roots();
            }
        });
        return (Collection)Preconditions.checkNotNull(roots);
    }

    @RunsInEDT
    private <T extends Component> void find(@Nonnull ComponentHierarchy h, @Nonnull GenericTypeMatcher<T> m, @Nonnull Component root, Set<T> found) {
        for (Component c : FinderDelegate.childrenOfComponent(root, h)) {
            this.find(h, m, (Component)Preconditions.checkNotNull((Object)c), found);
        }
        if (FinderDelegate.isMatching(root, m)) {
            found.add(m.supportedType().cast(root));
        }
    }

    @RunsInEDT
    private static <T extends Component> boolean isMatching(final @Nonnull Component c, final @Nonnull GenericTypeMatcher<T> m) {
        Boolean matching = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return m.matches(c);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)matching);
    }
}

