/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.util.Arrays;
import org.fest.util.Lists;
import org.fest.util.Maps;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.ToString;

public final class IntrospectionComponentFormatter
extends ComponentFormatterTemplate {
    private final Class<? extends Component> targetType;
    private final List<String> propertyNames;
    private final Map<String, PropertyDescriptor> descriptors = Maps.newHashMap();

    public IntrospectionComponentFormatter(@Nonnull Class<? extends Component> targetType, String ... propertyNames) {
        this.targetType = (Class)Preconditions.checkNotNull(targetType);
        this.propertyNames = Lists.newArrayList((Object[])propertyNames);
        this.populate();
    }

    private void populate() {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.targetType, Object.class);
        }
        catch (Exception e) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to get BeanInfo for type ", this.targetType.getName()}), e);
        }
        for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
            this.register((PropertyDescriptor)Preconditions.checkNotNull((Object)d));
        }
    }

    private void register(@Nonnull PropertyDescriptor d) {
        String name = d.getName();
        if (!this.propertyNames.contains(name)) {
            return;
        }
        this.descriptors.put(name, d);
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        StringBuilder b = new StringBuilder();
        b.append(c.getClass().getName()).append("[");
        int max = this.propertyNames.size() - 1;
        for (int i = 0; i <= max; ++i) {
            this.appendProperty(b, (String)Preconditions.checkNotNull((Object)this.propertyNames.get(i)), c);
            if (i >= max) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    private void appendProperty(@Nonnull StringBuilder b, @Nonnull String name, @Nonnull Component c) {
        b.append(name).append("=");
        try {
            b.append(this.propertyValue(c, name));
        }
        catch (Exception e) {
            b.append(String.format("<Unable to read property [%s: %s]>", e.getClass().getName(), Strings.quote((String)e.getMessage())));
        }
    }

    @Nullable
    private Object propertyValue(@Nonnull Component c, @Nonnull String property) throws Exception {
        if ("showing".equals(property)) {
            return c.isShowing();
        }
        PropertyDescriptor descriptor = this.descriptors.get(property);
        Object value = descriptor.getReadMethod().invoke((Object)c, new Object[0]);
        if (this.isOneDimensionalArray(value)) {
            return Arrays.format((Object)value);
        }
        return Strings.quote((Object)value);
    }

    private boolean isOneDimensionalArray(Object o) {
        return o != null && o.getClass().isArray() && !o.getClass().getComponentType().isArray();
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return this.targetType;
    }

    public String toString() {
        return String.format("%s[propertyNames=%s", this.getClass().getName(), ToString.toStringOf(this.propertyNames));
    }
}

