/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.actions.PaletteListPopupStep;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroComponentProperty;
import com.intellij.uiDesigner.quickFixes.ChangeFieldTypeFix;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MorphAction
extends AbstractGuiEditorAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.MorphAction");
    private final ComponentItem myLastMorphComponent = null;

    public MorphAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<RadComponent> selection, AnActionEvent e) {
        Processor processor = selectedValue -> {
            Runnable runnable = () -> {
                RadComponent c;
                Iterator iterator = selection.iterator();
                while (iterator.hasNext() && MorphAction.morphComponent(editor, c = (RadComponent)iterator.next(), selectedValue)) {
                }
                editor.refreshAndSave(true);
            };
            CommandProcessor.getInstance().executeCommand(editor.getProject(), runnable, UIDesignerBundle.message("morph.component.command", new Object[0]), null);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)editor.getGlassLayer(), true));
            return true;
        };
        PaletteListPopupStep step = new PaletteListPopupStep(editor, this.myLastMorphComponent, (Processor<ComponentItem>)processor, UIDesignerBundle.message("morph.component.title", new Object[0]));
        step.hideNonAtomic();
        if (selection.size() == 1) {
            step.hideComponentClass(selection.get(0).getComponentClassName());
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        FormEditingUtil.showPopupUnderComponent((JBPopup)listPopup, selection.get(0));
    }

    private static boolean morphComponent(GuiEditor editor, RadComponent oldComponent, ComponentItem targetItem) {
        if ((targetItem = InsertComponentProcessor.replaceAnyComponentItem(editor, targetItem, "Morph to Non-Palette Component")) == null) {
            return false;
        }
        RadComponent newComponent = InsertComponentProcessor.createInsertedComponent(editor, targetItem);
        if (newComponent == null) {
            return false;
        }
        newComponent.setBinding(oldComponent.getBinding());
        newComponent.setCustomLayoutConstraints(oldComponent.getCustomLayoutConstraints());
        newComponent.getConstraints().restore(oldComponent.getConstraints());
        MorphAction.updateBoundFieldType(editor, oldComponent, targetItem);
        IProperty[] oldProperties = oldComponent.getModifiedProperties();
        Palette palette = Palette.getInstance(editor.getProject());
        for (IProperty prop : oldProperties) {
            IntrospectedProperty newProp = palette.getIntrospectedProperty(newComponent, prop.getName());
            if (newProp == null || !prop.getClass().equals(newProp.getClass())) continue;
            Object oldValue = prop.getPropertyValue((IComponent)oldComponent);
            try {
                newProp.setValue(newComponent, oldValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MorphAction.retargetComponentProperties(editor, oldComponent, newComponent);
        RadContainer parent = oldComponent.getParent();
        int index = parent.indexOfComponent(oldComponent);
        parent.removeComponent(oldComponent);
        parent.addComponent(newComponent, index);
        newComponent.setSelected(true);
        if (oldComponent.isDefaultBinding()) {
            String binding;
            String text = FormInspectionUtil.getText(newComponent.getModule(), newComponent);
            if (text != null && (binding = BindingProperty.suggestBindingFromText(newComponent, text)) != null) {
                new BindingProperty(newComponent.getProject()).setValueEx(newComponent, binding);
            }
            newComponent.setDefaultBinding(true);
        }
        return true;
    }

    private static void updateBoundFieldType(GuiEditor editor, RadComponent oldComponent, ComponentItem targetItem) {
        PsiField oldBoundField = BindingProperty.findBoundField(editor.getRootContainer(), oldComponent.getBinding());
        if (oldBoundField != null) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)editor.getProject()).getElementFactory();
            try {
                PsiType componentType = factory.createTypeFromText(targetItem.getClassName().replace('$', '.'), null);
                new ChangeFieldTypeFix(editor, oldBoundField, componentType).run();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void retargetComponentProperties(GuiEditor editor, final RadComponent c, final RadComponent newComponent) {
        FormEditingUtil.iterate(editor.getRootContainer(), new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                RadComponent rc = (RadComponent)component;
                for (IProperty p : component.getModifiedProperties()) {
                    IntroComponentProperty icp;
                    String value;
                    if (!(p instanceof IntroComponentProperty) || !(value = (icp = (IntroComponentProperty)p).getValue(rc)).equals(c.getId())) continue;
                    try {
                        icp.setValue((RadComponent)component, newComponent.getId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
        });
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            MorphAction.$$$reportNull$$$0(0);
        }
        if (selection.size() == 0) {
            e.getPresentation().setEnabled(false);
            return;
        }
        for (RadComponent c : selection) {
            if (c instanceof RadAtomicComponent) continue;
            e.getPresentation().setEnabled(false);
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/actions/MorphAction", "update"));
    }
}

