/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class YAMLStructureViewElement
implements StructureViewTreeElement {
    private final YAMLPsiElement myElement;

    public YAMLStructureViewElement(YAMLPsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        Collection<YAMLPsiElement> children = this.myElement instanceof YAMLFile ? ((YAMLFile)this.myElement).getDocuments() : (this.myElement instanceof YAMLDocument ? YAMLStructureViewElement.getChildrenForValue(((YAMLDocument)this.myElement).getTopLevelValue()) : (this.myElement instanceof YAMLSequenceItem ? YAMLStructureViewElement.getChildrenForValue(((YAMLSequenceItem)this.myElement).getValue()) : (this.myElement instanceof YAMLKeyValue ? YAMLStructureViewElement.getChildrenForValue(((YAMLKeyValue)this.myElement).getValue()) : Collections.emptyList())));
        ArrayList<YAMLStructureViewElement> structureElements = new ArrayList<YAMLStructureViewElement>();
        for (YAMLPsiElement child : children) {
            structureElements.add(new YAMLStructureViewElement(child));
        }
        StructureViewTreeElement[] structureViewTreeElementArray = structureElements.toArray(StructureViewTreeElement.EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            YAMLStructureViewElement.$$$reportNull$$$0(0);
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    private static Collection<? extends YAMLPsiElement> getChildrenForValue(@Nullable YAMLPsiElement element) {
        if (element instanceof YAMLMapping) {
            Collection<YAMLKeyValue> collection = ((YAMLMapping)element).getKeyValues();
            if (collection == null) {
                YAMLStructureViewElement.$$$reportNull$$$0(1);
            }
            return collection;
        }
        if (element instanceof YAMLSequence) {
            List<YAMLSequenceItem> list = ((YAMLSequence)element).getItems();
            if (list == null) {
                YAMLStructureViewElement.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            YAMLStructureViewElement.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        if (this.myElement instanceof YAMLKeyValue) {
            final YAMLKeyValue kv = (YAMLKeyValue)this.myElement;
            ItemPresentation itemPresentation = new ItemPresentation(){

                public String getPresentableText() {
                    return kv.getKeyText();
                }

                public String getLocationString() {
                    if (kv.getValue() instanceof YAMLScalar) {
                        return kv.getValueText();
                    }
                    return null;
                }

                public Icon getIcon(boolean open) {
                    YAMLValue value = kv.getValue();
                    return value instanceof YAMLScalar ? kv.getIcon(0) : PlatformIcons.XML_TAG_ICON;
                }
            };
            if (itemPresentation == null) {
                YAMLStructureViewElement.$$$reportNull$$$0(4);
            }
            return itemPresentation;
        }
        if (this.myElement instanceof YAMLDocument) {
            ItemPresentation itemPresentation = new ItemPresentation(){

                public String getPresentableText() {
                    return "YAML document";
                }

                public String getLocationString() {
                    return null;
                }

                public Icon getIcon(boolean open) {
                    return PlatformIcons.XML_TAG_ICON;
                }
            };
            if (itemPresentation == null) {
                YAMLStructureViewElement.$$$reportNull$$$0(5);
            }
            return itemPresentation;
        }
        if (this.myElement instanceof YAMLSequenceItem) {
            final YAMLSequenceItem item = (YAMLSequenceItem)this.myElement;
            ItemPresentation itemPresentation = new ItemPresentation(){

                @Nullable
                public String getPresentableText() {
                    if (item.getValue() instanceof YAMLScalar) {
                        return ((YAMLScalar)item.getValue()).getTextValue();
                    }
                    return "Sequence Item";
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return item.getValue() instanceof YAMLScalar ? PlatformIcons.PROPERTY_ICON : PlatformIcons.XML_TAG_ICON;
                }
            };
            if (itemPresentation == null) {
                YAMLStructureViewElement.$$$reportNull$$$0(6);
            }
            return itemPresentation;
        }
        ItemPresentation itemPresentation = this.myElement.getPresentation();
        if (itemPresentation == null) {
            YAMLStructureViewElement.$$$reportNull$$$0(7);
        }
        return itemPresentation;
    }

    public YAMLPsiElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/yaml/structureView/YAMLStructureViewElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenForValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

