/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Base64;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.model.AndroidApplicationArtifactType;
import org.jetbrains.jps.android.model.JpsAndroidApplicationArtifactProperties;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class AndroidArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NonNls
    private static final String BUILDER_NAME = "Android Artifact Processor";

    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(0);
        }
        if (buildPhase == null) {
            AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(1);
        }
        if (buildPhase != ArtifactBuildTaskProvider.ArtifactBuildPhase.FINISHING_BUILD) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        JpsElement props = artifact.getProperties();
        if (!(props instanceof JpsAndroidApplicationArtifactProperties)) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        JpsAndroidApplicationArtifactProperties androidProps = (JpsAndroidApplicationArtifactProperties)props;
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        AndroidArtifactSigningMode signingMode = androidProps.getSigningMode();
        if (signingMode != AndroidArtifactSigningMode.RELEASE_SIGNED && signingMode != AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getPackagedFacet(artifact);
        List<Object> list = extension != null ? Collections.singletonList(new MyTask(artifact, extension, androidProps)) : Collections.emptyList();
        if (list == null) {
            AndroidArtifactBuildTaskProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPhase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidArtifactBuildTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidArtifactBuildTaskProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactBuildTasks";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTask
    extends BuildTask {
        private final JpsArtifact myArtifact;
        private final JpsAndroidModuleExtension myExtension;
        private final JpsAndroidApplicationArtifactProperties myProps;

        private MyTask(JpsArtifact artifact, JpsAndroidModuleExtension extension, JpsAndroidApplicationArtifactProperties props) {
            this.myArtifact = artifact;
            this.myExtension = extension;
            this.myProps = props;
        }

        public void build(CompileContext context) throws ProjectBuildException {
            String artifactName = this.myArtifact.getName();
            String entryName = "Artifact '" + artifactName + "'";
            String messagePrefix = "[" + entryName + "] ";
            JpsModule module = this.myExtension.getModule();
            AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, AndroidArtifactBuildTaskProvider.BUILDER_NAME);
            if (platform == null) {
                return;
            }
            String sdkLocation = platform.getSdk().getHomePath();
            String artifactFilePath = this.myArtifact.getOutputFilePath();
            String keyStorePath = this.myProps.getKeyStoreUrl() != null ? JpsPathUtil.urlToPath((String)this.myProps.getKeyStoreUrl()) : "";
            String keyStorePassword = this.myProps.getKeyStorePassword();
            String plainKeyStorePassword = keyStorePassword != null && !keyStorePassword.isEmpty() ? new String(Base64.decode((String)keyStorePassword), CharsetToolkit.UTF8_CHARSET) : null;
            String keyPassword = this.myProps.getKeyPassword();
            String plainKeyPassword = keyPassword != null && !keyPassword.isEmpty() ? new String(Base64.decode((String)keyStorePassword), CharsetToolkit.UTF8_CHARSET) : null;
            try {
                Map messages = AndroidCommonUtils.buildArtifact((String)artifactName, (String)messagePrefix, (String)sdkLocation, (IAndroidTarget)platform.getTarget(), (String)artifactFilePath, (String)keyStorePath, (String)this.myProps.getKeyAlias(), (String)plainKeyStorePassword, (String)plainKeyPassword);
                AndroidJpsUtil.addMessages(context, messages, AndroidArtifactBuildTaskProvider.BUILDER_NAME, entryName);
            }
            catch (GeneralSecurityException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, AndroidArtifactBuildTaskProvider.BUILDER_NAME);
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, AndroidArtifactBuildTaskProvider.BUILDER_NAME);
            }
        }
    }
}

