/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.LineOutputWriter;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.instrumentation.ClassProcessingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.RmicCompilerOptions;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.service.SharedThreadPool;

public class RmiStubsGenerator
extends ClassProcessingBuilder {
    private static final String REMOTE_INTERFACE_NAME = Remote.class.getName().replace('.', '/');
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final Key<Boolean> IS_ENABLED = Key.create((String)"_rmic_compiler_enabled_");

    public RmiStubsGenerator() {
        super(BuilderCategory.CLASS_INSTRUMENTER);
    }

    @Override
    protected String getProgressMessage() {
        return "Generating RMI stubs...";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if ("rmic" == null) {
            RmiStubsGenerator.$$$reportNull$$$0(0);
        }
        return "rmic";
    }

    @Override
    public void buildStarted(CompileContext context) {
        super.buildStarted(context);
        RmicCompilerOptions rmicOptions = RmiStubsGenerator.getOptions(context);
        IS_ENABLED.set((UserDataHolder)context, (Object)(rmicOptions != null && rmicOptions.IS_EANABLED ? 1 : 0));
    }

    @Override
    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        return (Boolean)IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.FALSE);
    }

    @Override
    protected ModuleLevelBuilder.ExitCode performBuild(CompileContext context, ModuleChunk chunk, InstrumentationClassFinder finder, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        if (!outputConsumer.getCompiledClasses().isEmpty()) {
            THashMap remoteClasses = new THashMap();
            for (ModuleBuildTarget target : chunk.getTargets()) {
                for (CompiledClass compiledClass : outputConsumer.getTargetCompiledClasses(target)) {
                    try {
                        if (!RmiStubsGenerator.isRemote(compiledClass, finder)) continue;
                        ArrayList<ClassItem> list = (ArrayList<ClassItem>)remoteClasses.get(target);
                        if (list == null) {
                            list = new ArrayList<ClassItem>();
                            remoteClasses.put(target, list);
                        }
                        list.add(new ClassItem(compiledClass));
                    }
                    catch (IOException e) {
                        context.processMessage(new CompilerMessage(this.getPresentableName(), e));
                    }
                }
            }
            if (!remoteClasses.isEmpty()) {
                exitCode = this.generateRmiStubs(context, (Map<ModuleBuildTarget, Collection<ClassItem>>)remoteClasses, chunk, outputConsumer);
            }
        }
        return exitCode;
    }

    private ModuleLevelBuilder.ExitCode generateRmiStubs(CompileContext context, Map<ModuleBuildTarget, Collection<ClassItem>> remoteClasses, ModuleChunk chunk, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        Collection<File> classpath = ProjectPaths.getCompilationClasspath(chunk, false);
        StringBuilder buf = new StringBuilder();
        for (File file : classpath) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(file.getPath());
        }
        String classpathString = buf.toString();
        String rmicPath = RmiStubsGenerator.getPathToRmic(chunk);
        RmicCompilerOptions options = RmiStubsGenerator.getOptions(context);
        ArrayList<ModuleBuildTarget> targetsProcessed = new ArrayList<ModuleBuildTarget>(remoteClasses.size());
        for (Map.Entry<ModuleBuildTarget, Collection<ClassItem>> entry : remoteClasses.entrySet()) {
            try {
                ModuleBuildTarget target = entry.getKey();
                Collection<String> cmdLine = RmiStubsGenerator.createStartupCommand(target, rmicPath, classpathString, options, entry.getValue());
                Process process = Runtime.getRuntime().exec(ArrayUtil.toStringArray(cmdLine));
                BaseOSProcessHandler handler = new BaseOSProcessHandler(process, StringUtil.join(cmdLine, (String)" "), null){

                    @NotNull
                    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
                        if (task == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Future future = SharedThreadPool.getInstance().executeOnPooledThread(task);
                        if (future == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return future;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "task";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/jps/incremental/instrumentation/RmiStubsGenerator$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/jps/incremental/instrumentation/RmiStubsGenerator$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "executeOnPooledThread";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "executeOnPooledThread";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                final RmicOutputParser stdOutParser = new RmicOutputParser(context, this.getPresentableName());
                final RmicOutputParser stdErrParser = new RmicOutputParser(context, this.getPresentableName());
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            stdOutParser.append(event.getText());
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            stdErrParser.append(event.getText());
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        super.processTerminated(event);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/jps/incremental/instrumentation/RmiStubsGenerator$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                handler.startNotify();
                handler.waitFor();
                targetsProcessed.add(target);
                if (stdErrParser.isErrorsReported() || stdOutParser.isErrorsReported()) break;
                int exitValue = handler.getProcess().exitValue();
                if (exitValue == 0) continue;
                context.processMessage(new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, "RMI stub generation failed"));
            }
            catch (IOException e) {
                context.processMessage(new CompilerMessage(this.getPresentableName(), e));
            }
            break;
        }
        THashMap fsCache = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        for (ModuleBuildTarget target : targetsProcessed) {
            Collection<ClassItem> items = remoteClasses.get(target);
            for (ClassItem item : items) {
                Collection<File> files;
                File[] children = (File[])fsCache.get(item.parentDir);
                if (children == null) {
                    children = item.parentDir.listFiles();
                    if (children == null) {
                        children = EMPTY_FILE_ARRAY;
                    }
                    fsCache.put(item.parentDir, children);
                }
                if ((files = item.selectGeneratedFiles(children)).isEmpty()) continue;
                List<String> sources = item.compiledClass.getSourceFilesPaths();
                for (File generated : files) {
                    try {
                        outputConsumer.registerOutputFile(target, generated, sources);
                    }
                    catch (IOException e) {
                        context.processMessage(new CompilerMessage(this.getPresentableName(), e));
                    }
                }
            }
        }
        return exitCode;
    }

    private static Collection<String> createStartupCommand(ModuleBuildTarget target, String compilerPath, String classpath, RmicCompilerOptions config, Collection<ClassItem> items) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(compilerPath);
        if (config.DEBUGGING_INFO) {
            commandLine.add("-g");
        }
        if (config.GENERATE_IIOP_STUBS) {
            commandLine.add("-iiop");
        }
        StringTokenizer tokenizer = new StringTokenizer(config.ADDITIONAL_OPTIONS_STRING, " \t\r\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            commandLine.add(token);
        }
        commandLine.add("-classpath");
        commandLine.add(classpath);
        commandLine.add("-d");
        File outputDir = target.getOutputDir();
        assert (outputDir != null);
        commandLine.add(outputDir.getPath());
        for (ClassItem item : items) {
            commandLine.add(item.compiledClass.getClassName());
        }
        return commandLine;
    }

    private static String getPathToRmic(ModuleChunk chunk) {
        int idx;
        String executable;
        JpsSdk sdk = chunk.representativeTarget().getModule().getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
        if (sdk != null && (executable = JpsJavaSdkType.getJavaExecutable((JpsSdk)sdk)) != null && (idx = FileUtil.toSystemIndependentName((String)executable).lastIndexOf("/")) >= 0) {
            return executable.substring(0, idx) + "/rmic";
        }
        return SystemProperties.getJavaHome() + "/bin/rmic";
    }

    private static boolean isRemote(CompiledClass compiled, InstrumentationClassFinder finder) throws IOException {
        try {
            InstrumentationClassFinder.PseudoClass pseudoClass = finder.loadClass(compiled.getClassName());
            if (pseudoClass != null && !pseudoClass.isInterface()) {
                for (InstrumentationClassFinder.PseudoClass anInterface : pseudoClass.getInterfaces()) {
                    if (!RmiStubsGenerator.isRemoteInterface(anInterface, REMOTE_INTERFACE_NAME)) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isRemoteInterface(InstrumentationClassFinder.PseudoClass iface, String remoteInterfaceName) throws IOException, ClassNotFoundException {
        if (remoteInterfaceName.equals(iface.getName())) {
            return true;
        }
        for (InstrumentationClassFinder.PseudoClass superIface : iface.getInterfaces()) {
            if (!RmiStubsGenerator.isRemoteInterface(superIface, remoteInterfaceName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static RmicCompilerOptions getOptions(CompileContext context) {
        JpsJavaCompilerOptions options;
        JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject());
        if (config != null && (options = config.getCompilerOptions("Rmic")) instanceof RmicCompilerOptions) {
            return (RmicCompilerOptions)options;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/instrumentation/RmiStubsGenerator", "getPresentableName"));
    }

    private static class RmicOutputParser
    extends LineOutputWriter {
        private final CompileContext myContext;
        private final String myCompilerName;
        private boolean myErrorsReported = false;

        private RmicOutputParser(CompileContext context, String name) {
            this.myContext = context;
            this.myCompilerName = name;
        }

        private boolean isErrorsReported() {
            return this.myErrorsReported;
        }

        protected void lineAvailable(String line) {
            if (!StringUtil.isEmpty((String)line)) {
                BuildMessage.Kind kind = BuildMessage.Kind.INFO;
                if (line.contains("error")) {
                    kind = BuildMessage.Kind.ERROR;
                    this.myErrorsReported = true;
                } else if (line.contains("warning")) {
                    kind = BuildMessage.Kind.WARNING;
                }
                this.myContext.processMessage(new CompilerMessage(this.myCompilerName, kind, line));
            }
        }
    }

    private static final class ClassItem {
        static final String[] GEN_SUFFIXES = new String[]{"_Stub.class", "_Skel.class", "_Tie.class"};
        final CompiledClass compiledClass;
        final File parentDir;
        final String baseName;

        ClassItem(CompiledClass compiledClass) {
            this.compiledClass = compiledClass;
            File outputFile = compiledClass.getOutputFile();
            this.parentDir = outputFile.getParentFile();
            this.baseName = StringUtil.trimEnd((String)outputFile.getName(), (String)".class");
        }

        @NotNull
        public Collection<File> selectGeneratedFiles(File[] candidates) {
            if (candidates == null || candidates.length == 0) {
                List<File> list = Collections.emptyList();
                if (list == null) {
                    ClassItem.$$$reportNull$$$0(0);
                }
                return list;
            }
            SmartList result = new SmartList();
            String[] suffixes = new String[GEN_SUFFIXES.length];
            for (int i = 0; i < GEN_SUFFIXES.length; ++i) {
                suffixes[i] = this.baseName + GEN_SUFFIXES[i];
            }
            block1: for (File candidate : candidates) {
                String name = candidate.getName();
                for (String suffix : suffixes) {
                    if (!name.endsWith(suffix)) continue;
                    result.add(candidate);
                    continue block1;
                }
            }
            SmartList smartList = result;
            if (smartList == null) {
                ClassItem.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/instrumentation/RmiStubsGenerator$ClassItem", "selectGeneratedFiles"));
        }
    }
}

