/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ChunkWithChunks
extends Chunk {
    private final Map<Integer, Chunk> chunks = new LinkedHashMap<Integer, Chunk>();

    protected ChunkWithChunks(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        Chunk chunk;
        int start;
        super.init(buffer);
        this.chunks.clear();
        int end = this.offset + this.getOriginalChunkSize();
        int position = buffer.position();
        buffer.position(start);
        for (int offset = start = this.offset + this.getHeaderSize(); offset < end; offset += chunk.getOriginalChunkSize()) {
            chunk = Chunk.newInstance(buffer, this);
            this.chunks.put(offset, chunk);
        }
        buffer.position(position);
    }

    public final Map<Integer, Chunk> getChunks() {
        return this.chunks;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        for (Chunk chunk : this.getChunks().values()) {
            byte[] chunkBytes = chunk.toByteArray(shrink);
            output.write(chunkBytes);
            this.writePad(output, chunkBytes.length);
        }
    }
}

