/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginAction;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;

class AddGradleDslPluginActionHandler
implements CodeInsightActionHandler {
    private final List<Pair<String, String>> myPlugins;

    public AddGradleDslPluginActionHandler(List<Pair<String, String>> plugins) {
        this.myPlugins = plugins;
    }

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            AddGradleDslPluginActionHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AddGradleDslPluginActionHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AddGradleDslPluginActionHandler.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{file})) {
            return;
        }
        JBList list = new JBList(this.myPlugins);
        list.setSelectionMode(0);
        list.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        Runnable runnable = () -> {
            if (project == null) {
                AddGradleDslPluginActionHandler.$$$reportNull$$$0(3);
            }
            if (file == null) {
                AddGradleDslPluginActionHandler.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                AddGradleDslPluginActionHandler.$$$reportNull$$$0(5);
            }
            final Pair selected = (Pair)list.getSelectedValue();
            new WriteCommandAction.Simple(project, GradleBundle.message("gradle.codeInsight.action.apply_plugin.text", new Object[0]), new PsiFile[]{file}){

                protected void run() {
                    if (selected == null) {
                        return;
                    }
                    GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
                    GrStatement grStatement = factory.createStatementFromText((CharSequence)String.format("apply plugin: '%s'", selected.first), null);
                    PsiElement anchor = file.findElementAt(editor.getCaretModel().getOffset());
                    PsiElement currentElement = PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{GrClosableBlock.class, GroovyFile.class});
                    if (currentElement != null) {
                        currentElement.addAfter((PsiElement)grStatement, anchor);
                    } else {
                        file.addAfter((PsiElement)grStatement, file.findElementAt(editor.getCaretModel().getOffset() - 1));
                    }
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                    Document document = documentManager.getDocument(file);
                    if (document != null) {
                        documentManager.commitDocument(document);
                    }
                }
            }.execute();
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Pair descriptor = (Pair)ContainerUtil.find(this.myPlugins, value -> ((String)value.first).equals(AddGradleDslPluginAction.TEST_THREAD_LOCAL.get()));
            list.setSelectedValue((Object)descriptor, false);
            runnable.run();
        } else {
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(GradleBundle.message("gradle.codeInsight.action.apply_plugin.popup.title", new Object[0])).setItemChoosenCallback(runnable).setFilteringEnabled(o -> String.valueOf(((Pair)o).first)).createPopup().showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/codeInsight/actions/AddGradleDslPluginActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel;
        private final JLabel myDescLabel;

        public MyListCellRenderer() {
            this.myPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            this.myNameLabel = new JLabel();
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add(new JLabel("     "));
            this.myDescLabel = new JLabel();
            this.myPanel.add((Component)this.myDescLabel, "East");
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            Font font = scheme.getFont(EditorFontType.PLAIN);
            this.myNameLabel.setFont(font);
            this.myDescLabel.setFont(font);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Pair descriptor = (Pair)value;
            Color backgroundColor = isSelected ? list.getSelectionBackground() : list.getBackground();
            this.myNameLabel.setText(String.valueOf(descriptor.first));
            this.myNameLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.myPanel.setBackground(backgroundColor);
            String description = String.format("<html><div WIDTH=%d>%s</div><html>", 400, String.valueOf(descriptor.second));
            this.myDescLabel.setText(description);
            this.myDescLabel.setForeground(LookupCellRenderer.getGrayedForeground((boolean)isSelected));
            this.myDescLabel.setBackground(backgroundColor);
            return this.myPanel;
        }
    }
}

