/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleScriptType;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GradlePositionManager
extends ScriptPositionManagerHelper {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.gradle.config.GradlePositionManager");
    private static final Pattern GRADLE_CLASS_PATTERN = Pattern.compile(".*_gradle_.*");
    private static final String SCRIPT_CLOSURE_PREFIX = "build_";
    private static final Key<CachedValue<ClassLoader>> GRADLE_CLASS_LOADER = Key.create((String)"GRADLE_CLASS_LOADER");
    private static final Key<CachedValue<Map<File, String>>> GRADLE_CLASS_NAME = Key.create((String)"GRADLE_CLASS_NAME");
    private final GradleInstallationManager myLibraryManager;

    public GradlePositionManager(@NotNull GradleInstallationManager manager) {
        if (manager == null) {
            GradlePositionManager.$$$reportNull$$$0(0);
        }
        this.myLibraryManager = manager;
    }

    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        if (runtimeName == null) {
            GradlePositionManager.$$$reportNull$$$0(1);
        }
        return runtimeName.startsWith(SCRIPT_CLOSURE_PREFIX) || GRADLE_CLASS_PATTERN.matcher(runtimeName).matches();
    }

    public boolean isAppropriateScriptFile(@NotNull GroovyFile scriptFile) {
        if (scriptFile == null) {
            GradlePositionManager.$$$reportNull$$$0(2);
        }
        return GroovyScriptUtil.isSpecificScriptFile((GroovyFile)scriptFile, (GroovyScriptType)GradleScriptType.INSTANCE);
    }

    @NotNull
    public String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        VirtualFile virtualFile;
        if (groovyFile == null) {
            GradlePositionManager.$$$reportNull$$$0(3);
        }
        if ((virtualFile = groovyFile.getVirtualFile()) == null) {
            if ("" == null) {
                GradlePositionManager.$$$reportNull$$$0(4);
            }
            return "";
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)groovyFile);
        if (module == null) {
            if ("" == null) {
                GradlePositionManager.$$$reportNull$$$0(5);
            }
            return "";
        }
        File scriptFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        String className = (String)((Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, GRADLE_CLASS_NAME, (CachedValueProvider)new ScriptSourceMapCalculator(module), false)).get(scriptFile);
        String string = className == null ? "" : className;
        if (string == null) {
            GradlePositionManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiFile getExtraScriptIfNotFound(@NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        String sourceFilePath;
        if (refType == null) {
            GradlePositionManager.$$$reportNull$$$0(7);
        }
        if (runtimeName == null) {
            GradlePositionManager.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GradlePositionManager.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            GradlePositionManager.$$$reportNull$$$0(10);
        }
        if ((sourceFilePath = GradlePositionManager.getScriptForClassName(refType)) == null) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)sourceFilePath));
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(virtualFile);
    }

    @Nullable
    private static String getScriptForClassName(@NotNull ReferenceType refType) {
        if (refType == null) {
            GradlePositionManager.$$$reportNull$$$0(11);
        }
        try {
            List<String> data = refType.sourcePaths(null);
            if (!data.isEmpty()) {
                return data.get(0);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private ClassLoader getGradleClassLoader(@NotNull Module module) {
        if (module == null) {
            GradlePositionManager.$$$reportNull$$$0(12);
        }
        Project project = module.getProject();
        return (ClassLoader)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, GRADLE_CLASS_LOADER, () -> {
            if (module == null) {
                GradlePositionManager.$$$reportNull$$$0(14);
            }
            return CachedValueProvider.Result.create((Object)this.createGradleClassLoader(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }, false);
    }

    @Nullable
    private ClassLoader createGradleClassLoader(@NotNull Module module) {
        String rootProjectPath;
        if (module == null) {
            GradlePositionManager.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)(rootProjectPath = ExternalSystemModulePropertyManager.getInstance((Module)module).getRootProjectPath()))) {
            return null;
        }
        VirtualFile sdkHome = this.myLibraryManager.getGradleHome(module, module.getProject(), rootProjectPath);
        if (sdkHome == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        VirtualFile libDir = sdkHome.findChild("lib");
        assert (libDir != null);
        for (VirtualFile child : libDir.getChildren()) {
            if (!"jar".equals(child.getExtension())) continue;
            urls.add(VfsUtilCore.convertToURL((String)child.getUrl()));
        }
        return UrlClassLoader.build().urls(urls).get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/config/GradlePositionManager";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradlePositionManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeScriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateRuntimeName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateScriptFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeScriptName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExtraScriptIfNotFound";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getScriptForClassName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGradleClassLoader";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createGradleClassLoader";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGradleClassLoader$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScriptSourceMapCalculator
    implements CachedValueProvider<Map<File, String>> {
        private final Module myModule;

        public ScriptSourceMapCalculator(Module module) {
            this.myModule = module;
        }

        public CachedValueProvider.Result<Map<File, String>> compute() {
            ConcurrentMap result = ConcurrentFactoryMap.createMap(scriptFile -> this.calcClassName((File)scriptFile));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myModule.getProject())});
        }

        @Nullable
        private String calcClassName(File scriptFile) {
            ClassLoader loader = GradlePositionManager.this.getGradleClassLoader(this.myModule);
            if (loader != null) {
                Class<?> fileScriptSource;
                try {
                    fileScriptSource = Class.forName("org.gradle.groovy.scripts.UriScriptSource", true, loader);
                }
                catch (ClassNotFoundException e) {
                    try {
                        fileScriptSource = Class.forName("org.gradle.groovy.scripts.FileScriptSource", true, loader);
                    }
                    catch (ClassNotFoundException e1) {
                        return null;
                    }
                }
                try {
                    Object source = fileScriptSource.getConstructor(String.class, File.class).newInstance("script", scriptFile);
                    return (String)fileScriptSource.getMethod("getClassName", new Class[0]).invoke(source, new Object[0]);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            return null;
        }
    }
}

