/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.DelegatingGradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;

@State(name="GradleSettings", storages={@Storage(value="gradle.xml")})
public class GradleSettings
extends AbstractExternalSystemSettings<GradleSettings, GradleProjectSettings, GradleSettingsListener>
implements PersistentStateComponent<MyState> {
    private final GradleSystemSettings mySystemSettings;

    public GradleSettings(@NotNull Project project) {
        if (project == null) {
            GradleSettings.$$$reportNull$$$0(0);
        }
        super(GradleSettingsListener.TOPIC, project);
        this.mySystemSettings = GradleSystemSettings.getInstance();
    }

    @NotNull
    public static GradleSettings getInstance(@NotNull Project project) {
        if (project == null) {
            GradleSettings.$$$reportNull$$$0(1);
        }
        GradleSettings gradleSettings = (GradleSettings)((Object)ServiceManager.getService((Project)project, GradleSettings.class));
        if (gradleSettings == null) {
            GradleSettings.$$$reportNull$$$0(2);
        }
        return gradleSettings;
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<GradleProjectSettings> listener) {
        if (listener == null) {
            GradleSettings.$$$reportNull$$$0(3);
        }
        this.getProject().getMessageBus().connect((Disposable)this.getProject()).subscribe(GradleSettingsListener.TOPIC, (Object)new DelegatingGradleSettingsListenerAdapter(listener));
    }

    protected void copyExtraSettingsFrom(@NotNull GradleSettings settings) {
        if (settings == null) {
            GradleSettings.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        return state;
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            GradleSettings.$$$reportNull$$$0(5);
        }
        super.loadState((AbstractExternalSystemSettings.State)state);
    }

    @Nullable
    public String getServiceDirectoryPath() {
        return this.mySystemSettings.getServiceDirectoryPath();
    }

    public void setServiceDirectoryPath(@Nullable String newPath) {
        String myServiceDirectoryPath = this.mySystemSettings.getServiceDirectoryPath();
        if (!Comparing.equal((String)myServiceDirectoryPath, (String)newPath)) {
            this.mySystemSettings.setServiceDirectoryPath(newPath);
            ((GradleSettingsListener)this.getPublisher()).onServiceDirectoryPathChange(myServiceDirectoryPath, newPath);
        }
    }

    @Nullable
    public String getGradleVmOptions() {
        return this.mySystemSettings.getGradleVmOptions();
    }

    public void setGradleVmOptions(@Nullable String gradleVmOptions) {
        String myGradleVmOptions = this.mySystemSettings.getGradleVmOptions();
        if (!Comparing.equal((String)myGradleVmOptions, (String)gradleVmOptions)) {
            this.mySystemSettings.setGradleVmOptions(gradleVmOptions);
            ((GradleSettingsListener)this.getPublisher()).onGradleVmOptionsChange(myGradleVmOptions, gradleVmOptions);
        }
    }

    public boolean isOfflineWork() {
        return this.mySystemSettings.isOfflineWork();
    }

    public void setOfflineWork(boolean isOfflineWork) {
        this.mySystemSettings.setOfflineWork(isOfflineWork);
    }

    protected void checkSettings(@NotNull GradleProjectSettings old, @NotNull GradleProjectSettings current) {
        if (old == null) {
            GradleSettings.$$$reportNull$$$0(6);
        }
        if (current == null) {
            GradleSettings.$$$reportNull$$$0(7);
        }
        if (!Comparing.equal((String)old.getGradleHome(), (String)current.getGradleHome())) {
            ((GradleSettingsListener)this.getPublisher()).onGradleHomeChange(old.getGradleHome(), current.getGradleHome(), current.getExternalProjectPath());
        }
        if (old.getDistributionType() != current.getDistributionType()) {
            ((GradleSettingsListener)this.getPublisher()).onGradleDistributionTypeChange(current.getDistributionType(), current.getExternalProjectPath());
        }
        if (old.isResolveModulePerSourceSet() != current.isResolveModulePerSourceSet()) {
            ExternalProjectsManager.getInstance((Project)this.getProject()).getExternalProjectsWatcher().markDirty(current.getExternalProjectPath());
        }
        ThreeState storeProjectFilesExternally = current.getStoreProjectFilesExternally();
        if (old.getStoreProjectFilesExternally() != storeProjectFilesExternally) {
            ExternalProjectsManagerImpl.getInstance((Project)this.getProject()).setStoreExternally(storeProjectFilesExternally != ThreeState.NO);
        }
    }

    @NotNull
    public Collection<GradleProjectSettings> getLinkedProjectsSettings() {
        Collection settings = super.getLinkedProjectsSettings();
        boolean isStoredExternally = ExternalStorageConfigurationManager.getInstance((Project)this.getProject()).isEnabled();
        for (GradleProjectSettings setting : settings) {
            setting.setStoreProjectFilesExternally(ThreeState.fromBoolean((boolean)isStoredExternally));
        }
        Collection collection = settings;
        if (collection == null) {
            GradleSettings.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedProjectsSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyExtraSettingsFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyState
    implements AbstractExternalSystemSettings.State<GradleProjectSettings> {
        private final Set<GradleProjectSettings> myProjectSettings = ContainerUtilRt.newTreeSet();

        @XCollection(elementTypes={GradleProjectSettings.class})
        public Set<GradleProjectSettings> getLinkedExternalProjectsSettings() {
            return this.myProjectSettings;
        }

        public void setLinkedExternalProjectsSettings(Set<GradleProjectSettings> settings) {
            if (settings != null) {
                this.myProjectSettings.addAll(settings);
            }
        }
    }
}

