/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryCachedModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryModuleComponentRepositoryCaches;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.collect.MapMaker;

public class InMemoryCachedRepositoryFactory
implements Stoppable {
    public static final String TOGGLE_PROPERTY = "org.gradle.resolution.memorycache";
    private static final Logger LOG = Logging.getLogger(InMemoryCachedRepositoryFactory.class);
    private final Map<String, InMemoryModuleComponentRepositoryCaches> cachePerRepo = new MapMaker().makeMap();

    public ModuleComponentRepository cached(ModuleComponentRepository input) {
        if ("false".equalsIgnoreCase(System.getProperty(TOGGLE_PROPERTY))) {
            return input;
        }
        InMemoryModuleComponentRepositoryCaches caches = this.cachePerRepo.get(input.getId());
        if (caches == null) {
            LOG.debug("Creating new in-memory cache for repo '{}' [{}].", input.getName(), input.getId());
            caches = new InMemoryModuleComponentRepositoryCaches();
            this.cachePerRepo.put(input.getId(), caches);
        } else {
            LOG.debug("Reusing in-memory cache for repo '{}' [{}].", input.getName(), input.getId());
        }
        return new InMemoryCachedModuleComponentRepository(caches, input);
    }

    @Override
    public void stop() {
        this.cachePerRepo.clear();
    }
}

