/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CompositeConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflictFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;

public class DefaultConflictHandler
implements ConflictHandler {
    private static final Logger LOGGER = Logging.getLogger(DefaultConflictHandler.class);
    private final CompositeConflictResolver compositeResolver = new CompositeConflictResolver();
    private final ConflictContainer<ModuleIdentifier, ComponentResolutionState> conflicts = new ConflictContainer();
    private final ModuleReplacementsData moduleReplacements;

    public DefaultConflictHandler(ModuleConflictResolver conflictResolver, ModuleReplacementsData moduleReplacements) {
        this.moduleReplacements = moduleReplacements;
        this.compositeResolver.addFirst(conflictResolver);
    }

    @Override
    @Nullable
    public PotentialConflict registerModule(CandidateModule newModule) {
        ModuleIdentifier replacedBy = this.moduleReplacements.getReplacementFor(newModule.getId());
        return PotentialConflictFactory.potentialConflict(this.conflicts.newElement(newModule.getId(), newModule.getVersions(), replacedBy));
    }

    @Override
    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @Override
    public void resolveNextConflict(Action<ConflictResolutionResult> resolutionAction) {
        assert (this.hasConflicts());
        ConflictContainer.Conflict conflict = this.conflicts.popConflict();
        DefaultConflictResolverDetails details = new DefaultConflictResolverDetails(conflict.candidates);
        this.compositeResolver.select(details);
        if (details.hasFailure()) {
            throw UncheckedException.throwAsUncheckedException(details.getFailure());
        }
        DefaultConflictResolutionResult result = new DefaultConflictResolutionResult(conflict.participants, (ComponentResolutionState)details.getSelected(), conflict.candidates);
        resolutionAction.execute(result);
        LOGGER.debug("Selected {} from conflicting modules {}.", details.getSelected(), conflict.candidates);
    }

    @Override
    public void registerResolver(ModuleConflictResolver conflictResolver) {
        this.compositeResolver.addFirst(conflictResolver);
    }
}

