/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.resource.ExternalResourceName;

abstract class AbstractResourcePattern
implements ResourcePattern {
    private final ExternalResourceName pattern;

    public AbstractResourcePattern(String pattern) {
        this.pattern = new ExternalResourceName(pattern);
    }

    public AbstractResourcePattern(URI baseUri, String pattern) {
        this.pattern = new ExternalResourceName(baseUri, pattern);
    }

    @Override
    public String getPattern() {
        return this.pattern.getDecoded();
    }

    protected ExternalResourceName getBase() {
        return this.pattern;
    }

    protected String substituteTokens(String pattern, Map<String, String> attributes) {
        return IvyPatternHelper.substituteTokens((String)pattern, attributes);
    }

    protected Map<String, String> toAttributes(ModuleComponentArtifactMetadata artifact) {
        Map<String, String> attributes = this.toAttributes(artifact.getId().getComponentIdentifier());
        attributes.putAll(this.toAttributes(artifact.getName()));
        return attributes;
    }

    protected Map<String, String> toAttributes(ModuleIdentifier module, IvyArtifactName ivyArtifactName) {
        Map<String, String> attributes = this.toAttributes(module);
        attributes.putAll(this.toAttributes(ivyArtifactName));
        return attributes;
    }

    protected Map<String, String> toAttributes(IvyArtifactName ivyArtifact) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("artifact", ivyArtifact.getName());
        attributes.put("type", ivyArtifact.getType());
        attributes.put("ext", ivyArtifact.getExtension());
        attributes.put("classifier", ivyArtifact.getClassifier());
        return attributes;
    }

    protected Map<String, String> toAttributes(ModuleIdentifier module) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("organisation", module.getGroup());
        attributes.put("module", module.getName());
        return attributes;
    }

    protected Map<String, String> toAttributes(ModuleComponentIdentifier componentIdentifier) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("organisation", componentIdentifier.getGroup());
        attributes.put("module", componentIdentifier.getModule());
        attributes.put("revision", componentIdentifier.getVersion());
        return attributes;
    }
}

