/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;

public class RegularFileSnapshot
implements FileSnapshot {
    private final String path;
    private final RelativePath relativePath;
    private final boolean root;
    private final FileContentSnapshot content;

    public RegularFileSnapshot(String path, RelativePath relativePath, boolean root, FileContentSnapshot content) {
        this.path = path;
        this.relativePath = relativePath;
        this.root = root;
        this.content = content;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " " + this.path;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.relativePath.getLastName();
    }

    public boolean isRoot() {
        return this.root;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public FileContentSnapshot getContent() {
        return this.content;
    }

    public FileType getType() {
        return FileType.RegularFile;
    }

    public RegularFileSnapshot withContentHash(HashCode contentHash) {
        if (!contentHash.equals(this.getContent().getContentMd5())) {
            return new RegularFileSnapshot(this.path, this.relativePath, this.root, new FileHashSnapshot(contentHash));
        }
        return this;
    }
}

