/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.internal.Factory;

public class RestartEveryNTestClassProcessor
implements TestClassProcessor {
    private final Factory<TestClassProcessor> factory;
    private final long restartEvery;
    private long testCount;
    private TestClassProcessor processor;
    private TestResultProcessor resultProcessor;

    public RestartEveryNTestClassProcessor(Factory<TestClassProcessor> factory, long restartEvery) {
        this.factory = factory;
        this.restartEvery = restartEvery;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        if (this.processor == null) {
            this.processor = this.factory.create();
            this.processor.startProcessing(this.resultProcessor);
        }
        this.processor.processTestClass(testClass);
        ++this.testCount;
        if (this.testCount == this.restartEvery) {
            this.endBatch();
        }
    }

    @Override
    public void stop() {
        if (this.processor != null) {
            this.endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endBatch() {
        try {
            this.processor.stop();
        }
        finally {
            this.processor = null;
            this.testCount = 0L;
        }
    }
}

