/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.java.DefaultJavaSourceSet;
import org.gradle.api.internal.java.DefaultJvmResourceSet;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.api.internal.jvm.DefaultClassDirectoryBinarySpec;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.SourceSetCompileClasspath;
import org.gradle.api.internal.tasks.testing.NoMatchingTestsReporter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.plugins.BinaryBasePlugin;
import org.gradle.util.SingleMessageLogger;
import org.gradle.util.WrapUtil;

public class JavaBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    private final Instantiator instantiator;
    private final JavaToolChain javaToolChain;
    private final ITaskFactory taskFactory;
    private final ModelRegistry modelRegistry;
    private final ObjectFactory objectFactory;

    @Inject
    public JavaBasePlugin(Instantiator instantiator, JavaToolChain javaToolChain, ITaskFactory taskFactory, ModelRegistry modelRegistry, ObjectFactory objectFactory) {
        this.instantiator = instantiator;
        this.javaToolChain = javaToolChain;
        this.taskFactory = taskFactory;
        this.modelRegistry = modelRegistry;
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getPluginManager().apply(LanguageBasePlugin.class);
        project.getPluginManager().apply(BinaryBasePlugin.class);
        JavaPluginConvention javaConvention = new JavaPluginConvention(project, this.instantiator);
        project.getConvention().getPlugins().put("java", javaConvention);
        this.configureCompileDefaults(project, javaConvention);
        BridgedBinaries binaries = this.configureSourceSetDefaults(javaConvention);
        this.modelRegistry.register(ModelRegistrations.bridgedInstance(ModelReference.of("bridgedBinaries", BridgedBinaries.class), binaries).descriptor("JavaBasePlugin.apply()").hidden(true).build());
        this.configureJavaDoc(project, javaConvention);
        this.configureTest(project, javaConvention);
        this.configureBuildNeeded(project);
        this.configureBuildDependents(project);
        this.configureSchema(project);
    }

    private void configureSchema(ProjectInternal project) {
        AttributeMatchingStrategy<Usage> matchingStrategy = project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getCompatibilityRules().add(UsageCompatibilityRules.class);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, new Action<ActionConfiguration>(){

            @Override
            public void execute(ActionConfiguration actionConfiguration) {
                actionConfiguration.params(JavaBasePlugin.this.objectFactory.named(Usage.class, "java-api"));
                actionConfiguration.params(JavaBasePlugin.this.objectFactory.named(Usage.class, "java-api-classes"));
                actionConfiguration.params(JavaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-jars"));
                actionConfiguration.params(JavaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-classes"));
                actionConfiguration.params(JavaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-resources"));
            }
        });
        ((ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().create("jar")).getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime-jars"));
    }

    private BridgedBinaries configureSourceSetDefaults(JavaPluginConvention pluginConvention) {
        final ProjectInternal project = pluginConvention.getProject();
        final ArrayList binaries = Lists.newArrayList();
        pluginConvention.getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(SourceSet sourceSet) {
                ConventionMapping outputConventionMapping = ((IConventionAware)((Object)sourceSet.getOutput())).getConventionMapping();
                ConfigurationContainer configurations = project.getConfigurations();
                JavaBasePlugin.this.defineConfigurationsForSourceSet(sourceSet, configurations);
                JavaBasePlugin.this.definePathsForSourceSet(sourceSet, outputConventionMapping, project);
                JavaBasePlugin.this.createProcessResourcesTaskForBinary(sourceSet, sourceSet.getResources(), project);
                JavaBasePlugin.this.createCompileJavaTaskForBinary(sourceSet, sourceSet.getJava(), project);
                JavaBasePlugin.this.createBinaryLifecycleTask(sourceSet, project);
                DefaultComponentSpecIdentifier binaryId = new DefaultComponentSpecIdentifier(project.getPath(), sourceSet.getName());
                ClassDirectoryBinarySpecInternal binary = JavaBasePlugin.this.instantiator.newInstance(DefaultClassDirectoryBinarySpec.class, binaryId, sourceSet, JavaBasePlugin.this.javaToolChain, DefaultJavaPlatform.current(), JavaBasePlugin.this.instantiator, JavaBasePlugin.this.taskFactory);
                SourceSetCompileClasspath compileClasspath = new SourceSetCompileClasspath(sourceSet);
                DefaultJavaSourceSet javaSourceSet = JavaBasePlugin.this.instantiator.newInstance(DefaultJavaSourceSet.class, binaryId.child("java"), sourceSet.getJava(), compileClasspath);
                JvmResourceSet resourceSet = JavaBasePlugin.this.instantiator.newInstance(DefaultJvmResourceSet.class, binaryId.child("resources"), sourceSet.getResources());
                binary.addSourceSet(javaSourceSet);
                binary.addSourceSet(resourceSet);
                JavaBasePlugin.this.attachTasksToBinary(binary, sourceSet, project);
                binaries.add(binary);
            }
        });
        return new BridgedBinaries(binaries);
    }

    private void createCompileJavaTaskForBinary(final SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, Project target) {
        JavaCompile compileTask = target.getTasks().create(sourceSet.getCompileJavaTaskName(), JavaCompile.class);
        compileTask.setDescription("Compiles " + sourceDirectorySet + ".");
        compileTask.setSource(sourceDirectorySet);
        ConventionMapping conventionMapping = compileTask.getConventionMapping();
        conventionMapping.map("classpath", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath();
            }
        });
        SourceSetUtil.configureOutputDirectoryForSourceSet(sourceSet, sourceDirectorySet, compileTask, target);
    }

    private void createProcessResourcesTaskForBinary(final SourceSet sourceSet, SourceDirectorySet resourceSet, Project target) {
        Copy resourcesTask = target.getTasks().create(sourceSet.getProcessResourcesTaskName(), ProcessResources.class);
        resourcesTask.setDescription("Processes " + resourceSet + ".");
        new DslObject(resourcesTask).getConventionMapping().map("destinationDir", new Callable<File>(){

            @Override
            public File call() throws Exception {
                return sourceSet.getOutput().getResourcesDir();
            }
        });
        resourcesTask.from(resourceSet);
    }

    private void createBinaryLifecycleTask(SourceSet sourceSet, Project target) {
        sourceSet.compiledBy(sourceSet.getClassesTaskName());
        Task classesTask = target.task(sourceSet.getClassesTaskName());
        classesTask.setGroup(BUILD_TASK_NAME);
        classesTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
        classesTask.dependsOn(sourceSet.getOutput().getDirs());
        classesTask.dependsOn(sourceSet.getCompileJavaTaskName());
        classesTask.dependsOn(sourceSet.getProcessResourcesTaskName());
    }

    private void attachTasksToBinary(ClassDirectoryBinarySpecInternal binary, SourceSet sourceSet, Project target) {
        Task compileTask = target.getTasks().getByPath(sourceSet.getCompileJavaTaskName());
        Task resourcesTask = target.getTasks().getByPath(sourceSet.getProcessResourcesTaskName());
        Task classesTask = target.getTasks().getByPath(sourceSet.getClassesTaskName());
        binary.getTasks().add(compileTask);
        binary.getTasks().add(resourcesTask);
        binary.getTasks().add(classesTask);
        binary.setBuildTask(classesTask);
    }

    private void definePathsForSourceSet(final SourceSet sourceSet, ConventionMapping outputConventionMapping, final Project project) {
        outputConventionMapping.map("resourcesDir", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String classesDirName = "resources/" + sourceSet.getName();
                return new File(project.getBuildDir(), classesDirName);
            }
        });
        sourceSet.getJava().srcDir("src/" + sourceSet.getName() + "/java");
        sourceSet.getResources().srcDir("src/" + sourceSet.getName() + "/resources");
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        String compileConfigurationName = sourceSet.getCompileConfigurationName();
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String runtimeConfigurationName = sourceSet.getRuntimeConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
        String runtimeClasspathConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
        String sourceSetName = sourceSet.toString();
        Configuration compileConfiguration = (Configuration)configurations.maybeCreate(compileConfigurationName);
        compileConfiguration.setVisible(false);
        compileConfiguration.setDescription("Dependencies for " + sourceSetName + " (deprecated, use '" + implementationConfigurationName + " ' instead).");
        Configuration implementationConfiguration = (Configuration)configurations.maybeCreate(implementationConfigurationName);
        implementationConfiguration.setVisible(false);
        implementationConfiguration.setDescription("Implementation only dependencies for " + sourceSetName + ".");
        implementationConfiguration.setCanBeConsumed(false);
        implementationConfiguration.setCanBeResolved(false);
        implementationConfiguration.extendsFrom(compileConfiguration);
        Configuration runtimeConfiguration = (Configuration)configurations.maybeCreate(runtimeConfigurationName);
        runtimeConfiguration.setVisible(false);
        runtimeConfiguration.extendsFrom(compileConfiguration);
        runtimeConfiguration.setDescription("Runtime dependencies for " + sourceSetName + " (deprecated, use '" + runtimeOnlyConfigurationName + " ' instead).");
        Configuration compileOnlyConfiguration = (Configuration)configurations.maybeCreate(compileOnlyConfigurationName);
        compileOnlyConfiguration.setVisible(false);
        compileOnlyConfiguration.setDescription("Compile only dependencies for " + sourceSetName + ".");
        Configuration compileClasspathConfiguration = (Configuration)configurations.maybeCreate(compileClasspathConfigurationName);
        compileClasspathConfiguration.setVisible(false);
        compileClasspathConfiguration.extendsFrom(compileOnlyConfiguration, implementationConfiguration);
        compileClasspathConfiguration.setDescription("Compile classpath for " + sourceSetName + ".");
        compileClasspathConfiguration.setCanBeConsumed(false);
        compileClasspathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-api"));
        Configuration runtimeOnlyConfiguration = (Configuration)configurations.maybeCreate(runtimeOnlyConfigurationName);
        runtimeOnlyConfiguration.setVisible(false);
        runtimeOnlyConfiguration.setCanBeConsumed(false);
        runtimeOnlyConfiguration.setCanBeResolved(false);
        runtimeOnlyConfiguration.setDescription("Runtime only dependencies for " + sourceSetName + ".");
        Configuration runtimeClasspathConfiguration = (Configuration)configurations.maybeCreate(runtimeClasspathConfigurationName);
        runtimeClasspathConfiguration.setVisible(false);
        runtimeClasspathConfiguration.setCanBeConsumed(false);
        runtimeClasspathConfiguration.setCanBeResolved(true);
        runtimeClasspathConfiguration.setDescription("Runtime classpath of " + sourceSetName + ".");
        runtimeClasspathConfiguration.extendsFrom(runtimeOnlyConfiguration, runtimeConfiguration, implementationConfiguration);
        runtimeClasspathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime"));
        sourceSet.setCompileClasspath(compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus(runtimeClasspathConfiguration));
    }

    @Deprecated
    public void configureForSourceSet(final SourceSet sourceSet, final AbstractCompile compile) {
        SingleMessageLogger.nagUserOfDiscontinuedMethod("configureForSourceSet(SourceSet, AbstractCompile)");
        compile.setDescription("Compiles the " + sourceSet.getJava() + ".");
        ConventionMapping conventionMapping = compile.getConventionMapping();
        compile.setSource(sourceSet.getJava());
        conventionMapping.map("classpath", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath().plus(compile.getProject().files(sourceSet.getJava().getOutputDir()));
            }
        });
        conventionMapping.map("destinationDir", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getOutput().getClassesDir();
            }
        });
    }

    private void configureCompileDefaults(Project project, final JavaPluginConvention javaConvention) {
        project.getTasks().withType(AbstractCompile.class, new Action<AbstractCompile>(){

            @Override
            public void execute(AbstractCompile compile) {
                ConventionMapping conventionMapping = compile.getConventionMapping();
                conventionMapping.map("sourceCompatibility", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getSourceCompatibility().toString();
                    }
                });
                conventionMapping.map("targetCompatibility", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getTargetCompatibility().toString();
                    }
                });
            }
        });
    }

    private void configureJavaDoc(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Javadoc.class, new Action<Javadoc>(){

            @Override
            public void execute(Javadoc javadoc) {
                javadoc.getConventionMapping().map("destinationDir", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(convention.getDocsDir(), "javadoc");
                    }
                });
                javadoc.getConventionMapping().map("title", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle();
                    }
                });
            }
        });
    }

    private void configureBuildNeeded(Project project) {
        DefaultTask buildTask = project.getTasks().create(BUILD_NEEDED_TASK_NAME, DefaultTask.class);
        buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
        buildTask.setGroup(BUILD_TASK_NAME);
        buildTask.dependsOn(BUILD_TASK_NAME);
    }

    private void configureBuildDependents(Project project) {
        DefaultTask buildTask = project.getTasks().create(BUILD_DEPENDENTS_TASK_NAME, DefaultTask.class);
        buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
        buildTask.setGroup(BUILD_TASK_NAME);
        buildTask.dependsOn(BUILD_TASK_NAME);
        buildTask.doFirst((Action<? super Task>)new Action<Task>(){

            @Override
            public void execute(Task task) {
                if (!task.getProject().getGradle().getIncludedBuilds().isEmpty()) {
                    task.getProject().getLogger().warn("[composite-build] Warning: `" + task.getPath() + "` task does not build included builds.");
                }
            }
        });
    }

    private void configureTest(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Test.class, new Action<Test>(){

            @Override
            public void execute(Test test) {
                JavaBasePlugin.this.configureTestDefaults(test, project, convention);
            }
        });
        project.getGradle().getTaskGraph().whenReady(new Action<TaskExecutionGraph>(){

            @Override
            public void execute(final TaskExecutionGraph taskExecutionGraph) {
                project.getTasks().withType(Test.class, new Action<Test>(){

                    @Override
                    public void execute(Test test) {
                        if (taskExecutionGraph.hasTask(test)) {
                            JavaBasePlugin.this.configureBasedOnSingleProperty(test);
                            JavaBasePlugin.this.overwriteDebugIfDebugPropertyIsSet(test);
                        }
                    }
                });
            }
        });
    }

    private void overwriteDebugIfDebugPropertyIsSet(Test test) {
        String debugProp = this.getTaskPrefixedProperty(test, "debug");
        if (debugProp != null) {
            test.prependParallelSafeAction((Action<? super Task>)new Action<Task>(){

                @Override
                public void execute(Task task) {
                    task.getLogger().info("Running tests for remote debugging.");
                }
            });
            test.setDebug(true);
        }
    }

    private void configureBasedOnSingleProperty(final Test test) {
        String singleTest = this.getTaskPrefixedProperty(test, "single");
        if (singleTest == null) {
            test.getInputs().files(test.getCandidateClassFiles()).withPropertyName("nonEmptyCandidateClassFiles").withPathSensitivity(PathSensitivity.RELATIVE).skipWhenEmpty();
            return;
        }
        test.prependParallelSafeAction((Action<? super Task>)new Action<Task>(){

            @Override
            public void execute(Task task) {
                test.getLogger().info("Running single tests with pattern: {}", test.getIncludes());
            }
        });
        test.setIncludes(WrapUtil.toSet("**/" + singleTest + "*.class"));
        test.addTestListener(new NoMatchingTestsReporter("Could not find matching test for pattern: " + singleTest));
    }

    private String getTaskPrefixedProperty(Task task, String propertyName) {
        String suffix = '.' + propertyName;
        String value = System.getProperty(task.getPath() + suffix);
        if (value == null) {
            return System.getProperty(task.getName() + suffix);
        }
        return value;
    }

    private void configureTestDefaults(final Test test, Project project, final JavaPluginConvention convention) {
        DslObject htmlReport = new DslObject(test.getReports().getHtml());
        DslObject xmlReport = new DslObject(test.getReports().getJunitXml());
        xmlReport.getConventionMapping().map("destination", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestResultsDir(), test.getName());
            }
        });
        htmlReport.getConventionMapping().map("destination", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestReportDir(), test.getName());
            }
        });
        test.getConventionMapping().map("binResultsDir", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestResultsDir(), test.getName() + "/binary");
            }
        });
        test.workingDir(project.getProjectDir());
    }

    static class UsageCompatibilityRules
    implements AttributeCompatibilityRule<Usage> {
        UsageCompatibilityRules() {
        }

        @Override
        public void execute(CompatibilityCheckDetails<Usage> details) {
            if (details.getConsumerValue().getName().equals("java-api")) {
                if (details.getProducerValue().getName().equals("java-api-classes")) {
                    details.compatible();
                } else if (details.getProducerValue().getName().equals("java-runtime-jars")) {
                    details.compatible();
                }
            } else if (details.getConsumerValue().getName().equals("java-api-classes")) {
                if (details.getProducerValue().getName().equals("java-api")) {
                    details.compatible();
                } else if (details.getProducerValue().getName().equals("java-runtime-jars")) {
                    details.compatible();
                }
            } else if (details.getConsumerValue().getName().equals("java-runtime") && details.getProducerValue().getName().equals("java-runtime-jars")) {
                details.compatible();
            } else if (details.getConsumerValue().getName().equals("java-runtime-classes") && details.getProducerValue().getName().equals("java-runtime-jars")) {
                details.compatible();
            } else if (details.getConsumerValue().getName().equals("java-runtime-resources") && details.getProducerValue().getName().equals("java-runtime-jars")) {
                details.compatible();
            }
        }
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        final Usage javaApi;
        final Usage javaApiClasses;
        final Usage javaRuntimeJars;
        final Usage javaRuntimeClasses;
        final Usage javaRuntimeResources;

        @Inject
        UsageDisambiguationRules(Usage javaApi, Usage javaApiClasses, Usage javaRuntimeJars, Usage javaRuntimeClasses, Usage javaRuntimeResources) {
            this.javaApi = javaApi;
            this.javaApiClasses = javaApiClasses;
            this.javaRuntimeJars = javaRuntimeJars;
            this.javaRuntimeClasses = javaRuntimeClasses;
            this.javaRuntimeResources = javaRuntimeResources;
        }

        @Override
        public void execute(MultipleCandidatesDetails<Usage> details) {
            Usage requested;
            if (details.getCandidateValues().equals(ImmutableSet.of((Object)this.javaApi, (Object)this.javaApiClasses))) {
                details.closestMatch(this.javaApiClasses);
            } else if (details.getConsumerValue() == null) {
                if (details.getCandidateValues().equals(ImmutableSet.of((Object)this.javaApi, (Object)this.javaRuntimeJars))) {
                    details.closestMatch(this.javaRuntimeJars);
                } else if (details.getCandidateValues().equals(ImmutableSet.of((Object)this.javaRuntimeJars, (Object)this.javaRuntimeClasses, (Object)this.javaRuntimeResources))) {
                    details.closestMatch(this.javaRuntimeJars);
                }
            } else if (details.getConsumerValue() != null && ((requested = details.getConsumerValue()).getName().equals("java-api") || requested.getName().equals("java-api-classes")) && details.getCandidateValues().equals(ImmutableSet.of((Object)this.javaApi, (Object)this.javaRuntimeJars))) {
                details.closestMatch(this.javaApi);
            }
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Mutate
        void attachBridgedSourceSets(ProjectSourceSet projectSourceSet, BridgedBinaries bridgedBinaries) {
            for (ClassDirectoryBinarySpecInternal binary : bridgedBinaries.binaries) {
                projectSourceSet.addAll(binary.getInputs());
            }
        }

        @Mutate
        void attachBridgedBinaries(BinaryContainer binaries, BridgedBinaries bridgedBinaries) {
            for (BinarySpecInternal binarySpecInternal : bridgedBinaries.binaries) {
                binaries.put(binarySpecInternal.getProjectScopedName(), binarySpecInternal);
            }
        }
    }

    static class BridgedBinaries {
        final List<ClassDirectoryBinarySpecInternal> binaries;

        public BridgedBinaries(List<ClassDirectoryBinarySpecInternal> binaries) {
            this.binaries = binaries;
        }
    }
}

