/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DefaultMavenDeployment
implements MavenDeployment {
    private Set<PublishArtifact> attachedArtifacts;
    private final PublishArtifact pomArtifact;
    private final PublishArtifact mainArtifact;

    public DefaultMavenDeployment(PublishArtifact pomArtifact, PublishArtifact mainArtifact, Iterable<? extends PublishArtifact> attachedArtifacts) {
        this.pomArtifact = pomArtifact;
        this.mainArtifact = mainArtifact;
        this.attachedArtifacts = Sets.newLinkedHashSet(attachedArtifacts);
    }

    @Override
    public void addArtifact(PublishArtifact artifact) {
        this.attachedArtifacts.add(artifact);
    }

    @Override
    public PublishArtifact getPomArtifact() {
        return this.pomArtifact;
    }

    @Override
    public Set<PublishArtifact> getArtifacts() {
        HashSet<PublishArtifact> artifacts = new HashSet<PublishArtifact>();
        artifacts.addAll(this.attachedArtifacts);
        if (this.mainArtifact != null) {
            artifacts.add(this.mainArtifact);
        }
        artifacts.add(this.pomArtifact);
        return artifacts;
    }

    @Override
    public PublishArtifact getMainArtifact() {
        return this.mainArtifact;
    }

    @Override
    public Set<PublishArtifact> getAttachedArtifacts() {
        return this.attachedArtifacts;
    }
}

