/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import groovy.lang.Closure;
import java.io.File;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportContainer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public class DefaultReportContainer<T extends Report>
extends DefaultNamedDomainObjectSet<T>
implements ReportContainer<T> {
    private static final Function<Report, String> REPORT_NAME = new Function<Report, String>(){

        public String apply(Report report) {
            return report.getName();
        }
    };
    private static final Function<Report, File> TO_FILE = new Function<Report, File>(){

        public File apply(Report report) {
            return report.getDestination();
        }
    };
    private static final Predicate<Report> IS_DIRECTORY_OUTPUT_TYPE = new Predicate<Report>(){

        public boolean apply(Report report) {
            return report.getOutputType() == Report.OutputType.DIRECTORY;
        }
    };
    private static final Action<Void> IMMUTABLE_VIOLATION_EXCEPTION = new Action<Void>(){

        @Override
        public void execute(Void arg) {
            throw new ReportContainer.ImmutableViolationException();
        }
    };
    private NamedDomainObjectSet<T> enabled = this.matching(new Spec<T>(){

        @Override
        public boolean isSatisfiedBy(T element) {
            return element.isEnabled();
        }
    });

    public DefaultReportContainer(Class<? extends T> type, Instantiator instantiator) {
        super(type, instantiator, Report.NAMER);
        this.beforeChange(IMMUTABLE_VIOLATION_EXCEPTION);
    }

    @Override
    public NamedDomainObjectSet<T> getEnabled() {
        return this.enabled;
    }

    @Override
    public ReportContainer<T> configure(Closure cl) {
        ConfigureUtil.configureSelf(cl, this);
        return this;
    }

    public T getFirstEnabled() {
        SortedMap map = this.enabled.getAsMap();
        if (map.isEmpty()) {
            return null;
        }
        return (T)((Report)map.get(map.firstKey()));
    }

    protected <N extends T> N add(Class<N> clazz, Object ... constructionArgs) {
        Report report = (Report)this.getInstantiator().newInstance(clazz, constructionArgs);
        if (report.getName().equals("enabled")) {
            throw new InvalidUserDataException("Reports that are part of a ReportContainer cannot be named 'enabled'");
        }
        this.getStore().add(report);
        this.index();
        return (N)report;
    }

    @Override
    public Map<String, File> getEnabledDirectoryReportDestinations() {
        return Maps.transformValues((Map)Maps.uniqueIndex((Iterable)Iterables.filter(this.getEnabled(), IS_DIRECTORY_OUTPUT_TYPE), REPORT_NAME), TO_FILE);
    }

    @Override
    public Map<String, File> getEnabledFileReportDestinations() {
        return Maps.transformValues((Map)Maps.uniqueIndex((Iterable)Iterables.filter(this.getEnabled(), (Predicate)Predicates.not(IS_DIRECTORY_OUTPUT_TYPE)), REPORT_NAME), TO_FILE);
    }

    @Override
    public SortedSet<String> getEnabledReportNames() {
        return Sets.newTreeSet((Iterable)Iterables.transform(this.getEnabled(), REPORT_NAME));
    }
}

