/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.OrSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.internal.ClosureSpec;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Specs {
    public static final Spec<Object> SATISFIES_ALL = new Spec<Object>(){

        @Override
        public boolean isSatisfiedBy(Object element) {
            return true;
        }
    };
    public static final Spec<Object> SATISFIES_NONE = new Spec<Object>(){

        @Override
        public boolean isSatisfiedBy(Object element) {
            return false;
        }
    };

    public static <T> Spec<T> satisfyAll() {
        return (Spec)Cast.uncheckedCast(SATISFIES_ALL);
    }

    public static <T> Spec<T> satisfyNone() {
        return (Spec)Cast.uncheckedCast(SATISFIES_NONE);
    }

    public static <T> Spec<T> convertClosureToSpec(Closure closure) {
        return new ClosureSpec(closure);
    }

    public static <T> Spec<T> intersect(Spec<? super T> ... specs) {
        if (specs.length == 0) {
            return Specs.satisfyAll();
        }
        if (specs.length == 1) {
            return (Spec)Cast.uncheckedCast(specs[0]);
        }
        return Specs.doIntersect(Arrays.asList(specs));
    }

    public static <T> Spec<T> intersect(Collection<? extends Spec<? super T>> specs) {
        if (specs.size() == 0) {
            return Specs.satisfyAll();
        }
        return Specs.doIntersect(specs);
    }

    private static <T> Spec<T> doIntersect(Collection<? extends Spec<? super T>> specs) {
        ArrayList<Spec<T>> filtered = new ArrayList<Spec<T>>(specs.size());
        for (Spec<T> spec : specs) {
            if (spec == SATISFIES_NONE) {
                return Specs.satisfyNone();
            }
            if (spec == SATISFIES_ALL) continue;
            filtered.add(spec);
        }
        if (filtered.size() == 0) {
            return Specs.satisfyAll();
        }
        if (filtered.size() == 1) {
            return (Spec)Cast.uncheckedCast(filtered.get(0));
        }
        return new AndSpec(filtered);
    }

    public static <T> Spec<T> union(Spec<? super T> ... specs) {
        if (specs.length == 0) {
            return Specs.satisfyAll();
        }
        if (specs.length == 1) {
            return (Spec)Cast.uncheckedCast(specs[0]);
        }
        return Specs.doUnion(Arrays.asList(specs));
    }

    public static <T> Spec<T> union(Collection<? extends Spec<? super T>> specs) {
        if (specs.size() == 0) {
            return Specs.satisfyAll();
        }
        return Specs.doUnion(specs);
    }

    private static <T> Spec<T> doUnion(Collection<? extends Spec<? super T>> specs) {
        ArrayList<Spec<T>> filtered = new ArrayList<Spec<T>>(specs.size());
        for (Spec<T> spec : specs) {
            if (spec == SATISFIES_ALL) {
                return Specs.satisfyAll();
            }
            if (spec == SATISFIES_NONE) continue;
            filtered.add(spec);
        }
        if (filtered.size() == 0) {
            return Specs.satisfyNone();
        }
        if (filtered.size() == 1) {
            return (Spec)Cast.uncheckedCast(filtered.get(0));
        }
        return new OrSpec(filtered);
    }

    public static <T> Spec<T> negate(Spec<? super T> spec) {
        if (spec == SATISFIES_ALL) {
            return Specs.satisfyNone();
        }
        if (spec == SATISFIES_NONE) {
            return Specs.satisfyAll();
        }
        if (spec instanceof NotSpec) {
            NotSpec notSpec = (NotSpec)spec;
            return (Spec)Cast.uncheckedCast(notSpec.getSourceSpec());
        }
        return new NotSpec<T>(spec);
    }
}

