/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecTask<T extends AbstractExecTask>
extends ConventionTask
implements ExecSpec {
    private final Class<T> taskType;
    private ExecAction execAction = this.getExecActionFactory().newExecAction();
    private ExecResult execResult;

    public AbstractExecTask(Class<T> taskType) {
        this.taskType = taskType;
    }

    @Inject
    protected ExecActionFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void exec() {
        this.execResult = this.execAction.execute();
    }

    public T commandLine(Object ... arguments) {
        this.execAction.commandLine(arguments);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T commandLine(Iterable<?> args) {
        this.execAction.commandLine(args);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T args(Object ... args) {
        this.execAction.args(args);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T args(Iterable<?> args) {
        this.execAction.args(args);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T setArgs(List<String> arguments) {
        this.execAction.setArgs(arguments);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T setArgs(Iterable<?> arguments) {
        this.execAction.setArgs(arguments);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Optional
    @Input
    public List<String> getArgs() {
        return this.execAction.getArgs();
    }

    @Override
    @Internal
    public List<String> getCommandLine() {
        return this.execAction.getCommandLine();
    }

    @Override
    public void setCommandLine(List<String> args) {
        this.execAction.setCommandLine(args);
    }

    @Override
    public void setCommandLine(Iterable<?> args) {
        this.execAction.setCommandLine(args);
    }

    @Override
    public void setCommandLine(Object ... args) {
        this.execAction.setCommandLine(args);
    }

    @Override
    @Optional
    @Input
    public String getExecutable() {
        return this.execAction.getExecutable();
    }

    @Override
    public void setExecutable(String executable) {
        this.execAction.setExecutable(executable);
    }

    @Override
    public void setExecutable(Object executable) {
        this.execAction.setExecutable(executable);
    }

    public T executable(Object executable) {
        this.execAction.executable(executable);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public File getWorkingDir() {
        return this.execAction.getWorkingDir();
    }

    @Override
    public void setWorkingDir(File dir) {
        this.execAction.setWorkingDir(dir);
    }

    @Override
    public void setWorkingDir(Object dir) {
        this.execAction.setWorkingDir(dir);
    }

    public T workingDir(Object dir) {
        this.execAction.workingDir(dir);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public Map<String, Object> getEnvironment() {
        return this.execAction.getEnvironment();
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.execAction.setEnvironment(environmentVariables);
    }

    public T environment(String name, Object value) {
        this.execAction.environment(name, value);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T environment(Map<String, ?> environmentVariables) {
        this.execAction.environment(environmentVariables);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T copyTo(ProcessForkOptions target) {
        this.execAction.copyTo(target);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    public T setStandardInput(InputStream inputStream) {
        this.execAction.setStandardInput(inputStream);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public InputStream getStandardInput() {
        return this.execAction.getStandardInput();
    }

    public T setStandardOutput(OutputStream outputStream) {
        this.execAction.setStandardOutput(outputStream);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public OutputStream getStandardOutput() {
        return this.execAction.getStandardOutput();
    }

    public T setErrorOutput(OutputStream outputStream) {
        this.execAction.setErrorOutput(outputStream);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Internal
    public OutputStream getErrorOutput() {
        return this.execAction.getErrorOutput();
    }

    public T setIgnoreExitValue(boolean ignoreExitValue) {
        this.execAction.setIgnoreExitValue(ignoreExitValue);
        return (T)((AbstractExecTask)this.taskType.cast(this));
    }

    @Override
    @Input
    public boolean isIgnoreExitValue() {
        return this.execAction.isIgnoreExitValue();
    }

    void setExecAction(ExecAction execAction) {
        this.execAction = execAction;
    }

    @Internal
    public ExecResult getExecResult() {
        return this.execResult;
    }
}

