/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.RegisteredProject;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class IncludedBuildDependencyMetadataBuilder {
    public Map<ProjectComponentIdentifier, RegisteredProject> build(IncludedBuildInternal build) {
        HashMap registeredProjects = Maps.newHashMap();
        GradleInternal gradle = build.getConfiguredBuild();
        for (Project project : gradle.getRootProject().getAllprojects()) {
            this.registerProject(registeredProjects, build, (ProjectInternal)project);
        }
        return registeredProjects;
    }

    private void registerProject(Map<ProjectComponentIdentifier, RegisteredProject> registeredProjects, IncludedBuild build, ProjectInternal project) {
        LocalComponentRegistry localComponentRegistry = project.getServices().get(LocalComponentRegistry.class);
        ProjectComponentIdentifier originalIdentifier = DefaultProjectComponentIdentifier.newProjectId(project);
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(originalIdentifier);
        ProjectComponentIdentifier componentIdentifier = DefaultProjectComponentIdentifier.newProjectId(build, project.getPath());
        LocalComponentMetadata compositeComponent = this.createCompositeCopy(build, componentIdentifier, originalComponent);
        ArrayList artifacts = Lists.newArrayList();
        for (LocalComponentArtifactMetadata artifactMetaData : localComponentRegistry.getAdditionalArtifacts(originalIdentifier)) {
            artifacts.add(this.createCompositeCopy(componentIdentifier, artifactMetaData));
        }
        registeredProjects.put(componentIdentifier, new RegisteredProject(compositeComponent, artifacts));
    }

    private LocalComponentMetadata createCompositeCopy(final IncludedBuild build, final ProjectComponentIdentifier componentIdentifier, DefaultLocalComponentMetadata originalComponentMetadata) {
        return originalComponentMetadata.copy(componentIdentifier, new Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>(){

            @Override
            public LocalComponentArtifactMetadata transform(LocalComponentArtifactMetadata originalArtifact) {
                File artifactFile = originalArtifact.getFile();
                Set targetTasks = IncludedBuildDependencyMetadataBuilder.this.getArtifactTasks(originalArtifact);
                return new CompositeProjectComponentArtifactMetadata(componentIdentifier, originalArtifact.getName(), artifactFile, targetTasks);
            }
        }, new Transformer<LocalOriginDependencyMetadata, LocalOriginDependencyMetadata>(){

            @Override
            public LocalOriginDependencyMetadata transform(LocalOriginDependencyMetadata originalDependency) {
                if (originalDependency.getSelector() instanceof ProjectComponentSelector) {
                    ProjectComponentSelector requested = (ProjectComponentSelector)originalDependency.getSelector();
                    return originalDependency.withTarget(DefaultProjectComponentSelector.newSelector(build, requested));
                }
                return originalDependency;
            }
        });
    }

    private LocalComponentArtifactMetadata createCompositeCopy(ProjectComponentIdentifier project, LocalComponentArtifactMetadata artifactMetaData) {
        File artifactFile = artifactMetaData.getFile();
        return new CompositeProjectComponentArtifactMetadata(project, artifactMetaData.getName(), artifactFile, this.getArtifactTasks(artifactMetaData));
    }

    private Set<String> getArtifactTasks(ComponentArtifactMetadata artifactMetaData) {
        LinkedHashSet taskPaths = Sets.newLinkedHashSet();
        Set<? extends Task> tasks = artifactMetaData.getBuildDependencies().getDependencies(null);
        for (Task task : tasks) {
            taskPaths.add(task.getPath());
        }
        return taskPaths;
    }
}

