/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.plugins;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioExtension;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.tasks.GenerateFiltersFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateProjectFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateSolutionFileTask;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.plugins.NativeComponentModelPlugin;
import org.gradle.platform.base.BinaryContainer;

@Incubating
public class VisualStudioPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(NativeComponentModelPlugin.class);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        public static VisualStudioExtensionInternal visualStudio(ServiceRegistry serviceRegistry, ProjectIdentifier projectIdentifier) {
            Instantiator instantiator = serviceRegistry.get(Instantiator.class);
            ProjectModelResolver projectModelResolver = serviceRegistry.get(ProjectModelResolver.class);
            FileResolver fileResolver = serviceRegistry.get(FileResolver.class);
            return instantiator.newInstance(DefaultVisualStudioExtension.class, projectIdentifier, instantiator, projectModelResolver, fileResolver);
        }

        @Mutate
        public static void includeBuildFileInProject(VisualStudioExtensionInternal visualStudio, final ProjectIdentifier projectIdentifier) {
            visualStudio.getProjects().all((Action<? extends VisualStudioProject>)new Action<VisualStudioProject>(){

                @Override
                public void execute(VisualStudioProject project) {
                    if (projectIdentifier.getBuildFile() != null) {
                        ((DefaultVisualStudioProject)project).addSourceFile(projectIdentifier.getBuildFile());
                    }
                }
            });
        }

        @Mutate
        public static void createVisualStudioModelForBinaries(VisualStudioExtensionInternal visualStudioExtension, BinaryContainer binaries) {
            for (NativeBinarySpec binary : binaries.withType(NativeBinarySpec.class)) {
                VisualStudioProjectConfiguration configuration = visualStudioExtension.getProjectRegistry().addProjectConfiguration(binary);
                if (!binary.isBuildable()) continue;
                DefaultVisualStudioProject visualStudioProject = configuration.getProject();
                visualStudioExtension.getSolutionRegistry().addSolution(visualStudioProject);
            }
        }

        @Mutate
        public static void createTasksForVisualStudio(TaskContainer tasks, VisualStudioExtensionInternal visualStudioExtension) {
            for (VisualStudioProject visualStudioProject : visualStudioExtension.getProjects()) {
                visualStudioProject.builtBy(Rules.createProjectsFileTask(tasks, visualStudioProject));
                visualStudioProject.builtBy(Rules.createFiltersFileTask(tasks, visualStudioProject));
            }
            for (VisualStudioSolution visualStudioSolution : visualStudioExtension.getSolutions()) {
                Task solutionTask = tasks.create(visualStudioSolution.getName() + "VisualStudio");
                solutionTask.setDescription("Generates the '" + visualStudioSolution.getName() + "' Visual Studio solution file.");
                visualStudioSolution.setBuildTask(solutionTask);
                visualStudioSolution.builtBy(Rules.createSolutionTask(tasks, visualStudioSolution));
                NativeComponentSpec component = visualStudioSolution.getComponent();
                Task lifecycleTask = (Task)tasks.maybeCreate(component.getName() + "VisualStudio");
                lifecycleTask.dependsOn(visualStudioSolution);
                lifecycleTask.setGroup("IDE");
                lifecycleTask.setDescription("Generates the Visual Studio solution for " + component + ".");
            }
            Rules.addCleanTask(tasks);
        }

        private static void addCleanTask(TaskContainer tasks) {
            Delete cleanTask = tasks.create("cleanVisualStudio", Delete.class);
            for (Task task : tasks.withType(GenerateSolutionFileTask.class)) {
                cleanTask.delete(task.getOutputs().getFiles());
            }
            for (Task task : tasks.withType(GenerateFiltersFileTask.class)) {
                cleanTask.delete(task.getOutputs().getFiles());
            }
            for (Task task : tasks.withType(GenerateProjectFileTask.class)) {
                cleanTask.delete(task.getOutputs().getFiles());
            }
            cleanTask.setGroup("IDE");
            cleanTask.setDescription("Removes all generated Visual Studio project and solution files");
        }

        private static Task createSolutionTask(TaskContainer tasks, VisualStudioSolution solution) {
            GenerateSolutionFileTask solutionFileTask = tasks.create(solution.getName() + "VisualStudioSolution", GenerateSolutionFileTask.class);
            solutionFileTask.setVisualStudioSolution(solution);
            return solutionFileTask;
        }

        private static Task createProjectsFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
            GenerateProjectFileTask task = tasks.create(vsProject.getName() + "VisualStudioProject", GenerateProjectFileTask.class);
            task.setVisualStudioProject(vsProject);
            task.initGradleCommand();
            return task;
        }

        private static Task createFiltersFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
            GenerateFiltersFileTask task = tasks.create(vsProject.getName() + "VisualStudioFilters", GenerateFiltersFileTask.class);
            task.setVisualStudioProject(vsProject);
            return task;
        }
    }
}

