/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal;

import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.Provider;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;

public class XcodeTarget
implements Named {
    private final String id;
    private final String name;
    private final ConfigurableFileCollection headerSearchPaths;
    private final ConfigurableFileCollection compileModules;
    private final ConfigurableFileCollection sources;
    private String taskName;
    private String gradleCommand;
    private final Provider<FileSystemLocation> debugOutputFile;
    private final Provider<FileSystemLocation> releaseOutputFile;
    private PBXTarget.ProductType productType;
    private String productName;
    private String outputFileType;

    @Inject
    public XcodeTarget(String name, String id, FileOperations fileOperations, Provider<FileSystemLocation> debugOutputFile, Provider<FileSystemLocation> releaseOutputFile) {
        this.name = name;
        this.id = id;
        this.sources = fileOperations.files(new Object[0]);
        this.headerSearchPaths = fileOperations.files(new Object[0]);
        this.compileModules = fileOperations.files(new Object[0]);
        this.debugOutputFile = debugOutputFile;
        this.releaseOutputFile = releaseOutputFile;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Provider<FileSystemLocation> getDebugOutputFile() {
        return this.debugOutputFile;
    }

    public Provider<FileSystemLocation> getReleaseOutputFile() {
        return this.releaseOutputFile;
    }

    public String getOutputFileType() {
        return this.outputFileType;
    }

    public void setOutputFileType(String outputFileType) {
        this.outputFileType = outputFileType;
    }

    public PBXTarget.ProductType getProductType() {
        return this.productType;
    }

    public void setProductType(PBXTarget.ProductType productType) {
        this.productType = productType;
    }

    public boolean isRunnable() {
        return PBXTarget.ProductType.TOOL.equals((Object)this.getProductType());
    }

    public boolean isUnitTest() {
        return PBXTarget.ProductType.UNIT_TEST.equals((Object)this.getProductType());
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getGradleCommand() {
        return this.gradleCommand;
    }

    public void setGradleCommand(String gradleCommand) {
        this.gradleCommand = gradleCommand;
    }

    public ConfigurableFileCollection getSources() {
        return this.sources;
    }

    public ConfigurableFileCollection getHeaderSearchPaths() {
        return this.headerSearchPaths;
    }

    public ConfigurableFileCollection getCompileModules() {
        return this.compileModules;
    }
}

