/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class DefaultExclude
implements Exclude {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName artifact;
    private final Set<String> configurations;
    private final String patternMatcher;

    public DefaultExclude(ModuleIdentifier id, String artifact, String type, String extension, String[] configurations, String patternMatcher) {
        this.moduleId = id;
        this.artifact = new DefaultIvyArtifactName(artifact, type, extension);
        this.configurations = ImmutableSet.copyOf((Object[])configurations);
        this.patternMatcher = patternMatcher;
    }

    public DefaultExclude(ModuleIdentifier id, String[] configurations, String patternMatcher) {
        this.moduleId = id;
        this.artifact = new DefaultIvyArtifactName("*", "*", "*");
        this.configurations = ImmutableSet.copyOf((Object[])configurations);
        this.patternMatcher = patternMatcher;
    }

    public DefaultExclude(ModuleIdentifier id) {
        this.moduleId = id;
        this.artifact = new DefaultIvyArtifactName("*", "*", "*");
        this.configurations = ImmutableSet.of();
        this.patternMatcher = "exact";
    }

    public String toString() {
        return "{exclude moduleId: " + this.moduleId + ", artifact: " + this.artifact + "}";
    }

    @Override
    public ModuleIdentifier getModuleId() {
        return this.moduleId;
    }

    @Override
    public IvyArtifactName getArtifact() {
        return this.artifact;
    }

    @Override
    public Set<String> getConfigurations() {
        return this.configurations;
    }

    @Override
    public String getMatcher() {
        return this.patternMatcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExclude that = (DefaultExclude)o;
        if (!this.moduleId.equals(that.moduleId)) {
            return false;
        }
        if (!this.artifact.equals(that.artifact)) {
            return false;
        }
        if (!this.configurations.equals(that.configurations)) {
            return false;
        }
        return this.patternMatcher.equals(that.patternMatcher);
    }

    public int hashCode() {
        int result = this.moduleId.hashCode();
        result = 31 * result + this.artifact.hashCode();
        result = 31 * result + this.configurations.hashCode();
        result = 31 * result + this.patternMatcher.hashCode();
        return result;
    }
}

