/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super((OutputStream)Preconditions.checkNotNull((Object)out));
        this.hasher = (Hasher)Preconditions.checkNotNull((Object)hashFunction.newHasher());
    }

    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

