/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Message;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSerializerFactory {
    public static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    public static final Serializer<Boolean> BOOLEAN_SERIALIZER = new BooleanSerializer();
    public static final Serializer<Byte> BYTE_SERIALIZER = new ByteSerializer();
    public static final Serializer<Short> SHORT_SERIALIZER = new ShortSerializer();
    public static final Serializer<Integer> INTEGER_SERIALIZER = new IntegerSerializer();
    public static final Serializer<Long> LONG_SERIALIZER = new LongSerializer();
    public static final Serializer<Float> FLOAT_SERIALIZER = new FloatSerializer();
    public static final Serializer<Double> DOUBLE_SERIALIZER = new DoubleSerializer();
    public static final Serializer<File> FILE_SERIALIZER = new FileSerializer();
    public static final Serializer<byte[]> BYTE_ARRAY_SERIALIZER = new ByteArraySerializer();
    public static final Serializer<Map<String, String>> NO_NULL_STRING_MAP_SERIALIZER = new StringMapSerializer();
    public static final Serializer<Throwable> THROWABLE_SERIALIZER = new ThrowableSerializer();
    public static final Serializer<HashCode> HASHCODE_SERIALIZER = new HashCodeSerializer();

    public <T> Serializer<T> getSerializerFor(Class<T> type) {
        if (type.equals(String.class)) {
            return STRING_SERIALIZER;
        }
        if (type.equals(Long.class)) {
            return LONG_SERIALIZER;
        }
        if (type.equals(File.class)) {
            return FILE_SERIALIZER;
        }
        if (type.equals(byte[].class)) {
            return BYTE_ARRAY_SERIALIZER;
        }
        if (type.isEnum()) {
            return new EnumSerializer(type);
        }
        if (type.equals(Boolean.class)) {
            return BOOLEAN_SERIALIZER;
        }
        if (Throwable.class.isAssignableFrom(type)) {
            return THROWABLE_SERIALIZER;
        }
        if (HashCode.class.isAssignableFrom(type)) {
            return HASHCODE_SERIALIZER;
        }
        return new DefaultSerializer(type.getClassLoader());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThrowableSerializer
    extends AbstractSerializer<Throwable> {
        private ThrowableSerializer() {
        }

        @Override
        public Throwable read(Decoder decoder) throws Exception {
            return (Throwable)Message.receive(decoder.getInputStream(), this.getClass().getClassLoader());
        }

        @Override
        public void write(Encoder encoder, Throwable value) throws Exception {
            Message.send(value, encoder.getOutputStream());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleSerializer
    extends AbstractSerializer<Double> {
        private DoubleSerializer() {
        }

        @Override
        public Double read(Decoder decoder) throws Exception {
            byte[] bytes = new byte[8];
            decoder.readBytes(bytes);
            return ByteBuffer.wrap(bytes).getDouble();
        }

        @Override
        public void write(Encoder encoder, Double value) throws Exception {
            byte[] b = ByteBuffer.allocate(8).putDouble(value).array();
            encoder.writeBytes(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatSerializer
    extends AbstractSerializer<Float> {
        private FloatSerializer() {
        }

        @Override
        public Float read(Decoder decoder) throws Exception {
            byte[] bytes = new byte[4];
            decoder.readBytes(bytes);
            return Float.valueOf(ByteBuffer.wrap(bytes).getFloat());
        }

        @Override
        public void write(Encoder encoder, Float value) throws Exception {
            byte[] b = ByteBuffer.allocate(4).putFloat(value.floatValue()).array();
            encoder.writeBytes(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerSerializer
    extends AbstractSerializer<Integer> {
        private IntegerSerializer() {
        }

        @Override
        public Integer read(Decoder decoder) throws Exception {
            return decoder.readInt();
        }

        @Override
        public void write(Encoder encoder, Integer value) throws Exception {
            encoder.writeInt(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortSerializer
    extends AbstractSerializer<Short> {
        private ShortSerializer() {
        }

        @Override
        public Short read(Decoder decoder) throws Exception {
            return (short)decoder.readInt();
        }

        @Override
        public void write(Encoder encoder, Short value) throws Exception {
            encoder.writeInt(value.shortValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteSerializer
    extends AbstractSerializer<Byte> {
        private ByteSerializer() {
        }

        @Override
        public Byte read(Decoder decoder) throws Exception {
            return decoder.readByte();
        }

        @Override
        public void write(Encoder encoder, Byte value) throws Exception {
            encoder.writeByte(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanSerializer
    extends AbstractSerializer<Boolean> {
        private BooleanSerializer() {
        }

        @Override
        public Boolean read(Decoder decoder) throws Exception {
            return decoder.readBoolean();
        }

        @Override
        public void write(Encoder encoder, Boolean value) throws Exception {
            encoder.writeBoolean(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringMapSerializer
    extends AbstractSerializer<Map<String, String>> {
        private StringMapSerializer() {
        }

        @Override
        public Map<String, String> read(Decoder decoder) throws Exception {
            int pairs = decoder.readSmallInt();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < pairs; ++i) {
                builder.put((Object)decoder.readString(), (Object)decoder.readString());
            }
            return builder.build();
        }

        @Override
        public void write(Encoder encoder, Map<String, String> value) throws Exception {
            encoder.writeSmallInt(value.size());
            for (Map.Entry<String, String> entry : value.entrySet()) {
                encoder.writeString(entry.getKey());
                encoder.writeString(entry.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteArraySerializer
    extends AbstractSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public byte[] read(Decoder decoder) throws Exception {
            return decoder.readBinary();
        }

        @Override
        public void write(Encoder encoder, byte[] value) throws Exception {
            encoder.writeBinary(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSerializer
    extends AbstractSerializer<File> {
        private FileSerializer() {
        }

        @Override
        public File read(Decoder decoder) throws Exception {
            return new File(decoder.readString());
        }

        @Override
        public void write(Encoder encoder, File value) throws Exception {
            encoder.writeString(value.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringSerializer
    extends AbstractSerializer<String> {
        private StringSerializer() {
        }

        @Override
        public String read(Decoder decoder) throws Exception {
            return decoder.readString();
        }

        @Override
        public void write(Encoder encoder, String value) throws Exception {
            encoder.writeString(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongSerializer
    extends AbstractSerializer<Long> {
        private LongSerializer() {
        }

        @Override
        public Long read(Decoder decoder) throws Exception {
            return decoder.readLong();
        }

        @Override
        public void write(Encoder encoder, Long value) throws Exception {
            encoder.writeLong(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumSerializer<T extends Enum>
    extends AbstractSerializer<T> {
        private final Class<T> type;

        private EnumSerializer(Class<T> type) {
            this.type = type;
        }

        @Override
        public T read(Decoder decoder) throws Exception {
            return (T)((Enum[])this.type.getEnumConstants())[decoder.readSmallInt()];
        }

        @Override
        public void write(Encoder encoder, T value) throws Exception {
            encoder.writeSmallInt((byte)((Enum)value).ordinal());
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            EnumSerializer rhs = (EnumSerializer)obj;
            return Objects.equal(this.type, rhs.type);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.type});
        }
    }
}

