/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.RelevantMethods;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceMethod;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.internal.util.BiFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceRegistry
implements ServiceRegistry,
Closeable {
    private static final ServiceRegistry[] NO_PARENTS = new ServiceRegistry[0];
    private static final ServiceProvider[] NO_DEPENDENTS = new ServiceProvider[0];
    private static final Object[] NO_PARAMS = new Object[0];
    private static final ConcurrentMap<Type, BiFunction<ServiceProvider, LookupContext, Provider>> SERVICE_TYPE_PROVIDER_CACHE = new ConcurrentHashMap<Type, BiFunction<ServiceProvider, LookupContext, Provider>>();
    private final Map<Type, ServiceProvider> providerCache = new IdentityHashMap<Type, ServiceProvider>();
    private final Object lock = new Object();
    private final OwnServices ownServices;
    private final Provider allServices;
    private final Provider parentServices;
    private final String displayName;
    private boolean closed;
    private boolean mutable = true;
    private Provider asParentServicesProvider;

    public DefaultServiceRegistry() {
        this((String)null, NO_PARENTS);
    }

    public DefaultServiceRegistry(String displayName) {
        this(displayName, NO_PARENTS);
    }

    public DefaultServiceRegistry(ServiceRegistry ... parents) {
        this((String)null, parents);
    }

    public DefaultServiceRegistry(String displayName, ServiceRegistry ... parents) {
        this.displayName = displayName;
        this.ownServices = new OwnServices();
        if (parents.length == 0) {
            this.parentServices = null;
            this.allServices = CachingProvider.of(this.ownServices);
        } else {
            this.parentServices = DefaultServiceRegistry.setupParentServices(parents);
            this.allServices = new CompositeProvider(new Provider[]{CachingProvider.of(this.ownServices), this.parentServices});
        }
        this.findProviderMethods(this);
    }

    private static Provider setupParentServices(ServiceRegistry[] parents) {
        Provider parentServices;
        if (parents.length == 1) {
            parentServices = DefaultServiceRegistry.toParentServices(parents[0]);
        } else {
            Provider[] parentProviders = new Provider[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                parentProviders[i] = DefaultServiceRegistry.toParentServices(parents[i]);
            }
            parentServices = new CompositeProvider(parentProviders);
        }
        return parentServices;
    }

    private Provider asProvider() {
        if (this.asParentServicesProvider == null) {
            this.asParentServicesProvider = CachingProvider.of(new ParentServices(this));
        }
        return this.asParentServicesProvider;
    }

    private static Provider toParentServices(ServiceRegistry serviceRegistry) {
        if (serviceRegistry instanceof DefaultServiceRegistry) {
            return ((DefaultServiceRegistry)serviceRegistry).asProvider();
        }
        return new ParentServices(serviceRegistry);
    }

    public static ServiceRegistry create(Object ... providers) {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        for (Object provider : providers) {
            registry.addProvider(provider);
        }
        return registry;
    }

    private String getDisplayName() {
        return this.displayName == null ? this.getClass().getSimpleName() : this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private void findProviderMethods(Object target) {
        Class<?> type = target.getClass();
        RelevantMethods methods = RelevantMethods.getMethods(type);
        for (ServiceMethod method : methods.decorators) {
            if (this.parentServices == null) {
                throw new ServiceLookupException(String.format("Cannot use decorator method %s.%s() when no parent registry is provided.", type.getSimpleName(), method.getName()));
            }
            this.ownServices.add(new DecoratorMethodService(target, method));
        }
        for (ServiceMethod method : methods.factories) {
            this.ownServices.add(new FactoryMethodService(target, method));
        }
        for (ServiceMethod method : methods.configurers) {
            this.applyConfigureMethod(method, target);
        }
    }

    private void applyConfigureMethod(ServiceMethod method, Object target) {
        Object[] params = new Object[method.getParameterTypes().length];
        DefaultLookupContext context = new DefaultLookupContext();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Type paramType = method.getParameterTypes()[i];
            if (paramType.equals(ServiceRegistration.class)) {
                params[i] = this.newRegistration();
                continue;
            }
            ServiceProvider paramProvider = context.find(paramType, this.allServices);
            if (paramProvider == null) {
                throw new ServiceLookupException(String.format("Cannot configure services using %s.%s() as required service of type %s is not available.", method.getOwner().getSimpleName(), method.getName(), DefaultServiceRegistry.format(paramType)));
            }
            params[i] = paramProvider.get();
        }
        try {
            method.invoke(target, params);
        }
        catch (Exception e) {
            throw new ServiceLookupException(String.format("Could not configure services using %s.%s().", method.getOwner().getSimpleName(), method.getName()), e);
        }
    }

    public void register(Action<? super ServiceRegistration> action) {
        this.assertMutable();
        action.execute(this.newRegistration());
    }

    private void assertMutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Cannot add provide to service registry " + this + " as it is no longer mutable");
        }
    }

    private ServiceRegistration newRegistration() {
        return new ServiceRegistration(){

            @Override
            public <T> void add(Class<T> serviceType, T serviceInstance) {
                DefaultServiceRegistry.this.add(serviceType, serviceInstance);
            }

            @Override
            public void add(Class<?> serviceType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(serviceType));
            }

            @Override
            public void addProvider(Object provider) {
                DefaultServiceRegistry.this.addProvider(provider);
            }
        };
    }

    public <T> DefaultServiceRegistry add(Class<T> serviceType, T serviceInstance) {
        this.assertMutable();
        this.ownServices.add(new FixedInstanceService<T>(serviceType, serviceInstance));
        return this;
    }

    public DefaultServiceRegistry addProvider(Object provider) {
        this.assertMutable();
        this.findProviderMethods(provider);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                CompositeStoppable.stoppable(this.allServices).stop();
                Object var3_2 = null;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.closed = true;
                throw throwable;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private static String format(Type type) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            return aClass.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(DefaultServiceRegistry.format(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type typeParam = parameterizedType.getActualTypeArguments()[i];
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(DefaultServiceRegistry.format(typeParam));
            }
            builder.append(">");
            return builder.toString();
        }
        return type.toString();
    }

    @Override
    public boolean hasService(Class<?> serviceType) {
        DefaultServiceRegistry.assertValidServiceType(serviceType);
        return this.allServices.hasService(serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
        Object object = this.lock;
        synchronized (object) {
            this.mutable = false;
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
            }
            if (!this.hasService(serviceType)) {
                return Collections.emptyList();
            }
            ArrayList<ServiceProvider> providers = new ArrayList<ServiceProvider>();
            DefaultLookupContext context = new DefaultLookupContext();
            this.allServices.getAll(context, serviceType, providers);
            ArrayList<T> services = new ArrayList<T>(providers.size());
            for (ServiceProvider provider : providers) {
                services.add(serviceType.cast(provider.get()));
            }
            return services;
        }
    }

    @Override
    public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
        return serviceType.cast(this.doGet(serviceType));
    }

    @Override
    public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
        return this.doGet(serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doGet(Type serviceType) throws IllegalArgumentException {
        Object object = this.lock;
        synchronized (object) {
            this.mutable = false;
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
            }
            ServiceProvider provider = this.providerCache.get(serviceType);
            if (provider == null) {
                provider = this.getServiceProvider(serviceType);
                this.providerCache.put(serviceType, provider);
            }
            return provider.get();
        }
    }

    private ServiceProvider getServiceProvider(Type serviceType) {
        ServiceProvider provider;
        Type lookupType = DefaultServiceRegistry.extractServiceType(serviceType);
        ServiceProvider serviceProvider = provider = this.hasService(DefaultServiceRegistry.unwrap(lookupType)) ? new DefaultLookupContext().find(serviceType, this.allServices) : null;
        if (provider == null) {
            throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
        }
        return provider;
    }

    private static Type extractServiceType(Type mayBeFactoryType) {
        Type rawType;
        Type serviceType = mayBeFactoryType;
        if (mayBeFactoryType instanceof ParameterizedType && (rawType = ((ParameterizedType)mayBeFactoryType).getRawType()) == List.class) {
            serviceType = ((ParameterizedType)mayBeFactoryType).getActualTypeArguments()[0];
        }
        return serviceType;
    }

    @Override
    public <T> Factory<T> getFactory(Class<T> type) {
        Object object = this.lock;
        synchronized (object) {
            DefaultLookupContext context;
            ServiceProvider factory;
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate factory for objects of type %s, as %s has been closed.", DefaultServiceRegistry.format(type), this.getDisplayName()));
            }
            if (this.hasService(Factory.class) && (factory = this.allServices.getFactory(context = new DefaultLookupContext(), type)) != null) {
                return (Factory)factory.get();
            }
            throw new UnknownServiceException(type, String.format("No factory for objects of type %s available in %s.", DefaultServiceRegistry.format(type), this.getDisplayName()));
        }
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.getFactory(type).create();
    }

    private static Class<?> unwrap(Type type) {
        WildcardType wildcardType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof WildcardType && (wildcardType = (WildcardType)type).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
            return (Class)wildcardType.getUpperBounds()[0];
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return (Class)parameterizedType.getRawType();
    }

    private ServiceProvider getThisAsProvider() {
        return new ServiceProvider(){

            public String getDisplayName() {
                return "ServiceRegistry " + DefaultServiceRegistry.this.getDisplayName();
            }

            public Object get() {
                return DefaultServiceRegistry.this;
            }

            public void requiredBy(Provider provider) {
            }
        };
    }

    private static void assertValidServiceType(Class<?> serviceClass) {
        if (serviceClass.isArray()) {
            throw new ServiceValidationException("Locating services with array type is not supported.");
        }
        if (serviceClass.isAnnotation()) {
            throw new ServiceValidationException("Locating services with annotation type is not supported.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultLookupContext
    implements LookupContext {
        private final Set<Type> visiting = new HashSet<Type>();

        private DefaultLookupContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServiceProvider find(Type serviceType, Provider provider) {
            ServiceProvider serviceProvider;
            if (!this.visiting.add(serviceType)) {
                throw new ServiceValidationException(String.format("Cycle in dependencies of service of type %s.", DefaultServiceRegistry.format(serviceType)));
            }
            try {
                serviceProvider = this.getServiceProvider(serviceType, provider);
                Object var5_4 = null;
                this.visiting.remove(serviceType);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.visiting.remove(serviceType);
                throw throwable;
            }
            return serviceProvider;
        }

        public ServiceProvider getServiceProvider(Type serviceType, Provider provider) {
            BiFunction<ServiceProvider, LookupContext, Provider> function = (BiFunction<ServiceProvider, LookupContext, Provider>)SERVICE_TYPE_PROVIDER_CACHE.get(serviceType);
            if (function == null) {
                function = DefaultLookupContext.createServiceProviderFactory(serviceType);
                SERVICE_TYPE_PROVIDER_CACHE.putIfAbsent(serviceType, function);
            }
            return function.apply(this, provider);
        }

        private static BiFunction<ServiceProvider, LookupContext, Provider> createServiceProviderFactory(Type serviceType) {
            if (serviceType instanceof ParameterizedType) {
                WildcardType wildcardType;
                Type typeArg;
                ParameterizedType parameterizedType = (ParameterizedType)serviceType;
                Type rawType = parameterizedType.getRawType();
                if (rawType.equals(Factory.class)) {
                    typeArg = parameterizedType.getActualTypeArguments()[0];
                    if (typeArg instanceof Class) {
                        return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                            @Override
                            public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                                return provider.getFactory(lookupContext, (Class)typeArg);
                            }
                        };
                    }
                    if (typeArg instanceof WildcardType) {
                        wildcardType = (WildcardType)typeArg;
                        if (wildcardType.getLowerBounds().length == 1 && wildcardType.getUpperBounds().length == 1 && wildcardType.getLowerBounds()[0] instanceof Class && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                            return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                                @Override
                                public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                                    return provider.getFactory(lookupContext, (Class)wildcardType.getLowerBounds()[0]);
                                }
                            };
                        }
                        if (wildcardType.getLowerBounds().length == 0 && wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] instanceof Class) {
                            return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                                @Override
                                public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                                    return provider.getFactory(lookupContext, (Class)wildcardType.getUpperBounds()[0]);
                                }
                            };
                        }
                    }
                }
                if (rawType instanceof Class && ((Class)rawType).isAssignableFrom(List.class)) {
                    typeArg = parameterizedType.getActualTypeArguments()[0];
                    if (typeArg instanceof Class) {
                        return new ServicesWithTypeLookup((Class)typeArg);
                    }
                    if (typeArg instanceof WildcardType && (wildcardType = (WildcardType)typeArg).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
                        return new ServicesWithTypeLookup((Class)wildcardType.getUpperBounds()[0]);
                    }
                }
            }
            final TypeSpec serviceTypeSpec = DefaultLookupContext.toSpec(serviceType);
            return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                @Override
                public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                    return provider.getService(lookupContext, serviceTypeSpec);
                }
            };
        }

        static TypeSpec toSpec(Type serviceType) {
            if (serviceType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)serviceType;
                ArrayList<TypeSpec> paramSpecs = new ArrayList<TypeSpec>();
                for (Type paramType : parameterizedType.getActualTypeArguments()) {
                    paramSpecs.add(DefaultLookupContext.toSpec(paramType));
                }
                return new ParameterizedTypeSpec(serviceType, DefaultLookupContext.toSpec(parameterizedType.getRawType()), paramSpecs);
            }
            if (serviceType instanceof Class) {
                Class serviceClass = (Class)serviceType;
                DefaultServiceRegistry.assertValidServiceType(serviceClass);
                return new ClassSpec(serviceClass);
            }
            throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(serviceType)));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ServicesWithTypeLookup
        implements BiFunction<ServiceProvider, LookupContext, Provider> {
            private final Class<?> elementClass;

            ServicesWithTypeLookup(Class<?> elementClass) {
                this.elementClass = elementClass;
            }

            @Override
            public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                ArrayList<ServiceProvider> providers = new ArrayList<ServiceProvider>();
                provider.getAll(lookupContext, this.elementClass, providers);
                ArrayList<Object> services = new ArrayList<Object>(providers.size());
                for (ServiceProvider serviceProvider : providers) {
                    services.add(serviceProvider.get());
                }
                return new CollectionServiceProvider(this.elementClass, services, providers);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CollectionServiceProvider
        implements ServiceProvider {
            private final Type typeArg;
            private final List<Object> services;
            private final List<ServiceProvider> providers;

            public CollectionServiceProvider(Type typeArg, List<Object> services, List<ServiceProvider> providers) {
                this.typeArg = typeArg;
                this.services = services;
                this.providers = providers;
            }

            @Override
            public String getDisplayName() {
                return "services with type " + this.typeArg;
            }

            @Override
            public Object get() {
                return this.services;
            }

            @Override
            public void requiredBy(Provider provider) {
                for (ServiceProvider serviceProvider : this.providers) {
                    serviceProvider.requiredBy(provider);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterizedTypeSpec
    implements TypeSpec {
        private final Type type;
        private final TypeSpec rawType;
        private final List<TypeSpec> paramSpecs;

        private ParameterizedTypeSpec(Type type, TypeSpec rawType, List<TypeSpec> paramSpecs) {
            this.type = type;
            this.rawType = rawType;
            this.paramSpecs = paramSpecs;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isSatisfiedBy(Type element) {
            if (element instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)element;
                if (!this.rawType.isSatisfiedBy(parameterizedType.getRawType())) {
                    return false;
                }
                for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                    Type type = parameterizedType.getActualTypeArguments()[i];
                    if (this.paramSpecs.get(i).isSatisfiedBy(type)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterizedTypeSpec that = (ParameterizedTypeSpec)o;
            if (!this.type.equals(that.type)) {
                return false;
            }
            if (!this.rawType.equals(that.rawType)) {
                return false;
            }
            return this.paramSpecs.equals(that.paramSpecs);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.rawType.hashCode();
            result = 31 * result + this.paramSpecs.hashCode();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassSpec
    implements TypeSpec {
        private final Class<?> type;

        private ClassSpec(Class<?> type) {
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isSatisfiedBy(Type element) {
            if (element instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)element;
                if (parameterizedType.getRawType() instanceof Class) {
                    return this.type.isAssignableFrom((Class)parameterizedType.getRawType());
                }
            } else if (element instanceof Class) {
                Class other = (Class)element;
                return this.type.isAssignableFrom(other);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassSpec classSpec = (ClassSpec)o;
            return this.type != null ? this.type.equals(classSpec.type) : classSpec.type == null;
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface TypeSpec
    extends Spec<Type> {
        public Type getType();
    }

    static interface LookupContext {
        @Nullable
        public ServiceProvider find(Type var1, Provider var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentServices
    implements Provider {
        private final ServiceRegistry parent;

        private ParentServices(ServiceRegistry parent) {
            this.parent = parent;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            try {
                Factory<?> factory = this.parent.getFactory(type);
                assert (factory != null) : String.format("parent returned null for factory type '%s'", type.getName());
                return this.wrap(factory);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(type)) {
                    throw e;
                }
                return null;
            }
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            try {
                Object service = this.parent.get(serviceType.getType());
                assert (service != null) : String.format("parent returned null for service type %s", DefaultServiceRegistry.access$700(serviceType.getType()));
                return this.wrap(service);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(serviceType.getType())) {
                    throw e;
                }
                return null;
            }
        }

        private ServiceProvider wrap(final Object instance) {
            return new ServiceProvider(){

                public String getDisplayName() {
                    return "ServiceRegistry " + ParentServices.this.parent;
                }

                public Object get() {
                    return instance;
                }

                public void requiredBy(Provider provider) {
                }
            };
        }

        @Override
        public void getAll(LookupContext context, Class<?> serviceType, List<ServiceProvider> result) {
            List<?> services = this.parent.getAll(serviceType);
            assert (services != null) : String.format("parent returned null for services of type %s", DefaultServiceRegistry.access$700(serviceType));
            for (Object service : services) {
                result.add(this.wrap(service));
            }
        }

        @Override
        public boolean hasService(Class<?> type) {
            return this.parent.hasService(type);
        }

        @Override
        public void stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeProvider
    implements Provider {
        private final Provider[] providers;

        private CompositeProvider(Provider ... providers) {
            this.providers = providers;
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            if (this.hasService(DefaultServiceRegistry.unwrap(DefaultServiceRegistry.extractServiceType(serviceType.getType())))) {
                for (Provider provider : this.providers) {
                    ServiceProvider service = provider.getService(context, serviceType);
                    if (service == null) continue;
                    return service;
                }
            }
            return null;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            if (this.hasService(Factory.class)) {
                for (Provider provider : this.providers) {
                    ServiceProvider factory = provider.getFactory(context, type);
                    if (factory == null) continue;
                    return factory;
                }
            }
            return null;
        }

        @Override
        public void getAll(LookupContext context, Class<?> serviceType, List<ServiceProvider> result) {
            if (this.hasService(serviceType)) {
                for (Provider provider : this.providers) {
                    provider.getAll(context, serviceType, result);
                }
            }
        }

        @Override
        public boolean hasService(Class<?> type) {
            for (Provider provider : this.providers) {
                if (!provider.hasService(type)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                CompositeStoppable.stoppable(Arrays.asList(this.providers)).stop();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                for (int i = 0; i < this.providers.length; ++i) {
                    this.providers[i] = null;
                }
                throw throwable;
            }
            for (int i = 0; i < this.providers.length; ++i) {
                this.providers[i] = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingProvider
    implements Provider {
        private static final Object ABSENT = new Object();
        private final ConcurrentMap<Object, Object> seen = new ConcurrentHashMap<Object, Object>();
        private final ConcurrentMap<Class<?>, List<ServiceProvider>> allServicesCache = new ConcurrentHashMap();
        private final Map<Class<?>, Boolean> serviceTypes = new ConcurrentHashMap();
        private final Provider delegate;

        private CachingProvider(Provider delegate) {
            this.delegate = delegate;
        }

        private static Provider of(Provider delegate) {
            if (delegate instanceof CachingProvider) {
                return delegate;
            }
            return new CachingProvider(delegate);
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            Object cached = this.seen.get(serviceType);
            if (cached != null) {
                return cached == ABSENT ? null : (ServiceProvider)cached;
            }
            ServiceProvider service = this.delegate.getService(context, serviceType);
            return this.cacheServiceProvider(serviceType, service);
        }

        private ServiceProvider cacheServiceProvider(Object key, ServiceProvider service) {
            this.seen.putIfAbsent(key, service == null ? ABSENT : service);
            return service;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            Object cached = this.seen.get(type);
            if (cached != null) {
                return cached == ABSENT ? null : (ServiceProvider)cached;
            }
            ServiceProvider service = this.delegate.getFactory(context, type);
            return this.cacheServiceProvider(type, service);
        }

        @Override
        public void getAll(LookupContext context, Class<?> serviceType, List<ServiceProvider> result) {
            List services = (List)this.allServicesCache.get(serviceType);
            if (services != null) {
                result.addAll(services);
                return;
            }
            ArrayList<ServiceProvider> tmp = new ArrayList<ServiceProvider>();
            this.delegate.getAll(context, serviceType, tmp);
            this.allServicesCache.putIfAbsent(serviceType, tmp);
            if (!tmp.isEmpty()) {
                result.addAll(tmp);
            }
        }

        @Override
        public boolean hasService(Class<?> type) {
            Boolean val = this.serviceTypes.get(type);
            if (val != null) {
                return val;
            }
            val = this.delegate.hasService(type);
            this.serviceTypes.put(type, val);
            return val;
        }

        @Override
        public void stop() {
            this.delegate.stop();
            this.seen.clear();
            this.allServicesCache.clear();
        }
    }

    private class DecoratorMethodService
    extends SingletonService {
        private final ServiceMethod method;
        private Object target;
        private ServiceProvider paramProvider;

        public DecoratorMethodService(Object target, ServiceMethod method) {
            super(method.getServiceType());
            this.target = target;
            this.method = method;
        }

        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.method.getServiceType()) + " at " + this.method.getOwner().getSimpleName() + "." + this.method.getName() + "()";
        }

        protected void bind(LookupContext context) {
            Type paramType = this.method.getParameterTypes()[0];
            DefaultLookupContext parentLookupContext = new DefaultLookupContext();
            this.paramProvider = parentLookupContext.find(paramType, DefaultServiceRegistry.this.parentServices);
            if (this.paramProvider == null) {
                throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available in parent registries.", DefaultServiceRegistry.format(this.method.getServiceType()), this.method.getOwner().getSimpleName(), this.method.getName(), DefaultServiceRegistry.format(paramType)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object create() {
            Object result;
            Object param = this.paramProvider.get();
            try {
                result = this.method.invoke(this.target, param);
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.method.getServiceType()), this.method.getOwner().getSimpleName(), this.method.getName()), e);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.method.getServiceType()), this.method.getOwner().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                Object var5_5 = null;
                this.paramProvider = null;
                this.target = null;
                return object;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.paramProvider = null;
                this.target = null;
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorService
    extends FactoryService {
        private final Constructor<?> constructor;

        private ConstructorService(Class<?> serviceType) {
            super(serviceType);
            Constructor<?>[] constructors = serviceType.getDeclaredConstructors();
            if (constructors.length != 1) {
                throw new ServiceValidationException(String.format("Expected a single constructor for %s.", DefaultServiceRegistry.format(serviceType)));
            }
            this.constructor = constructors[0];
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        protected Member getFactory() {
            return this.constructor;
        }

        @Override
        protected Object invokeMethod(Object[] params) {
            try {
                return this.constructor.newInstance(params);
            }
            catch (InvocationTargetException e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e.getCause());
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e);
            }
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedInstanceService<T>
    extends SingletonService {
        public FixedInstanceService(Class<T> serviceType, T serviceInstance) {
            super(serviceType);
            this.setInstance(serviceInstance);
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType) + " with implementation " + this.getInstance();
        }

        @Override
        protected Object create() {
            throw new UnsupportedOperationException();
        }
    }

    private class FactoryMethodService
    extends FactoryService {
        private final ServiceMethod method;
        private Object target;

        public FactoryMethodService(Object target, ServiceMethod method) {
            super(method.getServiceType());
            this.target = target;
            this.method = method;
        }

        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.method.getServiceType()) + " at " + this.method.getOwner().getSimpleName() + "." + this.method.getName() + "()";
        }

        protected Type[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        protected Member getFactory() {
            return this.method.getMethod();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object invokeMethod(Object[] params) {
            Object result;
            try {
                result = this.method.invoke(this.target, params);
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.serviceType), this.method.getOwner().getSimpleName(), this.method.getName()), e);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.serviceType), this.method.getOwner().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                Object var5_5 = null;
                this.target = null;
                return object;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.target = null;
                throw throwable;
            }
        }
    }

    private abstract class FactoryService
    extends SingletonService {
        private ServiceProvider[] paramProviders;

        protected FactoryService(Type serviceType) {
            super(serviceType);
        }

        protected abstract Type[] getParameterTypes();

        protected abstract Member getFactory();

        protected void bind(LookupContext context) {
            Type[] parameterTypes = this.getParameterTypes();
            if (parameterTypes.length == 0) {
                this.paramProviders = NO_DEPENDENTS;
                return;
            }
            this.paramProviders = new ServiceProvider[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type paramType = parameterTypes[i];
                try {
                    if (paramType.equals(ServiceRegistry.class)) {
                        this.paramProviders[i] = DefaultServiceRegistry.this.getThisAsProvider();
                        continue;
                    }
                    ServiceProvider paramProvider = context.find(paramType, DefaultServiceRegistry.this.allServices);
                    if (paramProvider == null) {
                        throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), DefaultServiceRegistry.format(paramType)));
                    }
                    this.paramProviders[i] = paramProvider;
                    paramProvider.requiredBy(this);
                    continue;
                }
                catch (ServiceValidationException e) {
                    throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as there is a problem with parameter #%s of type %s.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), i + 1, DefaultServiceRegistry.format(paramType)), e);
                }
            }
        }

        protected Object create() {
            Object[] params = this.assembleParameters();
            Object result = this.invokeMethod(params);
            this.paramProviders = null;
            return result;
        }

        private Object[] assembleParameters() {
            if (this.paramProviders == NO_DEPENDENTS) {
                return NO_PARAMS;
            }
            Object[] params = new Object[this.paramProviders.length];
            for (int i = 0; i < this.paramProviders.length; ++i) {
                ServiceProvider paramProvider = this.paramProviders[i];
                params[i] = paramProvider.get();
            }
            return params;
        }

        protected abstract Object invokeMethod(Object[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SingletonService
    extends ManagedObjectProvider<Object>
    implements ServiceProvider {
        final Type serviceType;
        final Class serviceClass;
        Class factoryElementType;
        boolean bound;

        SingletonService(Type serviceType) {
            this.serviceType = serviceType;
            this.serviceClass = DefaultServiceRegistry.unwrap(serviceType);
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public Object get() {
            return this.getInstance();
        }

        private ServiceProvider prepare(LookupContext context) {
            if (!this.bound) {
                this.bind(context);
                this.bound = true;
            }
            return this;
        }

        protected void bind(LookupContext context) {
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            if (!serviceType.isSatisfiedBy(this.serviceType)) {
                return null;
            }
            return this.prepare(context);
        }

        @Override
        public void getAll(LookupContext context, Class<?> serviceType, List<ServiceProvider> result) {
            if (serviceType.isAssignableFrom(this.serviceClass)) {
                result.add(this.prepare(context));
            }
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> elementType) {
            if (!this.isFactory(this.serviceType, elementType)) {
                return null;
            }
            return this.prepare(context);
        }

        private boolean isFactory(Type type, Class<?> elementType) {
            Type actualType;
            ParameterizedType parameterizedType;
            Class c = DefaultServiceRegistry.unwrap(type);
            if (!Factory.class.isAssignableFrom(c)) {
                return false;
            }
            if (this.factoryElementType != null) {
                return elementType.isAssignableFrom(this.factoryElementType);
            }
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Factory.class) && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class) {
                this.factoryElementType = (Class)actualType;
                return elementType.isAssignableFrom((Class)actualType);
            }
            for (Type interfaceType : c.getGenericInterfaces()) {
                if (!this.isFactory(interfaceType, elementType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasService(Class<?> type) {
            return type.isAssignableFrom(this.serviceClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ManagedObjectProvider<T>
    implements Provider {
        private T instance;
        private Set<Provider> dependents;

        private ManagedObjectProvider() {
        }

        protected void setInstance(T instance) {
            this.instance = instance;
        }

        public T getInstance() {
            if (this.instance == null) {
                this.instance = this.create();
                assert (this.instance != null) : String.format("create() of %s returned null", this.toString());
            }
            return this.instance;
        }

        protected abstract T create();

        public void requiredBy(Provider provider) {
            if (this.dependents == null) {
                this.dependents = new HashSet<Provider>();
            }
            this.dependents.add(provider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                if (this.instance != null) {
                    CompositeStoppable.stoppable(this.dependents == null ? Collections.emptyList() : this.dependents).add(this.instance).stop();
                }
                Object var2_1 = null;
                if (this.dependents != null) {
                    this.dependents.clear();
                }
                this.instance = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.dependents != null) {
                    this.dependents.clear();
                }
                this.instance = null;
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnServices
    implements Provider {
        private List<Provider> providers;
        private Set<Class<?>> serviceTypes;

        private OwnServices() {
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            if (!this.hasService(Factory.class)) {
                return null;
            }
            ArrayList<ServiceProvider> candidates = new ArrayList<ServiceProvider>();
            for (Provider provider : this.providers) {
                ServiceProvider factory = provider.getFactory(context, type);
                if (factory == null) continue;
                candidates.add(factory);
            }
            if (candidates.size() == 0) {
                return null;
            }
            if (candidates.size() == 1) {
                return (ServiceProvider)candidates.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (ServiceProvider candidate : candidates) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple factories for objects of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            if (!this.hasService(DefaultServiceRegistry.unwrap(serviceType.getType()))) {
                return null;
            }
            ServiceProvider singleCandidate = null;
            ArrayList<ServiceProvider> candidates = null;
            for (Provider provider : this.providers) {
                ServiceProvider service = provider.getService(context, serviceType);
                if (service == null) continue;
                if (singleCandidate == null) {
                    singleCandidate = service;
                    continue;
                }
                if (candidates == null) {
                    candidates = new ArrayList<ServiceProvider>(2);
                    candidates.add(singleCandidate);
                }
                candidates.add(service);
            }
            if (candidates == null && singleCandidate == null) {
                return null;
            }
            if (candidates == null) {
                return singleCandidate;
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (ServiceProvider candidate : candidates) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple services of type %s available in %s:", DefaultServiceRegistry.format(serviceType.getType()), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public void getAll(LookupContext context, Class<?> serviceType, List<ServiceProvider> result) {
            if (!this.hasService(serviceType)) {
                return;
            }
            for (Provider provider : this.providers) {
                provider.getAll(context, serviceType, result);
            }
        }

        @Override
        public boolean hasService(Class<?> serviceType) {
            return this.serviceTypes != null && this.serviceTypes.contains(serviceType);
        }

        @Override
        public void stop() {
            if (this.providers == null) {
                return;
            }
            CompositeStoppable.stoppable(this.providers).stop();
        }

        public void add(Provider provider) {
            DefaultServiceRegistry.this.assertMutable();
            if (this.providers == null) {
                this.providers = new ArrayList<Provider>();
                this.serviceTypes = new HashSet();
                this.serviceTypes.add(Object.class);
            }
            this.providers.add(provider);
            if (!(provider instanceof SingletonService)) {
                throw new UnsupportedOperationException("Unsupported service provider type: " + provider);
            }
            this.addServiceType(((SingletonService)provider).serviceClass);
        }

        private void addServiceType(Class<?> serviceType) {
            if (serviceType != null && this.serviceTypes.add(serviceType)) {
                this.addServiceType(serviceType.getSuperclass());
                Class<?>[] interfaces = serviceType.getInterfaces();
                if (interfaces != null) {
                    for (Class<?> intf : interfaces) {
                        this.addServiceType(intf);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Provider
    extends Stoppable {
        public ServiceProvider getService(LookupContext var1, TypeSpec var2);

        public ServiceProvider getFactory(LookupContext var1, Class<?> var2);

        public void getAll(LookupContext var1, Class<?> var2, List<ServiceProvider> var3);

        public boolean hasService(Class<?> var1);
    }

    static interface ServiceProvider {
        public String getDisplayName();

        public Object get();

        public void requiredBy(Provider var1);
    }
}

