/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.text;

import org.gradle.internal.logging.text.AbstractStyledTextOutput;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeFormatter
extends TreeVisitor<String> {
    private final StringBuilder buffer = new StringBuilder();
    private final AbstractStyledTextOutput original = new AbstractStyledTextOutput(){

        protected void doAppend(String text) {
            TreeFormatter.this.buffer.append(text);
        }
    };
    private Node current = new Node();

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void node(String node) {
        if (this.current.state == State.TraverseChildren) {
            this.current = new Node(this.current, node);
        } else {
            this.current.state = State.Done;
            this.current = new Node(this.current.parent, node);
        }
        if (this.current.isTopLevelNode()) {
            if (this.current != this.current.parent.firstChild) {
                this.original.format("%n", new Object[0]);
            }
            this.original.append(node);
            this.current.valueWritten = true;
        }
    }

    public void append(CharSequence text) {
        if (this.current.state == State.CollectValue) {
            if (this.current.valueWritten) {
                this.original.append(text);
            } else {
                this.current.value.append(text);
            }
        } else {
            throw new IllegalStateException("Cannot append text to node.");
        }
    }

    @Override
    public void startChildren() {
        if (this.current.state != State.CollectValue) {
            throw new IllegalStateException("Cannot start children again");
        }
        this.current.state = State.TraverseChildren;
    }

    @Override
    public void endChildren() {
        if (this.current.parent == null) {
            throw new IllegalStateException("Not visiting any node.");
        }
        if (this.current.state == State.CollectValue) {
            this.current.state = State.Done;
            this.current = this.current.parent;
        }
        if (this.current.state != State.TraverseChildren) {
            throw new IllegalStateException("Cannot end children.");
        }
        if (this.current.isTopLevelNode()) {
            this.writeNode(this.current);
        }
        this.current.state = State.Done;
        this.current = this.current.parent;
    }

    private void writeNode(Node node) {
        if (node.prefix == null) {
            node.prefix = node.isTopLevelNode() ? "" : node.parent.prefix + "    ";
        }
        LinePrefixingStyledTextOutput output = new LinePrefixingStyledTextOutput(this.original, node.prefix, false);
        if (!node.valueWritten) {
            output.append(node.parent.prefix);
            output.append("  - ");
            output.append(node.value);
        }
        if (node.canCollapseFirstChild()) {
            output.append(": ");
            Node firstChild = node.firstChild;
            output.append(firstChild.value);
            firstChild.valueWritten = true;
            firstChild.prefix = node.prefix;
            this.writeNode(firstChild);
        } else if (node.firstChild != null) {
            this.original.format(":%n", new Object[0]);
            this.writeNode(node.firstChild);
        }
        if (node.nextSibling != null) {
            this.original.format("%n", new Object[0]);
            this.writeNode(node.nextSibling);
        }
    }

    private static class Node {
        final Node parent;
        final StringBuilder value;
        Node firstChild;
        Node lastChild;
        Node nextSibling;
        String prefix;
        State state;
        boolean valueWritten;

        private Node() {
            this.parent = null;
            this.value = null;
            this.prefix = "";
            this.state = State.TraverseChildren;
        }

        private Node(Node parent, String value) {
            this.parent = parent;
            this.value = new StringBuilder(value);
            this.state = State.CollectValue;
            if (parent.firstChild == null) {
                parent.firstChild = this;
                parent.lastChild = this;
            } else {
                parent.lastChild.nextSibling = this;
                parent.lastChild = this;
            }
        }

        boolean canCollapseFirstChild() {
            return this.firstChild != null && this.firstChild.nextSibling == null && !this.firstChild.canCollapseFirstChild();
        }

        boolean isTopLevelNode() {
            return this.parent.parent == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CollectValue,
        TraverseChildren,
        Done;

    }
}

