/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.specs.Specs;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.model.ModelSet;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelViewState;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NoInputsModelAction;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBackedModelSet<T>
implements ModelSet<T>,
ManagedInstance {
    private final ModelType<T> elementType;
    private final ModelRuleDescriptor descriptor;
    private final MutableModelNode modelNode;
    private final ModelViewState state;
    private final ChildNodeInitializerStrategy<T> creatorStrategy;
    private final ModelReference<T> elementTypeReference;
    private final ModelType<?> publicType;
    private Collection<T> elements;

    public NodeBackedModelSet(ModelType<?> publicType, ModelType<T> elementType, ModelRuleDescriptor descriptor, MutableModelNode modelNode, ModelViewState state, ChildNodeInitializerStrategy<T> creatorStrategy) {
        this.publicType = publicType;
        this.elementType = elementType;
        this.elementTypeReference = ModelReference.of(elementType);
        this.descriptor = descriptor;
        this.modelNode = modelNode;
        this.state = state;
        this.creatorStrategy = creatorStrategy;
    }

    @Override
    public MutableModelNode getBackingNode() {
        return this.modelNode;
    }

    @Override
    public ModelType<?> getManagedType() {
        return ModelType.of(this.getClass());
    }

    @Override
    public String getName() {
        return this.modelNode.getPath().getName();
    }

    @Override
    public String getDisplayName() {
        return this.publicType.getDisplayName() + " '" + this.modelNode.getPath() + "'";
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void create(Action<? super T> action) {
        this.state.assertCanMutate();
        String name = String.valueOf(this.modelNode.getLinkCount(ModelNodes.withType(this.elementType)));
        ModelPath childPath = this.modelNode.getPath().child(name);
        ModelRuleDescriptor descriptor = this.descriptor.append("create()");
        NodeInitializer nodeInitializer = this.creatorStrategy.initializer(this.elementType, Specs.<ModelType<?>>satisfyAll());
        ModelRegistration registration = ModelRegistrations.of(childPath, nodeInitializer).descriptor(descriptor).action(ModelActionRole.Initialize, NoInputsModelAction.of(ModelReference.of(childPath, this.elementType), descriptor, action)).build();
        this.modelNode.addLink(registration);
    }

    @Override
    public void afterEach(Action<? super T> configAction) {
        this.state.assertCanMutate();
        this.modelNode.applyTo(NodePredicate.allLinks(), ModelActionRole.Finalize, NoInputsModelAction.of(this.elementTypeReference, this.descriptor.append("afterEach()"), configAction));
    }

    @Override
    public void beforeEach(Action<? super T> configAction) {
        this.state.assertCanMutate();
        this.modelNode.applyTo(NodePredicate.allLinks(), ModelActionRole.Defaults, NoInputsModelAction.of(this.elementTypeReference, this.descriptor.append("afterEach()"), configAction));
    }

    @Override
    public int size() {
        this.state.assertCanReadChildren();
        return this.modelNode.getLinkCount(ModelNodes.withType(this.elementType));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.getElements().contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getElements().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getElements().toArray(a);
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getElements().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void create(Closure<?> closure) {
        this.create(ClosureBackedAction.of(closure));
    }

    @Override
    public void afterEach(Closure<?> closure) {
        this.afterEach(ClosureBackedAction.of(closure));
    }

    @Override
    public void beforeEach(Closure<?> closure) {
        this.beforeEach(ClosureBackedAction.of(closure));
    }

    private Collection<T> getElements() {
        this.state.assertCanReadChildren();
        if (this.elements == null) {
            this.elements = Lists.newArrayList((Iterable)Iterables.transform(this.modelNode.getLinks(ModelNodes.withType(this.elementType)), (Function)new Function<MutableModelNode, T>(){

                public T apply(MutableModelNode input) {
                    return input.asImmutable(NodeBackedModelSet.this.elementType, NodeBackedModelSet.this.descriptor).getInstance();
                }
            }));
        }
        return this.elements;
    }
}

